/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.mpEdit;

import de.uni_paderborn.fujaba.mpEdit.DocMan;
import de.uni_paderborn.fujaba.mpEdit.Progress;
import de.uni_paderborn.fujaba.mpEdit.TextFrame;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.util.Vector;

public class PrintMan
extends Thread {
    private PrintJob pjob;
    private Vector spool;
    private Font font;
    private TextFrame parent;
    private String jobName;
    private int tabsize;
    private final int PRINT_PROGRESS = 10000;

    public PrintMan(TextFrame p, DocMan docMan, String n, Font f, int t) {
        this.parent = p;
        this.jobName = n;
        this.font = f;
        this.tabsize = t;
        int max = docMan.getLineCount();
        this.spool = new Vector(max);
        int tens = max / 10;
        int part = 0;
        Progress spoolProgress = null;
        if (max > 10000) {
            spoolProgress = new Progress(this.parent, "Saving print copy ... ");
            spoolProgress.show();
        }
        int i = 0;
        while (i < max) {
            this.spool.addElement(docMan.getLine(i));
            if (max > 10000) {
                ++part;
            }
            if (part > tens) {
                spoolProgress.update(100 * i / max);
                part = 0;
            }
            ++i;
        }
        if (spoolProgress != null) {
            spoolProgress.dispose();
        }
    }

    public void run() {
        this.pjob = this.parent.getToolkit().getPrintJob(this.parent, this.jobName, null);
        if (this.pjob == null) {
            return;
        }
        Graphics pg = this.pjob.getGraphics();
        if (pg != null) {
            int pageHeight = this.pjob.getPageDimension().height;
            pg.setFont(this.font);
            FontMetrics fm = pg.getFontMetrics(this.font);
            int fontHeight = fm.getHeight();
            int fontDescent = fm.getDescent();
            int curHeight = 0;
            int i = 0;
            while (i < this.spool.size()) {
                if ((curHeight += fontHeight) > pageHeight) {
                    pg.dispose();
                    pg = this.pjob.getGraphics();
                    if (pg == null) {
                        return;
                    }
                    pg.setFont(this.font);
                    curHeight = fontHeight;
                }
                String nextLine = this.detabbed((String)this.spool.elementAt(i), this.tabsize);
                pg.drawString(nextLine, 0, curHeight - fontDescent);
                ++i;
            }
            pg.dispose();
        }
        this.pjob.end();
    }

    private String detabbed(String s, int tabSize) {
        if (s.indexOf(9) < 0) {
            return s;
        }
        String t = "";
        int j = 0;
        int max = s.length();
        int i = 0;
        while (i < max) {
            char c = s.charAt(i);
            if (c == '\t') {
                int tabs = tabSize - j % tabSize;
                j += tabs;
                while (tabs-- > 0) {
                    t = String.valueOf(t) + ' ';
                }
            } else {
                t = String.valueOf(t) + c;
                ++j;
            }
            ++i;
        }
        return t;
    }
}

