/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.io.IOException;
import java.io.InputStream;

public class ManifestItem {
    private String[] keys;
    private String[] values;
    private int nkeys;

    public String findValue(String k) {
        int i = 0;
        while (i < this.nkeys) {
            if (k.equalsIgnoreCase(this.keys[i])) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    private void grow() {
        if (this.keys == null || this.nkeys >= this.keys.length) {
            String[] nk = new String[this.nkeys + 4];
            String[] nv = new String[this.nkeys + 4];
            if (this.keys != null) {
                System.arraycopy(this.keys, 0, nk, 0, this.nkeys);
            }
            if (this.values != null) {
                System.arraycopy(this.values, 0, nv, 0, this.nkeys);
            }
            this.keys = nk;
            this.values = nv;
        }
    }

    public void add(String k, String v) {
        this.grow();
        this.keys[this.nkeys] = k;
        this.values[this.nkeys] = v;
        ++this.nkeys;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean read(InputStream is) throws IOException {
        boolean eof = false;
        this.nkeys = 0;
        if (is == null) {
            return false;
        }
        char[] s = new char[10];
        int firstc = is.read();
        if (firstc < 0) {
            eof = true;
        }
        while (firstc != 10 && firstc != 13 && firstc >= 0) {
            String k;
            int keyend;
            int len;
            block23: {
                int c;
                len = 0;
                keyend = -1;
                boolean inKey = firstc > 32;
                s[len++] = (char)firstc;
                while ((c = is.read()) >= 0) {
                    if (c < 0) {
                        eof = true;
                    }
                    switch (c) {
                        case 58: {
                            if (inKey && len > 0) {
                                keyend = len;
                            }
                            inKey = false;
                            break;
                        }
                        case 9: {
                            c = 32;
                        }
                        case 32: {
                            inKey = false;
                            break;
                        }
                        case 10: 
                        case 13: {
                            firstc = is.read();
                            if (firstc < 0) {
                                eof = true;
                            }
                            if (c == 13 && firstc == 10) {
                                firstc = is.read();
                                if (firstc == 13) {
                                    firstc = is.read();
                                }
                                if (firstc < 0) {
                                    eof = true;
                                }
                            }
                            if (firstc == 10 || firstc == 13 || firstc > 32) break block23;
                            c = 32;
                        }
                    }
                    if (len >= s.length) {
                        char[] ns = new char[s.length * 2];
                        System.arraycopy(s, 0, ns, 0, len);
                        s = ns;
                    }
                    s[len++] = (char)c;
                }
                firstc = -1;
            }
            while (len > 0 && s[len - 1] <= ' ') {
                --len;
            }
            if (keyend <= 0) {
                k = null;
                keyend = 0;
            } else {
                k = String.copyValueOf(s, 0, keyend);
                if (keyend < len && s[keyend] == ':') {
                    ++keyend;
                }
                while (keyend < len && s[keyend] <= ' ') {
                    ++keyend;
                }
            }
            String v = keyend >= len ? "" : String.copyValueOf(s, keyend, len - keyend);
            this.add(k, v);
        }
        if (!eof) return true;
        return false;
    }

    public String toString() {
        String result = super.toString();
        int i = 0;
        while (i < this.keys.length) {
            result = String.valueOf(result) + "{" + this.keys[i] + ": " + this.values[i] + "}\n";
            ++i;
        }
        return result;
    }
}

