/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.mpEdit;

import de.uni_paderborn.fujaba.mpEdit.LineInfo;
import de.uni_paderborn.fujaba.mpEdit.LineMan;
import java.awt.Color;

public class Hilite {
    LineMan lines;
    int tabSize;
    int highestEver;
    boolean inComment;
    boolean inLiteral;
    boolean initialComment;
    boolean initialLiteral;
    boolean inactive;
    boolean raise;
    char[][] keys;
    int keyCt;
    int[] keyStarts = new int[100];
    int[] keyEnds = new int[100];
    byte[] keyTypes = new byte[100];
    char[] buffer;
    public static final byte PLAIN = 0;
    public static final byte KEYWORD = 1;
    public static final byte COMMENT = 2;
    public static final byte QUOTE = 3;
    public static final byte HIDE = 100;
    protected Color textColor = new Color(0);
    protected Color textXColor = new Color(0xFFFFFF);
    protected Color commentColor = new Color(36864);
    protected Color commentXColor = new Color(0xFF6FFF);
    protected Color keywordColor = new Color(176);
    protected Color keywordXColor = new Color(0xFFFF4F);
    protected Color quoteColor = new Color(0xA00000);
    protected Color quoteXColor = new Color(0x5FFFFF);
    protected Color hideColor = new Color(200, 200, 200);
    protected Color hideXColor = new Color(55, 55, 55);

    public Hilite(LineMan l, int t, boolean a) {
        this.lines = l;
        this.inactive = a;
        this.highestEver = -1;
        this.raise = false;
        this.initialComment = false;
        this.tabSize = t > 0 ? t : 4;
    }

    public void scan(int highest) {
        this.highestEver = -1;
        this.inComment = this.initialComment;
        this.inLiteral = this.initialLiteral;
        int i = 0;
        while (i <= highest) {
            this.scanLine(i);
            ++i;
        }
        this.highestEver = highest;
    }

    public void extendScan(int highest) {
        if (highest <= this.highestEver) {
            return;
        }
        if (this.highestEver >= 0) {
            LineInfo hi = this.lines.getLineInfo(this.highestEver);
            this.inComment = hi.inComment;
            this.inLiteral = hi.inLiteral;
        } else {
            this.inComment = this.initialComment;
            this.inLiteral = this.initialLiteral;
        }
        int i = this.highestEver + 1;
        while (i <= highest) {
            this.scanLine(i);
            ++i;
        }
        this.highestEver = highest;
    }

    public int update(int first, int last, int highest) {
        LineInfo hi;
        boolean oldComment = false;
        boolean oldLiteral = false;
        if (this.inactive) {
            return last;
        }
        if (first > 0) {
            hi = this.lines.getLineInfo(first - 1);
            this.inComment = hi.inComment;
            this.inLiteral = hi.inLiteral;
        } else {
            this.inComment = this.initialComment;
            this.inLiteral = this.initialLiteral;
        }
        int i = this.lines.size() - 1;
        if (last > i) {
            last = i;
        }
        i = first;
        while (i <= last) {
            this.scanLine(i);
            ++i;
        }
        if (highest < this.highestEver) {
            this.highestEver = highest;
        }
        while (i <= this.highestEver) {
            hi = this.lines.getLineInfo(i);
            oldComment = hi.inComment;
            oldLiteral = hi.inLiteral;
            this.scanLine(i++);
            if (oldComment == this.inComment && oldLiteral == this.inLiteral) break;
        }
        return i - 2;
    }

    protected void scanLine(int i) {
        LineInfo li = this.lines.getLineInfo(i);
        li.inComment = false;
        li.inLiteral = false;
        li.keyCt = 0;
        li.keyStarts = null;
        li.keyEnds = null;
        li.keyTypes = null;
    }

    public void lineRemoved(int i) {
        if (i <= this.highestEver) {
            --this.highestEver;
        }
    }

    protected int matchOneKey(int key, int start, int end) {
        char[] theKey = this.keys[key];
        int i = 0;
        int j = start;
        int max = theKey.length;
        while (i < max && j < end) {
            char c = theKey[i++];
            char d = this.buffer[j++];
            if (this.raise && d >= 'a' && d <= 'z') {
                d = (char)(d + 65 - 97);
            }
            if (c > d) {
                return -1;
            }
            if (c >= d) continue;
            return 1;
        }
        if (i < max) {
            return -1;
        }
        if (j < end) {
            return 1;
        }
        return 0;
    }

    protected boolean matchKeys(int start, int end) {
        int max;
        int j = 0;
        int i = 0;
        int diff = max = this.keys.length;
        while ((diff >>= 1) != 0) {
            i = j < 0 ? (i -= diff) : (i += diff);
            j = this.matchOneKey(i, start, end);
            if (j != 0) continue;
            return true;
        }
        int extra = 4;
        while (extra-- > 0) {
            i = j < 0 ? --i : ++i;
            if (i < 0 || i >= max) {
                return false;
            }
            j = this.matchOneKey(i, start, end);
            if (j != 0) continue;
            return true;
        }
        return false;
    }

    protected int fillBuffer(int line_no) {
        char[] before = this.lines.getString(line_no).toCharArray();
        int max = before.length;
        int i = 0;
        int j = 0;
        while (i < max) {
            if (before[i] == '\t') {
                ++j;
            }
            ++i;
        }
        if (j == 0) {
            this.buffer = before;
            j = max;
        } else {
            this.buffer = new char[max + j * (this.tabSize - 1)];
            i = 0;
            j = 0;
            while (i < max) {
                char c = before[i];
                if (c == '\t') {
                    int tabs = this.tabSize - j % this.tabSize;
                    while (tabs-- > 0) {
                        this.buffer[j++] = 32;
                    }
                } else {
                    this.buffer[j++] = c;
                }
                ++i;
            }
        }
        return j;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public Color getTextXColor() {
        return this.textXColor;
    }

    public Color getCommentColor() {
        return this.commentColor;
    }

    public Color getCommentXColor() {
        return this.commentXColor;
    }

    public Color getKeywordColor() {
        return this.keywordColor;
    }

    public Color getKeywordXColor() {
        return this.keywordXColor;
    }

    public Color getQuoteColor() {
        return this.quoteColor;
    }

    public Color getQuoteXColor() {
        return this.quoteXColor;
    }

    public Color getHideColor() {
        return this.hideColor;
    }

    public Color getHideXColor() {
        return this.hideXColor;
    }
}

