/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.mpEdit;

import de.uni_paderborn.fujaba.mpEdit.NotFoundDialog;
import de.uni_paderborn.fujaba.mpEdit.TextFrame;
import de.uni_paderborn.fujaba.mpEdit.TextMenu;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

class FindDialog
extends JDialog
implements WindowListener,
ActionListener,
KeyListener {
    private JButton fbutton;
    private JButton cbutton;
    private TextMenu textMenu;
    private TextFrame textFrame;
    private JTextField pattern;
    private ResourceBundle strings;
    private String pat;

    public FindDialog(TextFrame tf, TextMenu tm, ResourceBundle str, String title) {
        super(tf, title, false);
        this.setBackground(Color.lightGray);
        this.textFrame = tf;
        this.textMenu = tm;
        this.strings = str;
        JPanel p1 = new JPanel();
        p1.add(new Label(this.strings.getString("PromptFind")));
        this.pat = this.textFrame.getCanvas().getLatestSearchPattern();
        this.pattern = new JTextField(this.pat, 20);
        p1.add(this.pattern);
        this.getContentPane().add("Center", p1);
        JPanel p2 = new JPanel();
        this.fbutton = new JButton(this.strings.getString("ButtonFindNext"));
        this.fbutton.addActionListener(this);
        p2.add(this.fbutton);
        this.cbutton = new JButton(this.strings.getString("ButtonClose"));
        this.cbutton.addActionListener(this);
        p2.add(this.cbutton);
        this.getContentPane().add("South", p2);
        this.pack();
        Dimension size = this.getSize();
        this.setLocation(this.textFrame.getPlace(size));
        this.pattern.requestFocus();
        this.pattern.selectAll();
        this.pattern.addKeyListener(this);
        this.addWindowListener(this);
    }

    public void executeFind() {
        if (!this.textFrame.getCanvas().find(this.pattern.getText())) {
            NotFoundDialog nf = new NotFoundDialog(this.textFrame, this.strings);
            nf.show();
        }
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.textMenu.CloseFindDialog(this.pattern.getText());
        this.dispose();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.cbutton) {
            this.textMenu.CloseFindDialog(this.pattern.getText());
            this.dispose();
            return;
        }
        if (evt.getSource() == this.fbutton) {
            this.executeFind();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.executeFind();
        } else if (e.getKeyCode() == 27) {
            this.textMenu.CloseFindDialog(this.pattern.getText());
            this.dispose();
            return;
        }
    }
}

