/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.layout.classdiag.internalmodel;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class LayoutHelper {
    public static final int NORTH = 0;
    public static final int NORTHEAST = 1;
    public static final int EAST = 2;
    public static final int SOUTHEAST = 4;
    public static final int SOUTH = 8;
    public static final int SOUTHWEST = 16;
    public static final int WEST = 32;
    public static final int NORTHWEST = 64;

    public static Point getPointOnPerimeter(Rectangle rect, int direction) {
        return LayoutHelper.getPointOnPerimeter(rect, direction, 0.0, 0.0);
    }

    public static Point getPointOnPerimeter(Rectangle rect, int direction, double xOff, double yOff) {
        double x = 0.0;
        double y = 0.0;
        if (direction == 0 || direction == 1 || direction == 64) {
            y = rect.getY();
        }
        if (direction == 8 || direction == 16 || direction == 4) {
            y = rect.getY() + rect.getHeight();
        }
        if (direction == 2 || direction == 32) {
            y = rect.getY() + rect.getHeight() / 2.0;
        }
        if (direction == 64 || direction == 32 || direction == 16) {
            x = rect.getX();
        }
        if (direction == 1 || direction == 2 || direction == 4) {
            x = rect.getX() + rect.getWidth();
        }
        if (direction == 0 || direction == 8) {
            x = rect.getX() + rect.getWidth() / 2.0;
        }
        return new Point((int)(x += xOff), (int)(y += yOff));
    }

    public static Polygon getRoutingPolygonStraightLine(Point start, Point end) {
        return LayoutHelper.getRoutingPolygonStraightLineWithOffset(start, end, 0);
    }

    public static Polygon getRoutingPolygonStraightLineWithOffset(Point start, Point end, int offset) {
        Polygon newPoly = new Polygon();
        newPoly.addPoint((int)start.getX(), (int)start.getY());
        if (offset != 0) {
            double newY = 0.0;
            if (offset < 0) {
                newY = Math.min(start.getY() + (double)offset, end.getY() + (double)offset);
            }
            if (offset > 0) {
                newY = Math.max(start.getY() + (double)offset, end.getY() + (double)offset);
            }
            newPoly.addPoint((int)start.getX(), (int)newY);
            newPoly.addPoint((int)end.getX(), (int)newY);
        }
        newPoly.addPoint((int)end.getX(), (int)end.getY());
        return newPoly;
    }
}

