/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.layout.classdiag;

import de.uni_paderborn.fujaba.fsa.FSAPanel;
import de.uni_paderborn.fujaba.layout.classdiag.internalmodel.LayoutedNode;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Vector;

class ClassdiagramNode
implements LayoutedNode {
    public static final int NORANK = -1;
    private int rank = -1;
    public static final int NOCOLUMN = -1;
    private int column = -1;
    private Vector uplinks = new Vector();
    private Vector downlinks = new Vector();
    private FSAPanel figure = null;
    private float weight = 1.0f;
    private int placementHint = -1;

    public ClassdiagramNode(FSAPanel f) {
        this.setFigure(f);
    }

    public Dimension getSize() {
        return this.getFigure().getSize();
    }

    public Point getLocation() {
        return this.getFigure().getLocation();
    }

    public void setLocation(Point newLocation) {
        this.getFigure().setLocation(newLocation);
    }

    boolean isPackage() {
        return false;
    }

    public int getRealRank() {
        return this.rank;
    }

    public int getRank() {
        if (this.rank == -1) {
            if (this.getUplinks().size() == 0) {
                this.rank = 0;
            } else {
                int i = 0;
                while (i < this.getUplinks().size()) {
                    if (this.getUplink(i) == this) {
                        return this.rank;
                    }
                    if (this.getUplink(i).getRank() + 1 > this.rank) {
                        this.rank = this.getUplink(i).getRank() + 1;
                    }
                    ++i;
                }
            }
        }
        return this.rank;
    }

    public void setRank(int newRank) {
        this.rank = newRank;
    }

    public void addRank(int n) {
        this.setRank(n + this.getRank());
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int newColumn) {
        this.column = newColumn;
    }

    public Vector getUplinks() {
        return this.uplinks;
    }

    public ClassdiagramNode getUplink(int i) {
        return (ClassdiagramNode)this.uplinks.elementAt(i);
    }

    public void addUplink(ClassdiagramNode newUplink) {
        this.uplinks.add(newUplink);
    }

    public Vector getDownlinks() {
        return this.downlinks;
    }

    public ClassdiagramNode getDownlink(int i) {
        return (ClassdiagramNode)this.downlinks.elementAt(i);
    }

    public void addDownlink(ClassdiagramNode newDownlink) {
        this.downlinks.add(newDownlink);
    }

    public FSAPanel getFigure() {
        return this.figure;
    }

    public void setFigure(FSAPanel newFigure) {
        this.figure = newFigure;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float w) {
        this.weight = w;
    }

    public boolean isMovable() {
        return this.downlinks.size() == 0 && this.uplinks.size() == 0;
    }

    public void setPlacementHint(int hint) {
        this.placementHint = hint;
    }

    public int getPlacementHint() {
        return this.placementHint;
    }
}

