/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.layout;

import de.uni_paderborn.fujaba.app.ProgressBarWrapper;
import de.uni_paderborn.fujaba.fsa.FSABendLine;
import de.uni_paderborn.fujaba.fsa.FSAContainer;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.FSAPanel;
import de.uni_paderborn.fujaba.layout.AbstractLayouter;
import de.uni_paderborn.fujaba.layout.options.LayoutPreferences;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import java.awt.Point;
import java.util.Iterator;
import java.util.Map;

public class SpringEmbedderLayout
extends AbstractLayouter {
    private static SpringEmbedderLayout myLayouter = null;
    static final int minDist = 100;
    private FHashMap preferredPos;

    private SpringEmbedderLayout() {
    }

    public static SpringEmbedderLayout get() {
        if (myLayouter == null) {
            myLayouter = new SpringEmbedderLayout();
        }
        return myLayouter;
    }

    private void springEmbedderLayout(FSAContainer currentCanvas) {
        int vy;
        int vx;
        Object myElement;
        Iterator myIter = currentCanvas.iteratorOfChildren();
        int xCorrection = 0;
        int yCorrection = 0;
        FSAObject fromFrame = null;
        FSAObject toFrame = null;
        FSABendLine myLine = null;
        int len = 0;
        while (myIter.hasNext()) {
            myElement = myIter.next();
            if (!(myElement instanceof FSABendLine) || !(myLine = (FSABendLine)myElement).isVisible()) continue;
            fromFrame = this.getFromToFrame(myLine, 1);
            toFrame = this.getFromToFrame(myLine, 2);
            if (fromFrame == null || toFrame == null) continue;
            vx = toFrame.getLocation().x - fromFrame.getLocation().x;
            vy = toFrame.getLocation().y - fromFrame.getLocation().y;
            len = (int)Math.sqrt(vx * vx + vy * vy);
            double f = (double)(this.getPreferredLen(myLine) - len) / (double)(len * 3);
            int dx = (int)(f * (double)vx);
            int dy = (int)(f * (double)vy);
            Point leftPoint = myLine.getStartPoint();
            Point rightPoint = myLine.getEndPoint();
            int xDiff = rightPoint.x - leftPoint.x;
            double absXDiff = Math.abs(xDiff);
            int yDiff = rightPoint.y - leftPoint.y;
            double absYDiff = Math.abs(yDiff);
            if (absXDiff >= 20.0 && absYDiff / absXDiff < 0.2) {
                dy -= yDiff / 2;
                if (Math.abs(yDiff) == 1) {
                    yCorrection = -1;
                }
            }
            if (absYDiff >= 20.0 && absXDiff / absYDiff < 0.2) {
                dx -= xDiff / 2;
                if (Math.abs(xDiff) == 1) {
                    xCorrection = -1;
                }
            }
            Point newPos = new Point(this.getFromPreferredPos((FSAObject)toFrame).x + dx + xCorrection, this.getFromPreferredPos((FSAObject)toFrame).y + dy + yCorrection);
            this.addToPreferredPos(toFrame, newPos);
            newPos = new Point(this.getFromPreferredPos((FSAObject)fromFrame).x - dx, this.getFromPreferredPos((FSAObject)fromFrame).y - dy);
            this.addToPreferredPos(fromFrame, newPos);
        }
        myIter = currentCanvas.iteratorOfChildren();
        while (myIter.hasNext()) {
            myElement = myIter.next();
            if (!(myElement instanceof FSAPanel) || !((FSAObject)myElement).isVisible()) continue;
            int dx = 0;
            int dy = 0;
            Iterator mySistersnBrothersIter = currentCanvas.iteratorOfChildren();
            while (mySistersnBrothersIter.hasNext()) {
                Object mySister = mySistersnBrothersIter.next();
                if (mySister == myElement || !(mySister instanceof FSAPanel) || !((FSAObject)mySister).isVisible()) continue;
                vx = ((FSAObject)myElement).getLocation().x - ((FSAObject)mySister).getLocation().x;
                vy = ((FSAObject)myElement).getLocation().y - ((FSAObject)mySister).getLocation().y;
                int lenSquare = vx * vx + vy * vy;
                if (lenSquare == 0) {
                    dx = (int)((double)dx + (Math.random() * 40.0 - 20.0));
                    dy = (int)((double)dy + (Math.random() * 40.0 - 20.0));
                    continue;
                }
                if (lenSquare >= 10000) continue;
                int dl = (int)(100.0 - Math.sqrt(lenSquare));
                dx = (int)((double)dx + (vx == 0 ? Math.random() * 40.0 - 20.0 : (double)(dl * vx / Math.abs(vx))) / 2.0);
                dy = (int)((double)dy + (vy == 0 ? Math.random() * 40.0 - 20.0 : (double)(dl * vy / Math.abs(vy))) / 2.0);
            }
            double dlen = dx * dx + dy * dy;
            if (!(dlen > 0.0)) continue;
            this.addToPreferredPos((FSAObject)myElement, new Point(this.getFromPreferredPos((FSAObject)((FSAObject)myElement)).x + dx, this.getFromPreferredPos((FSAObject)((FSAObject)myElement)).y + dy));
        }
        myIter = currentCanvas.iteratorOfChildren();
        while (myIter.hasNext()) {
            myElement = myIter.next();
            if (!(myElement instanceof FSAPanel)) continue;
            int x = ((FSAObject)myElement).getLocation().x + Math.max(-5, Math.min(5, this.getFromPreferredPos((FSAObject)((FSAObject)myElement)).x));
            int y = ((FSAObject)myElement).getLocation().y + Math.max(-5, Math.min(5, this.getFromPreferredPos((FSAObject)((FSAObject)myElement)).y));
            ((FSAObject)myElement).setLocation(x, y);
            if (((FSAObject)myElement).getLocation().x < 0) {
                Point myRec = ((FSAObject)myElement).getLocation();
                myRec.x = 0;
                ((FSAObject)myElement).setLocation(0, myRec.y);
            }
            if (((FSAObject)myElement).getLocation().y < 0) {
                Point myRec = ((FSAObject)myElement).getLocation();
                myRec.y = 0;
                ((FSAObject)myElement).setLocation(myRec.x, 0);
            }
            this.addToPreferredPos((FSAObject)myElement, new Point(this.getFromPreferredPos((FSAObject)((FSAObject)myElement)).x / 2, this.getFromPreferredPos((FSAObject)((FSAObject)myElement)).y / 2));
        }
        this.removeAllFromPreferredPos();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reLayout(FSAContainer currentCanvas) throws InterruptedException {
        LayoutPreferences options = LayoutPreferences.get();
        this.setHorizDist(options.getHorizDist());
        this.setVertDist(options.getVertDist());
        this.setPresetAdjustment(options.getStretchFactor());
        int numberIterations = options.getNumberIterations();
        ProgressBarWrapper myProgress = new ProgressBarWrapper(this.getFrame(currentCanvas), "Spring embedder layout", numberIterations);
        myProgress.openWindow();
        try {
            while (numberIterations > 0 && !myProgress.isAborted()) {
                this.springEmbedderLayout(currentCanvas);
                myProgress.increment("Layouter working...");
                --numberIterations;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            myProgress.closeWindow();
            throw throwable;
        }
        {
            Object var5_7 = null;
            myProgress.closeWindow();
            return;
        }
    }

    public int sizeOfPreferredPos() {
        return this.preferredPos == null ? 0 : this.preferredPos.size();
    }

    public void removeYou() {
        super.removeYou();
        this.removeAllFromPreferredPos();
    }

    public boolean removeKeyFromPreferredPos(FSAObject key) {
        Point tmpValue;
        boolean changed = false;
        if (this.preferredPos != null && key != null && (tmpValue = (Point)this.preferredPos.get(key)) != null) {
            this.preferredPos.remove(key);
            changed = true;
        }
        return changed;
    }

    public boolean removeFromPreferredPos(FSAObject key, Point value) {
        Point oldValue;
        boolean changed = false;
        if (this.preferredPos != null && value != null && key != null && (oldValue = (Point)this.preferredPos.get(key)) == value) {
            this.preferredPos.remove(key);
            changed = true;
        }
        return changed;
    }

    public boolean removeFromPreferredPos(Point value) {
        boolean changed = false;
        if (this.preferredPos != null && value != null) {
            Iterator iter = this.entriesOfPreferredPos();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (entry.getValue() != value) continue;
                boolean bl = changed = changed || this.removeFromPreferredPos((FSAObject)entry.getKey(), value);
            }
        }
        return changed;
    }

    public void removeAllFromPreferredPos() {
        Iterator iter = this.entriesOfPreferredPos();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            this.removeFromPreferredPos((FSAObject)entry.getKey(), (Point)entry.getValue());
        }
    }

    public Iterator keysOfPreferredPos() {
        return this.preferredPos == null ? FEmptyIterator.get() : this.preferredPos.keySet().iterator();
    }

    public Iterator iteratorOfPreferredPos() {
        return this.preferredPos == null ? FEmptyIterator.get() : this.preferredPos.values().iterator();
    }

    public boolean hasKeyInPreferredPos(FSAObject key) {
        return this.preferredPos != null && key != null && this.preferredPos.containsKey(key);
    }

    public boolean hasInPreferredPos(FSAObject key, Point value) {
        return this.preferredPos != null && value != null && key != null && this.preferredPos.get(key) == value;
    }

    public boolean hasInPreferredPos(Point value) {
        return this.preferredPos != null && value != null && this.preferredPos.containsValue(value);
    }

    public Point getFromPreferredPos(FSAObject key) {
        Point p = this.preferredPos == null || key == null ? null : (Point)this.preferredPos.get(key);
        return p == null ? new Point(0, 0) : p;
    }

    public Iterator entriesOfPreferredPos() {
        return this.preferredPos == null ? FEmptyIterator.get() : this.preferredPos.entrySet().iterator();
    }

    public boolean addToPreferredPos(FSAObject key, Point value) {
        boolean changed = false;
        if (value != null && key != null) {
            Point oldValue;
            if (this.preferredPos == null) {
                this.preferredPos = new FHashMap();
            }
            if ((oldValue = (Point)this.preferredPos.put(key, value)) != value) {
                changed = true;
            }
        }
        return changed;
    }

    public boolean addToPreferredPos(Map.Entry entry) {
        return this.addToPreferredPos((FSAObject)entry.getKey(), (Point)entry.getValue());
    }
}

