/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.layout;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.basic.SwingWorker;
import de.uni_paderborn.fujaba.fsa.FSAContainer;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.layout.AbstractLayouter;
import de.uni_paderborn.fujaba.layout.ControlFlowLayout;
import de.uni_paderborn.fujaba.layout.SpringEmbedderLayout;
import de.uni_paderborn.fujaba.layout.TreeLayout;
import de.uni_paderborn.fujaba.layout.classdiag.ClassdiagramLayouter;
import de.uni_paderborn.fujaba.layout.options.LayoutPreferences;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLProject;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class MrLayout {
    static final transient Logger log;
    public static final int TREE_LAYOUT = 0;
    public static final int SPRING_EMBEDDER_LAYOUT = 1;
    public static final int CONTROL_FLOW_LAYOUT = 2;
    public static final int CLASS_DIAGRAM_LAYOUT = 3;
    private static MrLayout myMrLayout;
    private int whichLayout;
    private int whichActivityDiagramLayout;
    private AbstractLayouter myLayouter;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.layout.MrLayout");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    private MrLayout() {
    }

    public static MrLayout get() {
        if (myMrLayout == null) {
            myMrLayout = new MrLayout();
        }
        return myMrLayout;
    }

    public void reLayout(FSAContainer currentCanvas) {
        block25: {
            if (currentCanvas == null || currentCanvas.sizeOfChildren() == 0) {
                return;
            }
            LayoutPreferences options = LayoutPreferences.get();
            this.whichLayout = options.getWhichLayout();
            this.whichActivityDiagramLayout = options.getWhichActivityDiagramLayout();
            LogicUnparseInterface lui = currentCanvas.getFSAInterface().getLogic();
            if (lui instanceof UMLActivityDiagram) {
                switch (this.whichActivityDiagramLayout) {
                    case 0: {
                        this.myLayouter = TreeLayout.get();
                        break;
                    }
                    case 1: {
                        this.myLayouter = SpringEmbedderLayout.get();
                        break;
                    }
                    case 2: {
                        this.myLayouter = ControlFlowLayout.get();
                        break;
                    }
                }
            } else if (lui instanceof UMLClassDiagram) {
                switch (this.whichLayout) {
                    case 0: {
                        this.myLayouter = TreeLayout.get();
                        break;
                    }
                    case 1: {
                        this.myLayouter = SpringEmbedderLayout.get();
                        break;
                    }
                    case 3: {
                        this.myLayouter = ClassdiagramLayouter.get();
                        break;
                    }
                }
            } else {
                switch (this.whichLayout) {
                    case 0: {
                        this.myLayouter = TreeLayout.get();
                        break;
                    }
                    case 1: {
                        this.myLayouter = SpringEmbedderLayout.get();
                        break;
                    }
                }
            }
            if (this.myLayouter != null) {
                if (this.myLayouter instanceof ControlFlowLayout) {
                    try {
                        this.myLayouter.reLayout(currentCanvas);
                        Iterator childrenIterator = currentCanvas.iteratorOfChildren();
                        while (childrenIterator.hasNext()) {
                            FSAObject fsaObject = (FSAObject)childrenIterator.next();
                            if (!(fsaObject.getLogic() instanceof ASGElement)) continue;
                            ((ASGElement)fsaObject.getLogic()).saveFSAProperties();
                        }
                        break block25;
                    }
                    catch (InterruptedException exept) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Layouter: Error!!!");
                        }
                        break block25;
                    }
                }
                LayoutThread layoutThread = new LayoutThread(this.myLayouter, currentCanvas);
                layoutThread.start();
            }
        }
    }

    public int getWhichLayout() {
        return this.whichLayout;
    }

    public int setWhichLayout(int whichLayout) {
        if (whichLayout == 0 || whichLayout == 1) {
            this.whichLayout = whichLayout;
        }
        return this.whichLayout;
    }

    public int getWhichActivityDiagramLayout() {
        return this.whichActivityDiagramLayout;
    }

    public int setWhichActivityDiagramLayout(int whichActivityDiagramLayout) {
        if (whichActivityDiagramLayout == 0 || whichActivityDiagramLayout == 1 || whichActivityDiagramLayout == 2) {
            this.whichActivityDiagramLayout = whichActivityDiagramLayout;
        }
        return this.whichActivityDiagramLayout;
    }

    public AbstractLayouter getMyLayouter() {
        return this.myLayouter;
    }

    public void setMyLayouter(AbstractLayouter myLayouter) {
        if (this.myLayouter != myLayouter) {
            if (this.myLayouter != null) {
                AbstractLayouter oldMyLayouter = this.myLayouter;
                this.myLayouter = null;
                oldMyLayouter.setRevMyLayouter(null);
            }
            this.myLayouter = myLayouter;
            if (myLayouter != null) {
                myLayouter.setRevMyLayouter(this);
            }
        }
    }

    public void removeYou() {
        this.setMyLayouter(null);
    }

    private class LayoutThread
    extends SwingWorker {
        AbstractLayouter myLayout;
        FSAContainer currentCanvas;

        public LayoutThread(AbstractLayouter myLayout, FSAContainer currentCanvas) {
            this.myLayout = myLayout;
            this.currentCanvas = currentCanvas;
        }

        public Object construct() {
            block3: {
                try {
                    Thread.sleep(100L);
                    this.myLayout.reLayout(this.currentCanvas);
                    Iterator childrenIterator = this.currentCanvas.iteratorOfChildren();
                    while (childrenIterator.hasNext()) {
                        FSAObject fsaObject = (FSAObject)childrenIterator.next();
                        if (!(fsaObject.getLogic() instanceof ASGElement)) continue;
                        ((ASGElement)fsaObject.getLogic()).saveFSAProperties();
                    }
                }
                catch (Exception except) {
                    except.printStackTrace();
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Layout: Error!!!");
                }
            }
            return "";
        }

        public void finished() {
            UMLProject.get().refreshDisplay();
        }
    }
}

