/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.layout;

import de.uni_paderborn.fujaba.fsa.FSAContainer;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.FSAPanel;
import de.uni_paderborn.fujaba.layout.AbstractLayouter;
import de.uni_paderborn.fujaba.layout.TreeLayout;
import de.uni_paderborn.fujaba.layout.options.LayoutPreferences;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.sequencer.Flow;
import de.uni_paderborn.fujaba.sequencer.FlowActivity;
import de.uni_paderborn.fujaba.sequencer.Rep;
import de.uni_paderborn.fujaba.sequencer.Sel;
import de.uni_paderborn.fujaba.sequencer.Seq;
import de.uni_paderborn.fujaba.sequencer.Sequencer;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLStoryActivity;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;
import de.upb.tools.fca.FLinkedList;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Iterator;

public class ControlFlowLayout
extends AbstractLayouter {
    private static ControlFlowLayout myLayouter = null;

    private ControlFlowLayout() {
    }

    private Point layoutCFG(Flow flow, Point nw) {
        Point se = new Point(nw);
        if (flow instanceof Seq) {
            FLinkedList items = ((Seq)flow).getItems();
            Point xy = new Point();
            Point newNW = new Point(nw);
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                Flow currentFlow = (Flow)iter.next();
                xy = this.layoutCFG(currentFlow, newNW);
                newNW.y = xy.y;
                se.y = xy.y;
                int n = se.x = xy.x > se.x ? xy.x : se.x;
            }
        } else if (flow instanceof Sel) {
            se = this.layoutCFG(((Sel)flow).getFlowActivity(), nw);
            Point newNW = new Point(nw.x, se.y);
            se = this.layoutCFG(((Sel)flow).getThenSeq(), newNW);
            Point xy = new Point(se.x, newNW.y);
            xy = this.layoutCFG(((Sel)flow).getElseSeq(), xy);
            se.x = xy.x;
            se.y = se.y > xy.y ? se.y : xy.y;
        } else if (flow instanceof Rep) {
            se = this.layoutCFG(((Rep)flow).getBodySeq(), nw);
        } else if (flow instanceof FlowActivity) {
            FSAObject curDisFrame = this.getConcerningDisFrame((FlowActivity)flow);
            curDisFrame.setLocation(nw);
            Dimension curDimension = curDisFrame.getPreferredSize();
            se.x = nw.x + curDimension.width + this.getHorizDist();
            se.y = nw.y + curDimension.height + this.getVertDist();
            if (((FlowActivity)flow).isForEach()) {
                Point xy = new Point(se.x, nw.y);
                xy = this.layoutCFG(((FlowActivity)flow).getForEachSeq(), xy);
                se.x = xy.x;
                se.y = se.y > xy.y ? se.y : xy.y;
            }
        }
        return se;
    }

    private FSAObject getConcerningDisFrame(FlowActivity curFlowActivity) {
        FSAObject curDisObject = curFlowActivity.getUMLActivity().getFSAInterface().getFirstFromFsaObjects();
        return curDisObject;
    }

    public static ControlFlowLayout get() {
        if (myLayouter == null) {
            myLayouter = new ControlFlowLayout();
        }
        return myLayouter;
    }

    public void reLayoutNoThrow(FSAContainer currentCanvas) {
        try {
            this.reLayout(currentCanvas);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reLayout(FSAContainer currentCanvas) throws InterruptedException {
        LayoutPreferences options = LayoutPreferences.get();
        this.setHorizDist(options.getHorizDist());
        this.setVertDist(options.getVertDist());
        UMLActivityDiagram curActivityDiagram = null;
        Point nw = new Point(this.getHorizDist(), this.getVertDist());
        if (!(currentCanvas.getFSAInterface().getLogic() instanceof UMLActivityDiagram)) return;
        try {
            try {
                curActivityDiagram = (UMLActivityDiagram)currentCanvas.getFSAInterface().getLogic();
                Sequencer sequencer = Sequencer.get();
                curActivityDiagram.createFlowAssociations();
                Iterator itemIter = curActivityDiagram.iteratorOfElements();
                FElement item = null;
                while (itemIter.hasNext()) {
                    item = (FElement)itemIter.next();
                    if (!(item instanceof UMLStoryActivity)) continue;
                    UMLStoryPattern pattern = ((UMLStoryActivity)item).getStoryPattern();
                    Iterator iter2 = pattern.getFSAInterface().iteratorOfFsaObjects();
                    while (iter2.hasNext()) {
                        FSAObject ob = (FSAObject)iter2.next();
                        if (!(ob instanceof FSAPanel)) continue;
                        FSAPanel dr = (FSAPanel)ob;
                        TreeLayout.get().reLayout(dr);
                    }
                }
                FlowActivity startActivity = curActivityDiagram.getStartActivity().getFlowActivity();
                Seq seq = sequencer.exploreCFG(startActivity);
                this.layoutCFG(seq, nw);
            }
            catch (RuntimeException runtimeException) {}
            Object var12_15 = null;
            if (curActivityDiagram == null) return;
            curActivityDiagram.removeFlowAssociations();
            return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (curActivityDiagram != null) {
                curActivityDiagram.removeFlowAssociations();
            }
            currentCanvas = null;
            throw throwable;
        }
    }
}

