/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gxl;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.basic.SchemaFilter;
import de.uni_paderborn.fujaba.fsa.unparse.UnparseManager;
import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.gxl.FXMLTree;
import de.uni_paderborn.fujaba.gxl.FileSaver;
import de.uni_paderborn.fujaba.gxl.GXLFilterMap;
import de.uni_paderborn.fujaba.gxl.GXLImport;
import de.uni_paderborn.fujaba.gxl.GXLMergerMap;
import de.uni_paderborn.fujaba.gxl.UMLActivityDiagramFilter;
import de.uni_paderborn.fujaba.gxl.UMLActivityDiagramMerger;
import de.uni_paderborn.fujaba.gxl.UMLClassDiagramFilter;
import de.uni_paderborn.fujaba.gxl.UMLClassDiagramMerger;
import de.uni_paderborn.fujaba.gxl.Validator;
import de.uni_paderborn.fujaba.uml.UMLProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSLTransformerDialog
extends FujabaDialog {
    private static final transient Logger log;
    private static final int EXPORT = 1;
    private static final int IMPORT = 2;
    private int status = 0;
    private Hashtable stylesheets;
    private File stylesheetDir;
    private File stylesheetList;
    private Iterator iter;
    private String text;
    private JFileChooser fileChooser;
    private JTextField file;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    JList availableSheetList;
    JList appliedSheetList;
    private DefaultListModel importModel;
    private DefaultListModel exportModel;
    private JCheckBox addExport;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.gxl.XSLTransformerDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public XSLTransformerDialog(JFrame parent, Iterator iter) {
        super(parent);
        this.iter = iter;
        this.stylesheetDir = new File(String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "stylesheets");
        this.stylesheetList = new File(String.valueOf(this.stylesheetDir.getAbsolutePath()) + File.separatorChar + "stylesheet.xml");
        this.fileChooser = new JFileChooser();
        this.readStylesheets();
        this.appliedSheetList = new JList(new Vector());
        this.availableSheetList = new JList(this.getStylesheets());
        GXLFilterMap gXLFilterMap = GXLFilterMap.get();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("de.uni_paderborn.fujaba.uml.UMLClassDiagram");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        gXLFilterMap.addToFilter(clazz, new UMLClassDiagramFilter());
        GXLFilterMap gXLFilterMap2 = GXLFilterMap.get();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("de.uni_paderborn.fujaba.uml.UMLActivityDiagram");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        gXLFilterMap2.addToFilter(clazz2, new UMLActivityDiagramFilter());
        GXLMergerMap gXLMergerMap = GXLMergerMap.get();
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("de.uni_paderborn.fujaba.uml.UMLClassDiagram");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        gXLMergerMap.addToMerger(clazz3, new UMLClassDiagramMerger());
        GXLMergerMap gXLMergerMap2 = GXLMergerMap.get();
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("de.uni_paderborn.fujaba.uml.UMLActivityDiagram");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        gXLMergerMap2.addToMerger(clazz4, new UMLActivityDiagramMerger());
    }

    public void showImportDialog() {
        this.status = 2;
        this.setTitle("importing GXL");
        this.text = "read file";
        this.appliedSheetList.setModel(this.importModel);
        this.initGUI("import");
        this.setSize(300, 600);
        super.showCentered();
    }

    public void showExportDialog() {
        this.status = 1;
        this.setTitle("exporting GXL");
        this.text = "write file";
        this.appliedSheetList.setModel(this.exportModel);
        this.initGUI("export");
        this.setSize(300, 600);
        super.showCentered();
    }

    private void initGUI(String text) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.guiSingleFilePanel(), "North");
        panel.add((Component)this.guiWorkPanel(), "Center");
        panel.add((Component)this.guiButtonPanel(text), "South");
        this.getContentPane().add(panel);
    }

    private JPanel guiSingleFilePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(new EtchedBorder(), this.text));
        this.file = new JTextField(30);
        panel.add(this.file);
        JButton browseButton = new JButton("Browse...");
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XSLTransformerDialog.this.fileSelection();
            }
        });
        panel.add(browseButton);
        return panel;
    }

    private JPanel guiWorkPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(gridbag);
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.fill = 1;
        constraints.ipadx = 5;
        constraints.ipady = 5;
        constraints.insets = new Insets(5, 0, 5, 5);
        constraints.anchor = 18;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)this.guiLeftSide(), constraints);
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        JPanel tmpPanel = this.guiMiddle();
        gridbag.setConstraints(tmpPanel, constraints);
        panel.add(tmpPanel);
        constraints.anchor = 18;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.insets = new Insets(5, 5, 5, 0);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)this.guiRightSide(), constraints);
        return panel;
    }

    private JPanel guiLeftSide() {
        JPanel leftPanel = new JPanel(new BorderLayout());
        JScrollPane sPane = new JScrollPane(this.appliedSheetList);
        leftPanel.setBorder(new TitledBorder(new EtchedBorder(), "applied stylesheets"));
        leftPanel.add((Component)sPane, "Center");
        leftPanel.setPreferredSize(new Dimension(150, 200));
        return leftPanel;
    }

    private JPanel guiRightSide() {
        JPanel rightPanel = new JPanel(new BorderLayout());
        JScrollPane sPane = new JScrollPane(this.availableSheetList);
        rightPanel.setBorder(new TitledBorder(new EtchedBorder(), "available stylesheets"));
        rightPanel.add((Component)sPane, "Center");
        rightPanel.setPreferredSize(new Dimension(150, 200));
        return rightPanel;
    }

    private JPanel guiMiddle() {
        JLabel infoLabel;
        String info;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.gridheight = 1;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 5, 0, 5);
        JPanel panel = new JPanel();
        panel.setLayout(gridbag);
        JButton addButton = new JButton("<< add");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (XSLTransformerDialog.this.availableSheetList.getSelectedIndex() > -1) {
                    ((DefaultListModel)XSLTransformerDialog.this.appliedSheetList.getModel()).addElement(XSLTransformerDialog.this.availableSheetList.getSelectedValue());
                }
            }
        });
        panel.add((Component)addButton, constraints);
        JButton removeButton = new JButton("remove >>");
        removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (XSLTransformerDialog.this.appliedSheetList.getSelectedIndex() > -1) {
                    ((DefaultListModel)XSLTransformerDialog.this.appliedSheetList.getModel()).removeElement(XSLTransformerDialog.this.appliedSheetList.getSelectedValue());
                }
            }
        });
        panel.add((Component)removeButton, constraints);
        if (this.status == 1) {
            info = "If no stylesheet is selected, the xml-stylesheet will be taken automatically!";
            infoLabel = new JLabel(info);
            panel.add((Component)infoLabel, constraints);
        }
        if (this.status == 2) {
            info = "It is not necessary to specify a stylesheet for the import of RTSCs!";
            infoLabel = new JLabel(info);
            panel.add((Component)infoLabel, constraints);
        }
        constraints.insets = new Insets(10, 0, 0, 0);
        return panel;
    }

    private Vector getStylesheets() {
        Vector sheets = new Vector(0);
        Enumeration enumeration = this.stylesheets.keys();
        while (enumeration.hasMoreElements()) {
            sheets.add(enumeration.nextElement());
        }
        Collections.sort(sheets);
        return sheets;
    }

    private JPanel guiButtonPanel(String text) {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BorderLayout());
        if (text.equals("export")) {
            this.addExport = new JCheckBox("include additional diagrams");
            this.buttonPanel.add((Component)this.addExport, "North");
        }
        JPanel tmpPanel = new JPanel();
        this.okButton = new JButton();
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XSLTransformerDialog.this.okButtonActionPerformed(e);
            }
        });
        this.okButton.setBounds(600, 15, 90, 25);
        tmpPanel.add(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XSLTransformerDialog.this.setVisible(false);
            }
        });
        this.cancelButton.setBounds(600, 15, 90, 25);
        tmpPanel.add(this.cancelButton);
        this.buttonPanel.setBounds(5, 260, 600, 50);
        this.buttonPanel.add((Component)tmpPanel, "Center");
        return this.buttonPanel;
    }

    void fileSelection() {
        SchemaFilter filter;
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        if (log.isInfoEnabled()) {
            log.info((Object)String.valueOf(this.getAppliedStylesheets().length));
        }
        String target = "";
        if (this.getAppliedStylesheets().length > 0) {
            if (this.status == 1) {
                int length = this.getAppliedStylesheets().length;
                String stylesheet = this.getAppliedStylesheets()[length - 1].getName();
                target = stylesheet.split("2")[1];
                target = target.split(".xsl")[0];
            } else {
                String stylesheet = this.getAppliedStylesheets()[0].getName();
                target = stylesheet.split("2")[1];
                target = stylesheet.split("2")[0];
            }
            if (target.equals("fujaba")) {
                target = "fpr";
            }
            filter = new SchemaFilter("." + target, String.valueOf(target.toUpperCase()) + " Files (*." + target + ", *." + target + ".gz)");
            filter.addExtension(String.valueOf(target) + ".gz");
        } else {
            target = "xml";
            filter = new SchemaFilter(".xml", "XML Files (*.xml, *.xml.gz)");
            filter.addExtension("xml.gz");
        }
        this.fileChooser.setFileFilter(filter);
        if (this.status == 1) {
            if (this.fileChooser.showSaveDialog(this) == 0) {
                String tmpFile = this.fileChooser.getSelectedFile().getPath();
                if (!tmpFile.endsWith("." + target + ".gz")) {
                    if (!tmpFile.endsWith("." + target)) {
                        tmpFile = String.valueOf(tmpFile) + "." + target;
                    }
                    if (!tmpFile.endsWith(".gz")) {
                        tmpFile = String.valueOf(tmpFile) + ".gz";
                    }
                }
                this.file.setText(tmpFile);
            }
        } else if (this.status == 2 && this.fileChooser.showOpenDialog(this) == 0) {
            String tmpFile = this.fileChooser.getSelectedFile().getPath();
            this.file.setText(tmpFile);
        }
    }

    private Element readXMLFile(File xmlFile) {
        if (xmlFile.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                Document doc = parser.parse(xmlFile);
                Element root = doc.getDocumentElement();
                return root;
            }
            catch (Exception e) {
                log.error((Object)("file \"" + xmlFile.getName() + "\" seems to be corrupted.\n" + e));
                return null;
            }
        }
        log.error((Object)("file \"" + xmlFile.getName() + "\" not found."));
        return null;
    }

    private File[] getAppliedStylesheets() {
        DefaultListModel model = (DefaultListModel)this.appliedSheetList.getModel();
        File[] files = new File[model.getSize()];
        int i = 0;
        Enumeration enumeration = model.elements();
        while (enumeration.hasMoreElements()) {
            String realFileName = (String)this.stylesheets.get(enumeration.nextElement());
            files[i] = new File(String.valueOf(this.stylesheetDir.getAbsolutePath()) + "/" + realFileName);
            ++i;
        }
        return files;
    }

    void okButtonActionPerformed(ActionEvent e) {
        FileSaver fileSaver;
        boolean exportFlag = false;
        boolean importFlag = false;
        if (this.file.getText().equals("")) {
            log.error((Object)"No file specified.");
            return;
        }
        if (this.getAppliedStylesheets().length == 0) {
            if (this.status == 1) {
                fileSaver = new FileSaver(this.iter, new File(this.file.getText()), this.addExport.isSelected());
                fileSaver.save();
                exportFlag = true;
            } else if (this.status == 2) {
                importFlag = true;
            }
        }
        if (this.status == 1 && !exportFlag) {
            fileSaver = new FileSaver(this.iter, new File(this.file.getText()), this.getAppliedStylesheets(), this.addExport.isSelected());
            fileSaver.save();
        } else if (this.status == 2) {
            Object tmpObject = null;
            if (this.iter.hasNext()) {
                tmpObject = this.iter.next();
            }
            if (tmpObject != null && tmpObject instanceof ASGDiagram) {
                ASGDiagram tmpIncr = tmpObject;
                Validator myValidator = null;
                myValidator = !importFlag ? new Validator(new File(this.file.getText()), this.getAppliedStylesheets()) : new Validator(new File(this.file.getText()));
                try {
                    FXMLTree tmpTree = myValidator.getDOMTree();
                    UnparseManager.get().pausePropertyProcessing();
                    new GXLImport(tmpTree, tmpIncr);
                    FrameMain.get().createNewTreeItems();
                    UnparseManager.get().resumePropertyProcessing();
                    UMLProject.get().refreshDisplay();
                }
                catch (Exception ex) {
                    log.error((Object)"file not valid");
                    ex.printStackTrace();
                }
            } else {
                log.error((Object)"Not a diagram");
            }
        }
        this.setVisible(false);
    }

    private void readStylesheets() {
        this.stylesheets = new Hashtable();
        Element root = this.readXMLFile(this.stylesheetList);
        NodeList nl = root.getElementsByTagName("stylesheet");
        this.importModel = new DefaultListModel();
        this.exportModel = new DefaultListModel();
        int i = 0;
        while (i < nl.getLength()) {
            String isImport;
            NamedNodeMap attrs = nl.item(i).getAttributes();
            String name = attrs.getNamedItem("name").getNodeValue();
            this.stylesheets.put(name, attrs.getNamedItem("file").getNodeValue());
            Node node = attrs.getNamedItem("export");
            String isExport = node == null ? "false" : node.getNodeValue();
            node = attrs.getNamedItem("import");
            String string = isImport = node == null ? "false" : node.getNodeValue();
            if ("true".equals(isExport)) {
                this.exportModel.addElement(name);
            }
            if ("true".equals(isImport)) {
                this.importModel.addElement(name);
            }
            ++i;
        }
    }
}

