/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gxl;

import de.uni_paderborn.fujaba.gxl.GXLHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class XSLTransformer {
    private static final transient Logger log;
    private static TransformerFactory tFactory;
    private static Transformer transformer;
    private static BufferedReader in;
    private static BufferedWriter out;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.gxl.XSLTransformer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        tFactory = TransformerFactory.newInstance();
    }

    public static Document transform(File from, File how) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        transformer = tFactory.newTransformer(new StreamSource(how));
        try {
            in = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(from))));
        }
        catch (IOException e) {
            in = new BufferedReader(new FileReader(from));
        }
        try {
            String out = "";
            while (in.ready()) {
                String s = in.readLine();
                if (s.startsWith("<XMI ")) {
                    s = "<XMI xmi.version = '1.1' xmlns:UML='http://www.omg.org/uml/1.3'>\n";
                }
                out = String.valueOf(out) + s + "\n";
            }
            InputSource src = new InputSource(new StringReader(out));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            GXLHandler handler = new GXLHandler();
            builder.setEntityResolver(handler);
            builder.setErrorHandler(handler);
            Document doc = builder.parse(src);
            DOMSource source = new DOMSource(doc);
            DOMResult result = new DOMResult();
            transformer.transform(source, result);
            Document resultDoc = (Document)result.getNode();
            XSLTransformer.checkDocType(resultDoc, transformer.getOutputProperty("doctype-public"), transformer.getOutputProperty("doctype-system"));
            return resultDoc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document transform(File from) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        transformer = tFactory.newTransformer();
        try {
            in = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(from))));
        }
        catch (IOException e) {
            in = new BufferedReader(new FileReader(from));
        }
        try {
            InputSource src = new InputSource(in);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            GXLHandler handler = new GXLHandler();
            builder.setEntityResolver(handler);
            builder.setErrorHandler(handler);
            Document doc = builder.parse(src);
            DOMSource source = new DOMSource(doc);
            DOMResult result = new DOMResult();
            transformer.transform(source, result);
            Document resultDoc = (Document)result.getNode();
            XSLTransformer.checkDocType(resultDoc, transformer.getOutputProperty("doctype-public"), transformer.getOutputProperty("doctype-system"));
            return resultDoc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void transform(File from, File to, File how) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        transformer = tFactory.newTransformer(new StreamSource(how));
        out = to.getName().endsWith(".gz") ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(to)))) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(to)));
        try {
            in = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(from))));
        }
        catch (IOException e) {
            in = new BufferedReader(new FileReader(from));
        }
        try {
            InputSource src = new InputSource(in);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            GXLHandler handler = new GXLHandler();
            builder.setEntityResolver(handler);
            builder.setErrorHandler(handler);
            Document doc = builder.parse(src);
            DOMSource source = new DOMSource(doc);
            DOMResult result = new DOMResult();
            transformer.transform(source, result);
            Document outDoc = (Document)result.getNode();
            XSLTransformer.checkDocType(outDoc, transformer.getOutputProperty("doctype-public"), transformer.getOutputProperty("doctype-system"));
            OutputFormat format = new OutputFormat(outDoc, null, true);
            XMLSerializer serializer = new XMLSerializer(out, format);
            serializer.serialize(outDoc);
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Document transform(Document from, File how) throws TransformerException, TransformerConfigurationException {
        transformer = tFactory.newTransformer(new StreamSource(how));
        Properties prop = transformer.getOutputProperties();
        Iterator<Map.Entry<Object, Object>> iter = prop.entrySet().iterator();
        if (!iter.hasNext() && log.isInfoEnabled()) {
            log.info((Object)"No properties!");
        }
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Property: '" + entry.getKey() + "'(" + entry.getKey().getClass().getName() + "):='" + entry.getValue() + "'(" + entry.getValue().getClass().getName() + ")"));
        }
        try {
            DOMSource source = new DOMSource(from);
            DOMResult result = new DOMResult();
            transformer.transform(source, result);
            Document resultDoc = (Document)result.getNode();
            XSLTransformer.checkDocType(resultDoc, transformer.getOutputProperty("doctype-public"), transformer.getOutputProperty("doctype-system"));
            return resultDoc;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void transform(Document from, File to, File how) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        transformer = tFactory.newTransformer(new StreamSource(how));
        out = to.getName().endsWith(".gz") ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(to)))) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(to)));
        try {
            DOMSource source = new DOMSource(from);
            DOMResult result = new DOMResult();
            transformer.transform(source, result);
            Document doc = (Document)result.getNode();
            XSLTransformer.checkDocType(doc, transformer.getOutputProperty("doctype-public"), transformer.getOutputProperty("doctype-system"));
            OutputFormat format = new OutputFormat(doc, null, true);
            XMLSerializer serializer = new XMLSerializer(out, format);
            serializer.serialize(doc);
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void transformWithoutStylesheet(Document from, File to) throws TransformerException, TransformerConfigurationException, FileNotFoundException, IOException {
        transformer = tFactory.newTransformer();
        out = to.getName().endsWith(".gz") ? new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(to)))) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(to)));
        try {
            DOMSource source = new DOMSource(from);
            DOMResult result = new DOMResult();
            transformer.transform(source, result);
            Document doc = (Document)result.getNode();
            XSLTransformer.checkDocType(doc, transformer.getOutputProperty("doctype-public"), transformer.getOutputProperty("doctype-system"));
            OutputFormat format = new OutputFormat(doc, null, true);
            XMLSerializer serializer = new XMLSerializer(out, format);
            serializer.serialize(doc);
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void checkDocType(Document doc, String publicId, String systemId) throws DOMException {
        if (doc.getDoctype() == null && (publicId != null || systemId != null)) {
            if (doc instanceof DocumentImpl) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Change Doc type to " + publicId + ":" + systemId));
                }
                DocumentImpl docImpl = (DocumentImpl)doc;
                Element root = docImpl.getDocumentElement();
                DocumentType docType = docImpl.createDocumentType(root.getTagName(), publicId, systemId);
                docImpl.appendChild(docType);
            } else {
                throw new DOMException(0, "Not an instance of DocumentImpl");
            }
        }
    }
}

