/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gxl;

import de.uni_paderborn.fujaba.app.FujabaApp;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.basic.BasicIncrement;
import de.uni_paderborn.fujaba.basic.FujabaComparator;
import de.uni_paderborn.fujaba.gxl.Filter;
import de.uni_paderborn.fujaba.gxl.GXLExcludedLoader;
import de.uni_paderborn.fujaba.gxl.GXLFilterMap;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.lib.plugins.PluginManager;
import de.upb.lib.plugins.PluginProperty;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.FTreeSet;
import java.io.BufferedReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class GXLFilter {
    private static final transient Logger log;
    private static FHashSet removed;
    private static FHashSet excluded;
    public static ASGDiagram root;
    public Filter actualFilter;
    private static FHashSet diagramItems;
    private static FHashSet addDiagrams;
    private static FHashSet savedDiagrams;
    private static boolean firstSelected;
    private FHashSet storedItems;
    private static boolean include;
    private StringBuffer outputData;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.gxl.GXLFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public GXLFilter(Iterator rootIter, boolean isInclude, StringBuffer outputData) throws Exception {
        excluded = new FHashSet();
        removed = new FHashSet();
        diagramItems = new FHashSet();
        this.storedItems = new FHashSet();
        include = isInclude;
        this.outputData = outputData;
        if (rootIter.hasNext()) {
            Object tmpObject = rootIter.next();
            if (tmpObject instanceof ASGDiagram) {
                root = (ASGDiagram)tmpObject;
                Iterator iter = root.iteratorOfElements();
                while (iter.hasNext()) {
                    diagramItems.add(iter.next());
                }
            } else {
                root = UMLProject.get().getCurrentDiagram();
                diagramItems.add(root);
                diagramItems.add(tmpObject);
                while (rootIter.hasNext()) {
                    diagramItems.add(rootIter.next());
                }
            }
            if (this.setActualFilter()) {
                this.loadExcluded();
            } else {
                throw new Exception();
            }
        }
        this.save();
    }

    protected boolean setActualFilter() {
        this.actualFilter = GXLFilterMap.get().getFromFilter(root.getClass());
        if (this.actualFilter != null) {
            return true;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Filter for " + root.getClass() + " could not be found"));
        }
        return false;
    }

    public static ASGDiagram getRoot() {
        return root;
    }

    public static boolean getInclude() {
        return include;
    }

    public static boolean getFirstSelected() {
        return firstSelected;
    }

    public static void addToAddDiagrams(ASGDiagram diag) {
        if (addDiagrams != null) {
            addDiagrams.add(diag);
        }
    }

    public static boolean hasInAddDiagrams(ASGDiagram diag) {
        return addDiagrams.contains(diag);
    }

    public static void addToSavedDiagrams(ASGDiagram diag) {
        if (savedDiagrams != null) {
            savedDiagrams.add(diag);
        }
    }

    public static boolean hasInSavedDiagrams(ASGDiagram diag) {
        return savedDiagrams.contains(diag);
    }

    public void loadExcluded() {
        GXLExcludedLoader loadClasses = new GXLExcludedLoader();
        if (loadClasses.isReady()) {
            excluded = loadClasses.getExcluded(root.getClass().getName());
        }
    }

    public void save() {
        ASGDiagram rootIncrement = UMLProject.get().getCurrentDiagram();
        FTreeSet savedIncrements = new FTreeSet(FujabaComparator.getLessBasicIncr());
        firstSelected = true;
        addDiagrams = new FHashSet();
        savedDiagrams = new FHashSet();
        try {
            PluginManager manager = FujabaApp.getPluginManager();
            PluginProperty plugin = null;
            Iterator pluginIter = manager.iteratorOfProperties();
            this.outputData.append("# used plug-ins\n");
            while (pluginIter.hasNext()) {
                plugin = (PluginProperty)pluginIter.next();
                this.outputData.append("$;" + plugin.getName() + ";" + plugin.getPluginID() + ";" + plugin.getMajor() + ";" + plugin.getMinor() + ";" + plugin.getBuildNumber() + "\n");
            }
            rootIncrement.writeClassToStringBuffer(this.outputData, savedIncrements, this);
        }
        catch (Exception e) {
            log.error((Object)"Es kann nur ein String als Key gespeichert werden --> ClassCastException");
            e.printStackTrace();
        }
        savedDiagrams.add(rootIncrement);
        Iterator iter = addDiagrams.iterator();
        while (iter.hasNext()) {
            if (firstSelected) {
                firstSelected = false;
            }
            this.outputData.append("@\n");
            FTreeSet savedIncr = new FTreeSet(FujabaComparator.getLessBasicIncr());
            ASGElement rootIncr = (ASGElement)iter.next();
            root = (ASGDiagram)rootIncr;
            log.error((Object)("Saving Diagram: " + rootIncr));
            this.setActualFilter();
            diagramItems = new FHashSet();
            Iterator iter2 = root.iteratorOfElementReferences();
            while (iter2.hasNext()) {
                Object tmpObj = iter2.next();
                diagramItems.add(tmpObj);
            }
            this.loadExcluded();
            try {
                rootIncr.writeClassToStringBuffer(this.outputData, savedIncr, this);
                savedDiagrams.add(rootIncr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean verifyObject(BasicIncrement obj) {
        boolean result = false;
        if (excluded.contains(obj.getClass().getName())) {
            if (!this.hasInStoredItems(obj.getID())) {
                removed.add(obj.getID());
            }
            return result;
        }
        result = this.actualFilter.verifyObject(obj);
        if (result) {
            if (GXLFilter.getInclude() & GXLFilter.hasInRemoved(obj.getID())) {
                GXLFilter.removeFromRemoved(obj.getID());
            }
            this.storedItems.add(obj.getID());
        } else if (!this.hasInStoredItems(obj.getID())) {
            removed.add(obj.getID());
        }
        return result;
    }

    public StringBuffer removeExcludedObjects(StringBuffer structure) {
        BufferedReader in = new BufferedReader(new StringReader(structure.toString()));
        StringWriter out = new StringWriter();
        StringWriter o = new StringWriter();
        try {
            while (in.ready()) {
                String line = in.readLine();
                o.write(line);
                o.flush();
                if (line != null) {
                    if (line.charAt(0) == '~') {
                        int idx = line.lastIndexOf(";id");
                        if (idx == -1) {
                            out.write(String.valueOf(line) + "\n");
                            continue;
                        }
                        String tmpString = line.substring(idx + 1);
                        if (tmpString.indexOf(".") == -1) {
                            if (removed.contains(tmpString)) continue;
                            out.write(String.valueOf(line) + "\n");
                            continue;
                        }
                        out.write(String.valueOf(line) + "\n");
                        continue;
                    }
                    out.write(String.valueOf(line) + "\n");
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to remove references \n" + e + o.toString()));
            e.printStackTrace();
        }
        return new StringBuffer(out.toString());
    }

    public static boolean hasInItems(ASGElement element) {
        return diagramItems == null ? false : diagramItems.contains(element);
    }

    public static boolean hasInRemoved(String element) {
        return removed == null ? false : removed.contains(element);
    }

    private boolean hasInStoredItems(String element) {
        return this.storedItems == null ? false : this.storedItems.contains(element);
    }

    public static void removeFromRemoved(String element) {
        if (removed != null) {
            removed.remove(element);
        }
    }
}

