/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui.mdi;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class FramePositioning {
    public static final int MAX_FRAMES = 20;
    public static final int X_OFFSET = 30;
    public static final int Y_OFFSET = 30;
    public static final int MINIMUM_BUTTON_WIDTH = 30;
    public static final int MAXIMUM_BUTTON_WIDTH = 80;
    public static final Color CONTENTS_CHANGED_COLOR = Color.red;
    private JDesktopPane desktop;

    public FramePositioning(JDesktopPane desktop) {
        this.desktop = desktop;
    }

    public void cascadeInternalFrames() {
        JInternalFrame[] frames = this.desktop.getAllFrames();
        int frameCounter = 0;
        int i = frames.length - 1;
        while (i >= 0) {
            JInternalFrame f = frames[i];
            if (!f.isIcon()) {
                try {
                    f.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                f.setLocation(this.cascadeInternalFrame(f, frameCounter++));
                f.setSize(new Dimension((int)Math.min((double)f.getWidth(), this.desktop.getVisibleRect().getWidth() - (double)f.getX()), (int)Math.min((double)f.getHeight(), this.desktop.getVisibleRect().getHeight() - (double)f.getY())));
            }
            --i;
        }
    }

    public Point cascadeInternalFrame(JInternalFrame f) {
        return this.cascadeInternalFrame(f, this.desktop.getComponentCount());
    }

    private Point cascadeInternalFrame(JInternalFrame f, int count) {
        int numFramesHigh;
        int windowWidth = f.getWidth();
        int windowHeight = f.getHeight();
        Rectangle viewP = this.desktop.getVisibleRect();
        int numFramesWide = (viewP.width - windowWidth) / 30;
        if (numFramesWide < 1) {
            numFramesWide = 1;
        }
        if ((numFramesHigh = (viewP.height - windowHeight) / 30) < 1) {
            numFramesHigh = 1;
        }
        int xLoc = viewP.x + 30 * (count - (numFramesWide - 1) * (count / numFramesWide));
        int yLoc = viewP.y + 30 * (count - numFramesHigh * (count / numFramesHigh));
        return new Point(xLoc, yLoc);
    }

    /*
     * Unable to fully structure code
     */
    public void tileInternalFrames() {
        block8: {
            viewP = this.desktop.getVisibleRect();
            totalNonIconFrames = 0;
            frames = this.desktop.getAllFrames();
            i = 0;
            while (i < frames.length) {
                if (!frames[i].isIcon()) {
                    try {
                        frames[i].setMaximum(false);
                    }
                    catch (PropertyVetoException var5_5) {
                        // empty catch block
                    }
                    ++totalNonIconFrames;
                }
                ++i;
            }
            i = 0;
            if (totalNonIconFrames <= 0) break block8;
            numCols = (int)Math.sqrt(totalNonIconFrames);
            frameWidth = viewP.width / numCols;
            curCol = 0;
            while (curCol < numCols) {
                numRows = totalNonIconFrames / numCols;
                remainder = totalNonIconFrames % numCols;
                if (numCols - curCol <= remainder) {
                    ++numRows;
                }
                frameHeight = viewP.height / numRows;
                curRow = 0;
                ** GOTO lbl34
                {
                    ++i;
                    do {
                        if (frames[i].isIcon()) continue block4;
                        frames[i].setBounds(curCol * frameWidth, curRow * frameHeight, frameWidth, frameHeight);
                        ++i;
                        ++curRow;
lbl34:
                        // 2 sources

                    } while (curRow < numRows);
                }
                ++curCol;
            }
        }
    }
}

