/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui.mdi;

import de.upb.tools.fca.FLinkedList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.log4j.Logger;

public class DesktopTaskBar
extends JPanel
implements ActionListener {
    private static final transient Logger log;
    JDesktopPane desktop;
    public static final int PREFERRED_BUTTON_HEIGHT = 25;
    private static final int MAX_TITLE_LENGTH = 15;
    ButttonPanel taskButtonPanel;
    FLinkedList backList;
    FLinkedList forthList;
    public static final String BACK_ICON_NAME = "images/back.png";
    public static final String FORTH_ICON_NAME = "images/forth.png";
    private JButton backButton;
    private JButton forthButton;
    boolean inBackForth;
    long lastEventTime;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.gui.mdi.DesktopTaskBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public DesktopTaskBar(JDesktopPane desktop, boolean backForthButtons) {
        super(new BorderLayout());
        this.desktop = desktop;
        desktop.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof JInternalFrame) {
                    DesktopTaskBar.this.addFrame((JInternalFrame)e.getChild());
                }
            }

            public void componentRemoved(ContainerEvent e) {
            }
        });
        if (backForthButtons) {
            this.setupBackForth();
        }
        this.taskButtonPanel = new ButttonPanel();
        JScrollPane scrollPane = new JScrollPane(this.taskButtonPanel, 20, 31){

            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                this.getVerticalScrollBar().setUnitIncrement(DesktopTaskBar.this.taskButtonPanel.getSingleHeight());
                return new Dimension((int)preferredSize.getWidth(), DesktopTaskBar.this.taskButtonPanel.getSingleHeight());
            }
        };
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
    }

    void addFrame(final JInternalFrame associatedFrame) {
        Component[] menuComponents = this.taskButtonPanel.getComponents();
        int i = 0;
        while (i < menuComponents.length) {
            Component menuComponent = menuComponents[i];
            if (menuComponent instanceof JComponent && ((JComponent)menuComponent).getClientProperty("associatedFrame") == associatedFrame) {
                return;
            }
            ++i;
        }
        final JToggleButton button = new JToggleButton(this.getFrameShortTitle(associatedFrame), associatedFrame.getFrameIcon(), true){

            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                if (preferredSize != null) {
                    preferredSize.setSize(preferredSize.getWidth(), 25.0);
                }
                return preferredSize;
            }
        };
        button.setHorizontalAlignment(2);
        button.addActionListener(this);
        button.putClientProperty("associatedFrame", associatedFrame);
        this.taskButtonPanel.add(button);
        associatedFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent e) {
                button.removeActionListener(DesktopTaskBar.this);
                button.setSelected(true);
                if (!DesktopTaskBar.this.inBackForth && DesktopTaskBar.this.forthList != null) {
                    DesktopTaskBar.this.forthList.clear();
                    DesktopTaskBar.this.updateBackAndForth();
                }
                button.addActionListener(DesktopTaskBar.this);
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
                if (!DesktopTaskBar.this.inBackForth && DesktopTaskBar.this.backList != null && DesktopTaskBar.this.lastEventTime + 50L < System.currentTimeMillis()) {
                    if (DesktopTaskBar.this.backList.isEmpty() || DesktopTaskBar.this.backList.getLast() != e.getInternalFrame()) {
                        DesktopTaskBar.this.backList.add(e.getInternalFrame());
                        DesktopTaskBar.this.updateBackAndForth();
                    }
                    DesktopTaskBar.this.lastEventTime = System.currentTimeMillis();
                }
                button.setSelected(false);
            }

            public void internalFrameClosed(InternalFrameEvent e) {
                DesktopTaskBar.this.taskButtonPanel.remove(button);
                DesktopTaskBar.this.updateBackAndForth();
                DesktopTaskBar.this.revalidate();
                DesktopTaskBar.this.repaint();
            }

            public void internalFrameOpened(InternalFrameEvent e) {
                DesktopTaskBar.this.taskButtonPanel.add(button);
                DesktopTaskBar.this.revalidate();
                DesktopTaskBar.this.repaint();
            }

            public void internalFrameIconified(InternalFrameEvent e) {
                e.getInternalFrame().setVisible(false);
            }
        });
        associatedFrame.addPropertyChangeListener("title", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                button.setText(DesktopTaskBar.this.getFrameShortTitle(associatedFrame));
            }
        });
        this.revalidate();
        this.repaint();
    }

    String getFrameShortTitle(JInternalFrame associatedFrame) {
        String title = associatedFrame.getTitle();
        if (title != null && title.length() > 15) {
            title = String.valueOf(title.substring(0, 12)) + "...";
        }
        return title;
    }

    public void actionPerformed(ActionEvent e) {
        JInternalFrame associatedFrame;
        JToggleButton button;
        if (e.getSource() instanceof JToggleButton && (button = (JToggleButton)e.getSource()).isSelected() && (associatedFrame = (JInternalFrame)((JComponent)e.getSource()).getClientProperty("associatedFrame")) != null) {
            this.activate(associatedFrame);
        }
    }

    void updateBackAndForth() {
        JInternalFrame frame;
        Iterator iterator = this.backList.iterator();
        while (iterator.hasNext()) {
            frame = (JInternalFrame)iterator.next();
            if (frame.isVisible()) continue;
            this.backList.remove(frame);
        }
        iterator = this.forthList.iterator();
        while (iterator.hasNext()) {
            frame = (JInternalFrame)iterator.next();
            if (frame.isVisible()) continue;
            this.forthList.remove(frame);
        }
        this.forthButton.setEnabled(!this.forthList.isEmpty());
        this.backButton.setEnabled(!this.backList.isEmpty());
    }

    private void setupBackForth() {
        JPanel backForthPanel = new JPanel(new FlowLayout(3));
        this.add((Component)backForthPanel, "Before");
        this.backList = new FLinkedList();
        this.forthList = new FLinkedList();
        this.backButton = new JButton();
        this.forthButton = new JButton();
        this.backButton.setEnabled(false);
        this.forthButton.setEnabled(false);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("de.uni_paderborn.fujaba.app.FujabaApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        URL backIconURL = clazz.getResource(BACK_ICON_NAME);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("de.uni_paderborn.fujaba.app.FujabaApp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        URL forthIconURL = clazz2.getResource(FORTH_ICON_NAME);
        if (backIconURL != null) {
            this.backButton.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(backIconURL)));
        } else {
            log.error((Object)"Icon images/back.png not found!");
            this.backButton.setText("back");
        }
        if (forthIconURL != null) {
            this.forthButton.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(forthIconURL)));
        } else {
            log.error((Object)"Icon images/back.png not found!");
            this.forthButton.setText("forth");
        }
        this.backButton.setToolTipText("Go back to last viewed window");
        this.backButton.setMnemonic(37);
        this.forthButton.setToolTipText("Go forward to next viewed window");
        this.forthButton.setMnemonic(39);
        this.backButton.setPreferredSize(new Dimension(Math.max((int)this.backButton.getMinimumSize().getWidth(), 25), Math.max((int)this.backButton.getMinimumSize().getHeight(), 25)));
        this.forthButton.setPreferredSize(new Dimension(Math.max((int)this.forthButton.getMinimumSize().getWidth(), 25), Math.max((int)this.forthButton.getMinimumSize().getHeight(), 25)));
        backForthPanel.add(this.backButton);
        backForthPanel.add(this.forthButton);
        this.backButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent e) {
                if (DesktopTaskBar.this.backList.isEmpty()) return;
                JInternalFrame frame = (JInternalFrame)DesktopTaskBar.this.backList.removeLast();
                JInternalFrame selectedFrame = DesktopTaskBar.this.desktop.getSelectedFrame();
                if (selectedFrame != null) {
                    DesktopTaskBar.this.forthList.addFirst(selectedFrame);
                }
                DesktopTaskBar.this.updateBackAndForth();
                if (frame.getParent() != DesktopTaskBar.this.desktop) return;
                DesktopTaskBar.this.inBackForth = true;
                try {
                    DesktopTaskBar.this.activate(frame);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    DesktopTaskBar.this.inBackForth = false;
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    DesktopTaskBar.this.inBackForth = false;
                    return;
                }
            }
        });
        this.forthButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent e) {
                if (DesktopTaskBar.this.forthList.isEmpty()) return;
                JInternalFrame frame = (JInternalFrame)DesktopTaskBar.this.forthList.removeFirst();
                JInternalFrame selectedFrame = DesktopTaskBar.this.desktop.getSelectedFrame();
                if (selectedFrame != null) {
                    DesktopTaskBar.this.backList.addLast(selectedFrame);
                }
                DesktopTaskBar.this.updateBackAndForth();
                if (frame.getParent() != DesktopTaskBar.this.desktop) return;
                DesktopTaskBar.this.inBackForth = true;
                try {
                    DesktopTaskBar.this.activate(frame);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    DesktopTaskBar.this.inBackForth = false;
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    DesktopTaskBar.this.inBackForth = false;
                    return;
                }
            }
        });
    }

    void activate(JInternalFrame frame) {
        try {
            frame.setSelected(true);
            frame.setVisible(true);
            frame.setIcon(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private class ButttonPanel
    extends JPanel {
        public ButttonPanel() {
            super(new FlowLayout(0));
        }

        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            int newWidth = (int)preferredSize.getWidth();
            int newHeight = (int)preferredSize.getHeight();
            int width = this.getWidth();
            int vgap = ((FlowLayout)this.getLayout()).getVgap();
            while (newWidth > width && width > 0) {
                newHeight = (int)((double)newHeight + (preferredSize.getHeight() - (double)vgap));
                newWidth -= width;
            }
            return new Dimension(newWidth, newHeight);
        }

        public int getSingleHeight() {
            return (int)super.getPreferredSize().getHeight() - ((FlowLayout)this.getLayout()).getVgap();
        }
    }
}

