/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui.mdi;

import de.uni_paderborn.fujaba.gui.mdi.FramePositioning;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class DesktopMenu
extends JMenu
implements ActionListener {
    final JDesktopPane desktop;
    private final FramePositioning positioning;
    private int baseItemsEndIndex;
    ButtonGroup frameRadioButtonMenuItemGroup;
    JMenuItem closeMenuItem;
    JMenuItem closeAllMenuItem;

    public DesktopMenu(JDesktopPane desktop) {
        this(desktop, false);
    }

    public DesktopMenu(JDesktopPane desktop, boolean tileMode) {
        super("Window");
        this.setMnemonic(87);
        this.desktop = desktop;
        this.positioning = new FramePositioning(desktop);
        this.frameRadioButtonMenuItemGroup = new ButtonGroup();
        this.constructMenuItems(this);
        this.baseItemsEndIndex = this.getItemCount();
        desktop.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                if (e.getChild() instanceof JInternalFrame) {
                    DesktopMenu.this.addFrame((JInternalFrame)e.getChild());
                }
            }

            public void componentRemoved(ContainerEvent e) {
            }
        });
    }

    public JMenuItem initMenuItem(JMenuItem item, int mnemonic, int shortcut) {
        item.setMnemonic(mnemonic);
        if (shortcut != -1) {
            item.setAccelerator(KeyStroke.getKeyStroke(shortcut, 2));
        }
        item.addActionListener(this);
        return item;
    }

    private void constructMenuItems(JMenu sourceMenu) {
        sourceMenu.add(this.initMenuItem(new JMenuItem("Tile"), 84, -1));
        sourceMenu.add(this.initMenuItem(new JMenuItem("Cascade"), 67, -1));
        sourceMenu.addSeparator();
        this.closeMenuItem = this.initMenuItem(new JMenuItem("Close"), 83, 115);
        sourceMenu.add(this.closeMenuItem);
        this.closeMenuItem.setEnabled(false);
        this.closeAllMenuItem = this.initMenuItem(new JMenuItem("Close All"), 65, -1);
        sourceMenu.add(this.closeAllMenuItem);
        this.closeMenuItem.setEnabled(this.desktop.getComponentCount() > 0);
        sourceMenu.addSeparator();
    }

    void addFrame(JInternalFrame associatedFrame) {
        Component[] menuComponents = this.getMenuComponents();
        int i = 0;
        while (i < menuComponents.length) {
            Component menuComponent = menuComponents[i];
            if (menuComponent instanceof JComponent && ((JComponent)menuComponent).getClientProperty("associatedFrame") == associatedFrame) {
                return;
            }
            ++i;
        }
        int displayedCount = this.getItemCount() - this.baseItemsEndIndex + 1;
        int currentMenuCount = displayedCount;
        if (currentMenuCount > 9) {
            currentMenuCount /= 10;
        }
        final JMenuItem menuButton = this.initMenuItem(new JRadioButtonMenuItem(String.valueOf(displayedCount) + " " + associatedFrame.getTitle(), true), 48 + currentMenuCount, -1);
        menuButton.putClientProperty("associatedFrame", associatedFrame);
        associatedFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent e) {
                DesktopMenu.this.closeMenuItem.setEnabled(true);
                menuButton.removeActionListener(DesktopMenu.this);
                menuButton.setSelected(true);
                menuButton.addActionListener(DesktopMenu.this);
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
                DesktopMenu.this.closeMenuItem.setEnabled(false);
                menuButton.setSelected(false);
            }

            public void internalFrameClosed(InternalFrameEvent e) {
                DesktopMenu.this.remove(menuButton);
                DesktopMenu.this.frameRadioButtonMenuItemGroup.remove(menuButton);
                DesktopMenu.this.closeAllMenuItem.setEnabled(DesktopMenu.this.desktop.getComponentCount() > 0);
            }

            public void internalFrameOpened(InternalFrameEvent e) {
                DesktopMenu.this.add(menuButton);
                DesktopMenu.this.frameRadioButtonMenuItemGroup.add(menuButton);
            }
        });
        this.add(menuButton);
        this.frameRadioButtonMenuItemGroup.add(menuButton);
        menuButton.setSelected(true);
        this.closeAllMenuItem.setEnabled(true);
    }

    public void remove(JRadioButtonMenuItem menuButton) {
        this.frameRadioButtonMenuItemGroup.remove(menuButton);
        super.remove(menuButton);
        this.refreshMenu();
    }

    private void refreshMenu() {
        Enumeration<AbstractButton> enumeration = this.frameRadioButtonMenuItemGroup.getElements();
        int displayedCount = 1;
        while (enumeration.hasMoreElements()) {
            JMenuItem item = (JMenuItem)enumeration.nextElement();
            int currentMenuCount = displayedCount;
            if (currentMenuCount > 9) {
                currentMenuCount /= 10;
            }
            item.setMnemonic(48 + currentMenuCount);
            JInternalFrame associatedFrame = (JInternalFrame)item.getClientProperty("associatedFrame");
            item.setText(String.valueOf(displayedCount) + associatedFrame.getTitle());
            ++displayedCount;
        }
    }

    public void actionPerformed(ActionEvent e) {
        JInternalFrame associatedFrame;
        JRadioButtonMenuItem item;
        String actionCmd = e.getActionCommand();
        if (actionCmd.equals("Tile")) {
            this.positioning.tileInternalFrames();
        } else if (actionCmd.equals("Cascade")) {
            this.positioning.cascadeInternalFrames();
        } else if (actionCmd.equals("Close")) {
            JInternalFrame selectedFrame = this.desktop.getSelectedFrame();
            if (selectedFrame != null) {
                selectedFrame.doDefaultCloseAction();
            }
        } else if (actionCmd.equals("Close All")) {
            Component[] frames = this.desktop.getComponents();
            int i = 0;
            while (i < frames.length) {
                Component frame = frames[i];
                if (frame instanceof JInternalFrame) {
                    ((JInternalFrame)frame).dispose();
                } else {
                    this.remove(frame);
                }
                ++i;
            }
        } else if (e.getSource() instanceof JRadioButtonMenuItem && (item = (JRadioButtonMenuItem)e.getSource()).isSelected() && (associatedFrame = (JInternalFrame)((JComponent)e.getSource()).getClientProperty("associatedFrame")) != null) {
            this.activate(associatedFrame);
        }
    }

    private void activate(JInternalFrame frame) {
        try {
            frame.setSelected(true);
            frame.setVisible(true);
            frame.setIcon(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }
}

