/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.texteditor.TextEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JTextArea;

public class TextEditAction
implements ActionListener,
TextEditor.BufferOwner {
    JTextArea sourceEditor;
    TextEditor.Buffer sourceBuffer;
    ClosableDialog dialog;

    public TextEditAction(ClosableDialog dialog, JTextArea sourceEditor) {
        this.sourceEditor = sourceEditor;
        this.setDialog(dialog);
    }

    public void actionPerformed(ActionEvent e) {
        boolean lastWasDelimiter = false;
        String text = this.sourceEditor.getText();
        if (this.dialog != null) {
            this.dialog.hideWhileEditing();
        }
        this.sourceBuffer = TextEditor.get().createBuffer(this);
        this.sourceBuffer.setSyntaxHighlightingEnabled(false);
        if (text != null) {
            StringTokenizer tokenizer = new StringTokenizer(text, "\n", true);
            while (tokenizer.hasMoreElements()) {
                String temp = (String)tokenizer.nextElement();
                if (temp.equals("\n")) {
                    if (lastWasDelimiter) {
                        this.sourceBuffer.addLine("");
                        continue;
                    }
                    lastWasDelimiter = true;
                    continue;
                }
                this.sourceBuffer.addLine(temp);
                lastWasDelimiter = false;
            }
            this.sourceBuffer.setDirty(false);
        }
        this.sourceBuffer.setFilename("Fujaba");
    }

    public void bufferSaved(TextEditor.Buffer buffer) {
        this.sourceEditor.setText(buffer.getText());
        if (this.dialog != null) {
            this.dialog.okPressed();
        }
    }

    public void setDialog(ClosableDialog dialog) {
        this.dialog = dialog;
    }

    public static interface ClosableDialog {
        public void hideWhileEditing();

        public void okPressed();
    }
}

