/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_kassel.prop.CustomEditor;
import de.uni_kassel.prop.ObjectInspector;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.upb.tools.fca.FEmptyIterator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StereotypeDialog
extends JDialog {
    private static final String dialogTitle = "Edit Stereotypes";
    private JButton buttonOk;
    private JButton buttonCancel;
    JComboBox comboboxStereotype;
    StereotypePanel panelStereotype;
    DefaultListModel stereotypeListModel;
    private UMLIncrement increment;
    private static List stereotypeClasses;
    static /* synthetic */ Class class$0;

    public StereotypeDialog(Dialog owner, UMLIncrement increment) {
        super(owner, "Edit Stereotypes of " + increment, false);
        this.init(increment);
    }

    public StereotypeDialog(JFrame owner, UMLIncrement increment) {
        super(owner, "Edit Stereotypes of " + increment, false);
        this.init(increment);
    }

    protected void init(UMLIncrement increment) {
        this.increment = increment;
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)this.setupMainPanel(), "North");
        container.add((Component)this.setupButtonPanel(), "South");
        this.getContentPane().add(container);
        this.readStereotypes();
        this.addWindowListener(new DialogClose());
        this.pack();
        StereotypeDialog.centerDialog(this);
    }

    protected JPanel setupMainPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        panel.setLayout(gridBag);
        GridBagConstraints constraints = new GridBagConstraints();
        this.panelStereotype = new StereotypePanel();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(8, 0, 0, 0);
        gridBag.setConstraints(this.panelStereotype, constraints);
        panel.add(this.panelStereotype);
        return panel;
    }

    protected JPanel setupButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.buttonOk = new JButton("Ok");
        this.buttonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StereotypeDialog.this.okPressed();
            }
        });
        buttonPanel.add(this.buttonOk);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StereotypeDialog.this.cancelPressed();
            }
        });
        buttonPanel.add(this.buttonCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        return buttonPanel;
    }

    public void okPressed() {
        this.setVisible(false);
        this.writeStereotypes();
    }

    public void cancelPressed() {
        this.setVisible(false);
    }

    public static void centerDialog(JDialog diag) {
        Dimension screenSize = diag.getToolkit().getScreenSize();
        Dimension size = diag.getSize();
        int y = (screenSize.height - size.height) / 2;
        int x = (screenSize.width - size.width) / 2;
        diag.setLocation(x, y);
    }

    protected void readStereotypes() {
        if (this.increment != null) {
            Iterator it = UMLStereotypeManager.get().iteratorOfStereotypes();
            while (it.hasNext()) {
                this.comboboxStereotype.addItem(((UMLStereotype)it.next()).getText());
            }
            it = this.increment.iteratorOfStereotypes();
            while (it.hasNext()) {
                UMLStereotype type = (UMLStereotype)it.next();
                this.stereotypeListModel.addElement(type.getText());
            }
            this.panelStereotype.verifyAddButton();
        }
    }

    protected void writeStereotypes() {
        if (this.increment != null) {
            this.increment.removeAllFromStereotypes();
            Enumeration enumeration = this.stereotypeListModel.elements();
            while (enumeration.hasMoreElements()) {
                String type = (String)enumeration.nextElement();
                this.increment.addToStereotypes(UMLStereotypeManager.get().getFromStereotypes(type));
            }
        }
    }

    public static boolean addToStereotypeClasses(Class value) {
        boolean changed = false;
        if (value != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.uml.UMLStereotype");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(value)) {
                StereotypeDialog.initStereotypeClasses();
                if (!stereotypeClasses.contains(value)) {
                    changed = stereotypeClasses.add(value);
                }
            }
        }
        return changed;
    }

    private static void initStereotypeClasses() {
        if (stereotypeClasses == null) {
            stereotypeClasses = new LinkedList();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.uml.UMLStereotype");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            stereotypeClasses.add(clazz);
        }
    }

    public static Iterator iteratorOfStereotypeClasses() {
        if (stereotypeClasses == null) {
            return FEmptyIterator.get();
        }
        return stereotypeClasses.iterator();
    }

    public static boolean removeFromStereotypeClasses(Class value) {
        boolean changed = false;
        if (stereotypeClasses != null && value != null) {
            changed = stereotypeClasses.remove(value);
        }
        return changed;
    }

    public static int sizeOfStereotypeClasses() {
        return stereotypeClasses != null ? stereotypeClasses.size() : 0;
    }

    boolean createStereotype(String name) {
        if (!UMLStereotypeManager.get().hasKeyInStereotypes(name)) {
            StereotypeDialog.initStereotypeClasses();
            Object[] classNames = new String[StereotypeDialog.sizeOfStereotypeClasses()];
            int index = 0;
            Iterator it = StereotypeDialog.iteratorOfStereotypeClasses();
            while (it.hasNext()) {
                Class cls = (Class)it.next();
                String clsName = cls.getName();
                if (clsName.indexOf(46) >= 0) {
                    clsName = clsName.substring(clsName.lastIndexOf(46) + 1);
                }
                classNames[index++] = clsName;
            }
            String chosenClassName = (String)JOptionPane.showInputDialog(this, "A stereotype with the specified name does not exist. If you want to introduce a new stereotype choose a class of stereotypes and confirm.", "Create stereotype", 2, null, classNames, classNames[0]);
            if (chosenClassName != null) {
                try {
                    Iterator it2 = StereotypeDialog.iteratorOfStereotypeClasses();
                    while (it2.hasNext()) {
                        Class cls = (Class)it2.next();
                        if (!cls.getName().endsWith("." + chosenClassName)) continue;
                        UMLStereotype newStereotype = (UMLStereotype)cls.newInstance();
                        newStereotype.setText(name);
                        UMLStereotypeManager.get().addToStereotypes(newStereotype);
                        this.comboboxStereotype.addItem(name);
                        this.comboboxStereotype.setSelectedItem(name);
                        return true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Creation failed see console for further details: " + e.getMessage());
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    class DialogClose
    extends WindowAdapter {
        DialogClose() {
        }

        public void windowClosing(WindowEvent e) {
            StereotypeDialog.this.cancelPressed();
        }
    }

    class StereotypePanel
    extends JPanel
    implements ListSelectionListener {
        JList stereotypeList;
        private static final String strAdd = "Add";
        private static final String strRemove = "Remove";
        JButton buttonAdd;
        JButton buttonRemove;
        JButton buttonEdit;

        public StereotypePanel() {
            super.setBorder(new TitledBorder("Stereotypes"));
            StereotypeDialog.this.stereotypeListModel = new DefaultListModel();
            this.stereotypeList = new JList(StereotypeDialog.this.stereotypeListModel);
            this.stereotypeList.setSelectionMode(0);
            this.stereotypeList.setSelectedIndex(-1);
            this.stereotypeList.addListSelectionListener(this);
            JScrollPane listScrollPanel = new JScrollPane(this.stereotypeList);
            this.buttonAdd = new JButton(strAdd);
            this.buttonAdd.setActionCommand(strAdd);
            this.buttonAdd.addActionListener(new AddButtonListener());
            this.buttonRemove = new JButton(strRemove);
            this.buttonRemove.setActionCommand(strRemove);
            this.buttonRemove.addActionListener(new RemoveButtonListener());
            this.buttonEdit = new JButton("Edit");
            this.buttonEdit.addActionListener(new EditButtonListener());
            StereotypeDialog.this.comboboxStereotype = new JComboBox();
            StereotypeDialog.this.comboboxStereotype.setEditable(true);
            StereotypeDialog.this.comboboxStereotype.addKeyListener(new ComboBoxKeyListener());
            StereotypeDialog.this.comboboxStereotype.addActionListener(new ComboBoxActionListener());
            GridBagLayout gridBag = new GridBagLayout();
            super.setLayout(gridBag);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridwidth = 3;
            constraints.fill = 2;
            constraints.weightx = 3.0;
            constraints.weighty = 1.0;
            constraints.insets = new Insets(8, 0, 0, 0);
            gridBag.setConstraints(StereotypeDialog.this.comboboxStereotype, constraints);
            super.add(StereotypeDialog.this.comboboxStereotype);
            constraints.gridwidth = 1;
            constraints.fill = 2;
            constraints.weightx = 0.0;
            constraints.weighty = 1.0;
            constraints.insets = new Insets(8, 0, 0, 0);
            gridBag.setConstraints(this.buttonAdd, constraints);
            super.add(this.buttonAdd);
            constraints.gridwidth = 1;
            constraints.fill = 2;
            constraints.weightx = 0.0;
            constraints.weighty = 1.0;
            constraints.insets = new Insets(8, 0, 0, 0);
            gridBag.setConstraints(this.buttonRemove, constraints);
            super.add(this.buttonRemove);
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.weightx = 0.0;
            constraints.weighty = 1.0;
            constraints.insets = new Insets(8, 0, 0, 0);
            gridBag.setConstraints(this.buttonEdit, constraints);
            super.add(this.buttonEdit);
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.insets = new Insets(8, 0, 0, 0);
            gridBag.setConstraints(listScrollPanel, constraints);
            super.add(listScrollPanel);
        }

        public ListModel getListModel() {
            return StereotypeDialog.this.stereotypeListModel;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (this.stereotypeList.getSelectedIndex() == -1) {
                    this.buttonRemove.setEnabled(false);
                } else {
                    this.buttonRemove.setEnabled(true);
                    StereotypeDialog.this.comboboxStereotype.setSelectedItem(this.stereotypeList.getSelectedValue());
                }
            }
        }

        void verifyAddButton() {
            String selectedItem = (String)StereotypeDialog.this.comboboxStereotype.getSelectedItem();
            if (selectedItem != null) {
                this.stereotypeList.setSelectedValue(selectedItem, true);
                if (StereotypeDialog.this.stereotypeListModel.contains(selectedItem)) {
                    this.buttonAdd.setEnabled(false);
                } else {
                    this.buttonAdd.setEnabled(true);
                }
                UMLStereotype stereotype = UMLStereotypeManager.get().hasKeyInStereotypes(selectedItem) ? UMLStereotypeManager.get().getFromStereotypes(selectedItem) : null;
                this.buttonEdit.setEnabled(stereotype != null && ObjectInspector.get().getConfig().getCustomEditor(stereotype.getClass()) != null);
            }
        }

        class RemoveButtonListener
        implements ActionListener {
            RemoveButtonListener() {
            }

            public void actionPerformed(ActionEvent e) {
                int size;
                int index = StereotypePanel.this.stereotypeList.getSelectedIndex();
                if (index != -1) {
                    ((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.stereotypeListModel.remove(index);
                }
                if ((size = ((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.stereotypeListModel.getSize()) == 0) {
                    StereotypePanel.this.buttonRemove.setEnabled(false);
                } else {
                    if (index == ((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.stereotypeListModel.getSize()) {
                        --index;
                    }
                    StereotypePanel.this.stereotypeList.setSelectedIndex(index);
                }
                StereotypePanel.this.verifyAddButton();
            }
        }

        class EditButtonListener
        implements ActionListener {
            EditButtonListener() {
            }

            public void actionPerformed(ActionEvent e) {
                String selectedItem = (String)((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.comboboxStereotype.getSelectedItem();
                if (StereotypeDialog.this.createStereotype(selectedItem)) {
                    UMLStereotype stereotype = UMLStereotypeManager.get().getFromStereotypes(selectedItem);
                    CustomEditor customEditor = ObjectInspector.get().getConfig().getCustomEditor(stereotype.getClass());
                    if (customEditor != null) {
                        UMLStereotype result = (UMLStereotype)customEditor.edit((Object)stereotype);
                        if (result != stereotype) {
                            ((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.comboboxStereotype.removeItem(selectedItem);
                            ((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.comboboxStereotype.addItem(result.getText());
                            ((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.comboboxStereotype.setSelectedItem(result.getText());
                        }
                        ((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.comboboxStereotype.repaint();
                    }
                }
            }
        }

        class AddButtonListener
        implements ActionListener {
            AddButtonListener() {
            }

            public void actionPerformed(ActionEvent e) {
                int listindex = StereotypePanel.this.stereotypeList.getSelectedIndex();
                int size = ((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.stereotypeListModel.getSize();
                int comboindex = ((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.comboboxStereotype.getSelectedIndex();
                if (((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.comboboxStereotype.getSelectedItem() != null) {
                    if (listindex == -1 || listindex + 1 == size) {
                        ((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.stereotypeListModel.addElement(((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.comboboxStereotype.getSelectedItem());
                        StereotypePanel.this.stereotypeList.setSelectedIndex(size);
                    } else {
                        ((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.stereotypeListModel.insertElementAt(((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.comboboxStereotype.getSelectedItem(), listindex + 1);
                        StereotypePanel.this.stereotypeList.setSelectedIndex(listindex + 1);
                    }
                    if (comboindex == -1) {
                        ((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.comboboxStereotype.addItem(((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.comboboxStereotype.getSelectedItem());
                    }
                    StereotypePanel.this.verifyAddButton();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        class ComboBoxActionListener
        implements ActionListener {
            ComboBoxActionListener() {
            }

            public void actionPerformed(ActionEvent e) {
                if (!StereotypeDialog.this.createStereotype((String)((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.comboboxStereotype.getSelectedItem())) {
                    ((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.comboboxStereotype.setSelectedIndex(0);
                }
                StereotypePanel.this.verifyAddButton();
            }
        }

        class ComboBoxKeyListener
        extends KeyAdapter {
            ComboBoxKeyListener() {
            }

            public void keyTyped(KeyEvent e) {
                StereotypePanel.this.getRootPane().setDefaultButton(((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.panelStereotype.buttonAdd);
                String text = ((String)((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.comboboxStereotype.getEditor().getItem()).trim();
                if (text != null) {
                    if (((StereotypePanel)StereotypePanel.this).StereotypeDialog.this.stereotypeListModel.contains(text)) {
                        StereotypePanel.this.buttonAdd.setEnabled(false);
                    } else {
                        StereotypePanel.this.buttonAdd.setEnabled(true);
                    }
                }
            }
        }
    }
}

