/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.ActivityPanel;
import de.uni_paderborn.fujaba.gui.EditActivityDialog;
import de.uni_paderborn.fujaba.gui.TextEditAction;
import de.uni_paderborn.fujaba.texteditor.TextEditor;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLStatement;
import de.uni_paderborn.fujaba.uml.UMLStatementActivity;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class StatementActivityPanel
extends ActivityPanel {
    JTextArea sourceEditor;
    TextEditor.Buffer sourceBuffer;
    private TextEditAction textEditAction;

    public StatementActivityPanel(ASGElement asgElement) {
        this.setAsgElement(asgElement);
        if (this.isResponsible()) {
            GridBagLayout gridBag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridBag);
            constraints.fill = 1;
            constraints.gridwidth = 0;
            constraints.anchor = 11;
            constraints.weightx = 1.0;
            JLabel statementLabel = new JLabel("Statement");
            constraints.insets = new Insets(0, 3, 0, 3);
            gridBag.setConstraints(statementLabel, constraints);
            this.add(statementLabel);
            this.sourceEditor = new JTextArea();
            this.sourceEditor.setToolTipText("Edit Statement");
            this.sourceEditor.setColumns(30);
            this.sourceEditor.setRows(5);
            JScrollPane scrollPane = new JScrollPane(this.sourceEditor);
            constraints.weighty = 1.0;
            constraints.insets = new Insets(0, 3, 3, 3);
            gridBag.setConstraints(scrollPane, constraints);
            this.add(scrollPane);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1));
            JButton textEditButton = new JButton("Open in editor");
            this.textEditAction = new TextEditAction(this.getActivityDialog(), this.sourceEditor);
            textEditButton.addActionListener(this.textEditAction);
            gridBag.setConstraints(textEditButton, constraints);
            buttonPanel.add(textEditButton);
            this.add(buttonPanel);
        }
    }

    public void setActivityDialog(EditActivityDialog elem) {
        super.setActivityDialog(elem);
        if (this.isResponsible() && this.textEditAction != null) {
            this.textEditAction.setDialog(elem);
        }
    }

    public String getName() {
        return "Statement";
    }

    public boolean isResponsible() {
        return this.getAsgElement() instanceof UMLStatementActivity || this.getAsgElement() instanceof UMLActivityDiagram || this.getAsgElement() instanceof ViewDiagram && ((ViewDiagram)this.getAsgElement()).getOriginalDiagram() instanceof UMLActivityDiagram;
    }

    public UMLActivity parse() {
        UMLStatementActivity activity = null;
        if (this.getAsgElement() instanceof UMLActivityDiagram || this.getAsgElement() instanceof ViewDiagram && ((ViewDiagram)this.getAsgElement()).getOriginalDiagram() instanceof UMLActivityDiagram) {
            UMLDiagram diag = (UMLDiagram)this.getAsgElement();
            UMLStatement statement = new UMLStatement(this.sourceEditor.getText(), null);
            activity = new UMLStatementActivity(statement);
            diag.addToElements(activity);
        } else if (this.getAsgElement() instanceof UMLStatementActivity && (activity = (UMLStatementActivity)this.getAsgElement()) != null) {
            if (activity.getState() != null) {
                activity.getState().setStatement(this.sourceEditor.getText());
            } else {
                activity.setState(new UMLStatement(this.sourceEditor.getText(), null));
            }
        }
        return activity;
    }

    public void unparse() {
        if (this.getAsgElement() instanceof UMLStatementActivity) {
            UMLStatementActivity activity = (UMLStatementActivity)this.getAsgElement();
            if (activity != null) {
                UMLStatement statement = activity.getState();
                if (statement != null) {
                    this.sourceEditor.append(statement.getStatement());
                }
            } else {
                this.sourceEditor.setText("");
            }
        }
    }
}

