/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.ActivityPanel;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLComplexState;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLStartActivity;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StateActivityPanel
extends ActivityPanel {
    private static int stateCount = 0;
    SetListModel setListModel;
    private JTextField stateNameTextField;
    private JTextField entryEventTextField;
    private JTextField doEventTextField;
    private JTextField exitEventTextField;
    JComboBox deferredEventsComboBox;
    JList deferredEventsList;
    private JButton addButton;
    JButton removeButton;

    public StateActivityPanel(ASGElement asgElement) {
        this.setAsgElement(asgElement);
        if (this.isResponsible()) {
            GridBagLayout gridBag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridBag);
            constraints.gridwidth = 0;
            constraints.fill = 1;
            constraints.weightx = 1.0;
            JLabel nameLabel = new JLabel("State name");
            constraints.insets = new Insets(0, 3, 0, 3);
            gridBag.setConstraints(nameLabel, constraints);
            this.add(nameLabel);
            this.stateNameTextField = new JTextField();
            gridBag.setConstraints(this.stateNameTextField, constraints);
            this.add(this.stateNameTextField);
            JLabel entryLabel = new JLabel("Entry event");
            constraints.insets = new Insets(8, 3, 0, 3);
            gridBag.setConstraints(entryLabel, constraints);
            this.add(entryLabel);
            this.entryEventTextField = new JTextField();
            constraints.insets = new Insets(0, 3, 0, 3);
            gridBag.setConstraints(this.entryEventTextField, constraints);
            this.add(this.entryEventTextField);
            JLabel doLabel = new JLabel("Do event");
            constraints.insets = new Insets(8, 3, 0, 3);
            gridBag.setConstraints(doLabel, constraints);
            this.add(doLabel);
            this.doEventTextField = new JTextField();
            constraints.insets = new Insets(0, 3, 0, 3);
            gridBag.setConstraints(this.doEventTextField, constraints);
            this.add(this.doEventTextField);
            JLabel exitLabel = new JLabel("Exit event");
            constraints.insets = new Insets(8, 3, 0, 3);
            gridBag.setConstraints(exitLabel, constraints);
            this.add(exitLabel);
            this.exitEventTextField = new JTextField();
            constraints.insets = new Insets(0, 3, 0, 3);
            gridBag.setConstraints(this.exitEventTextField, constraints);
            this.add(this.exitEventTextField);
            JLabel deferredLabel = new JLabel("Deferred events");
            constraints.insets = new Insets(8, 3, 0, 3);
            gridBag.setConstraints(deferredLabel, constraints);
            this.add(deferredLabel);
            this.deferredEventsComboBox = new JComboBox();
            constraints.insets = new Insets(0, 3, 0, 3);
            gridBag.setConstraints(this.deferredEventsComboBox, constraints);
            this.add(this.deferredEventsComboBox);
            if (this.getAsgElement() instanceof UMLActivityDiagram || this.getAsgElement() instanceof ViewDiagram && ((ViewDiagram)this.getAsgElement()).getOriginalDiagram() instanceof UMLActivityDiagram) {
                this.setListModel = new SetListModel();
            } else if (this.getAsgElement() instanceof UMLComplexState) {
                UMLComplexState complexState = (UMLComplexState)this.getAsgElement();
                this.setListModel = new SetListModel(complexState.getDeferredEvents());
            }
            this.deferredEventsList = new JList(this.setListModel);
            this.deferredEventsList.setSelectionMode(0);
            this.deferredEventsList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (StateActivityPanel.this.deferredEventsList.isSelectionEmpty()) {
                        StateActivityPanel.this.removeButton.setEnabled(false);
                    } else {
                        StateActivityPanel.this.removeButton.setEnabled(true);
                    }
                }
            });
            JScrollPane scrollPane = new JScrollPane(this.deferredEventsList);
            constraints.weighty = 1.0;
            gridBag.setConstraints(scrollPane, constraints);
            this.add(scrollPane);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout());
            this.addButton = new JButton("Add");
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    StateActivityPanel.this.setListModel.addElement(StateActivityPanel.this.deferredEventsComboBox.getSelectedItem());
                }
            });
            buttonPanel.add(this.addButton);
            this.removeButton = new JButton("Remove");
            this.removeButton.setEnabled(false);
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    StateActivityPanel.this.setListModel.removeElement(StateActivityPanel.this.deferredEventsList.getSelectedValue());
                }
            });
            buttonPanel.add(this.removeButton);
            constraints.weighty = 0.0;
            gridBag.setConstraints(buttonPanel, constraints);
            this.add(buttonPanel);
        }
    }

    public String getName() {
        return "State";
    }

    public boolean isResponsible() {
        return this.getAsgElement() instanceof UMLComplexState || this.getAsgElement() instanceof UMLActivityDiagram || this.getAsgElement() instanceof ViewDiagram && ((ViewDiagram)this.getAsgElement()).getOriginalDiagram() instanceof UMLActivityDiagram;
    }

    public void unparse() {
        UMLComplexState state;
        ASGElement asgElement = this.getAsgElement();
        if (asgElement instanceof UMLActivityDiagram || asgElement instanceof ViewDiagram && ((ViewDiagram)asgElement).getOriginalDiagram() instanceof UMLActivityDiagram) {
            this.stateNameTextField.setText("state" + stateCount);
            ++stateCount;
        } else if (asgElement instanceof UMLComplexState && (state = (UMLComplexState)asgElement) != null) {
            this.stateNameTextField.setText(state.getName());
            this.entryEventTextField.setText(state.getEntryAction());
            this.doEventTextField.setText(state.getDoAction());
            this.exitEventTextField.setText(state.getExitAction());
            Iterator iter = state.iteratorOfDeferredEvents();
            while (iter.hasNext()) {
                this.setListModel.addElement(iter.next());
            }
        }
        this.fillDeferredEventsComboBox();
    }

    public UMLActivity parse() {
        ASGElement asgElement = this.getAsgElement();
        UMLComplexState complexState = null;
        if (asgElement instanceof UMLActivityDiagram || asgElement instanceof ViewDiagram && ((ViewDiagram)asgElement).getOriginalDiagram() instanceof UMLActivityDiagram) {
            ViewDiagram viewDiag;
            UMLDiagram diag = (UMLDiagram)asgElement;
            if (!(diag instanceof UMLActivityDiagram)) {
                return null;
            }
            if (diag instanceof ViewDiagram && (viewDiag = (ViewDiagram)diag).getOriginalDiagram() instanceof UMLActivityDiagram) {
                return null;
            }
            complexState = new UMLComplexState();
            UMLActivityDiagram subDiag = new UMLActivityDiagram();
            this.writeAttributesToState(complexState);
            diag.addToElements(complexState);
            complexState.addToContains(subDiag);
        }
        if (asgElement instanceof UMLComplexState) {
            complexState = (UMLComplexState)asgElement;
            this.writeAttributesToState(complexState);
        }
        return complexState;
    }

    private void writeAttributesToState(UMLComplexState state) {
        state.setName(this.stateNameTextField.getText());
        Iterator containsIter = state.iteratorOfContains();
        while (containsIter.hasNext()) {
            ((UMLActivityDiagram)containsIter.next()).setName(this.stateNameTextField.getText());
        }
        state.setEntryAction(this.entryEventTextField.getText());
        state.setDoAction(this.doEventTextField.getText());
        state.setExitAction(this.exitEventTextField.getText());
        state.removeAllFromDeferredEvents();
        int i = 0;
        while (i < this.setListModel.getSize()) {
            state.addToDeferredEvents((String)this.setListModel.getElementAt(i));
            ++i;
        }
    }

    private void fillDeferredEventsComboBox() {
        UMLClass umlClass;
        UMLStartActivity umlStartActivity;
        UMLActivityDiagram tmpActDiagram;
        ASGElement asgElement = this.getAsgElement();
        UMLActivityDiagram activityDiagram = null;
        if (asgElement instanceof UMLActivityDiagram) {
            activityDiagram = (UMLActivityDiagram)asgElement;
        } else if (asgElement instanceof UMLComplexState) {
            activityDiagram = ((UMLComplexState)asgElement).getActivityDiagram();
        } else if (asgElement instanceof ViewDiagram && ((ViewDiagram)asgElement).getOriginalDiagram() instanceof UMLActivityDiagram) {
            activityDiagram = (UMLActivityDiagram)((ViewDiagram)asgElement).getOriginalDiagram();
        }
        if (activityDiagram != null && (tmpActDiagram = activityDiagram.findActivityDiagramOfMasterState()) != null && (umlStartActivity = tmpActDiagram.getStartActivity()) != null && (umlClass = umlStartActivity.getRevStartOfStateChart()) != null) {
            Iterator iter = umlClass.iteratorOfMethods();
            while (iter.hasNext()) {
                UMLMethod umlMethod = (UMLMethod)iter.next();
                if (!umlMethod.isSignal()) continue;
                this.deferredEventsComboBox.addItem(umlMethod.getName());
            }
        }
    }

    private class SetListModel
    extends AbstractListModel {
        private Vector elements = new Vector();

        public SetListModel() {
        }

        public SetListModel(Set set) {
            if (set != null) {
                this.elements.addAll(set);
            }
        }

        public Object getElementAt(int index) {
            return this.elements.elementAt(index);
        }

        public int getSize() {
            return this.elements.size();
        }

        public void addElement(Object object) {
            if (!this.elements.contains(object)) {
                this.elements.addElement(object);
                this.fireContentsChanged(this, this.elements.size() - 1, this.elements.size());
            }
            StateActivityPanel.this.deferredEventsList.clearSelection();
        }

        public void removeElement(Object object) {
            this.elements.remove(object);
            this.fireContentsChanged(this, 0, this.elements.size());
            StateActivityPanel.this.deferredEventsList.clearSelection();
        }
    }
}

