/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.AbstractDialog;
import de.uni_paderborn.fujaba.packagediagrams.DiagramUsage;
import de.uni_paderborn.fujaba.packagediagrams.PackageDiagram;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStoryActivity;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.uni_paderborn.fujaba.views.ViewDefinition;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class SDMObjectDialog
extends AbstractDialog {
    private ASGElement umlIncrement;
    JComboBox objectNameCombo;
    JComboBox typeComboBox;
    JCheckBox boundCheckBox;
    JCheckBox typeCastCheckBox;
    private JRadioButton negativeRadioButton;
    private JCheckBox assertCheckBox;
    JComboBox typeCastComboBox;
    private JRadioButton noConstraintRadioButton;
    private JRadioButton optionalRadioButton;
    private JRadioButton setRadioButton;
    private JRadioButton noneRadioButton;
    private JRadioButton destroyRadioButton;
    private JRadioButton createRadioButton;
    private ViewDiagram viewDiag = null;
    private JButton browseButton;
    private JButton defaultButton;
    JTextField currentIcon;
    private UMLStoryPattern storyPattern;
    private Vector objectNames;
    private Map objectMap;
    UMLObject object = null;

    public SDMObjectDialog(JFrame frame, ASGElement umlIncrement) {
        super(frame, false);
        this.umlIncrement = umlIncrement;
        this.createUserInterface();
        this.initialize();
    }

    public SDMObjectDialog(JFrame frame, ASGElement umlIncrement, ViewDiagram viewDiag) {
        this(frame, umlIncrement);
        this.viewDiag = viewDiag;
    }

    protected JPanel createMainPanel() {
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel leftPanel = new JPanel();
        leftPanel.setBorder(new TitledBorder("Object"));
        leftPanel.setLayout(gridBag);
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        JLabel objectNameLabel = new JLabel("Name");
        constraints.insets = new Insets(3, 3, 0, 3);
        gridBag.setConstraints(objectNameLabel, constraints);
        leftPanel.add(objectNameLabel);
        this.objectNames = new Vector();
        this.objectNameCombo = new JComboBox(this.objectNames);
        this.objectNameCombo.setEditable(true);
        this.objectNameCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String objectName = (String)SDMObjectDialog.this.objectNameCombo.getSelectedItem();
                UMLClass type = (UMLClass)SDMObjectDialog.this.getObjectMap().get(objectName);
                if (type != null) {
                    SDMObjectDialog.this.typeComboBox.setSelectedItem(type);
                }
                SDMObjectDialog.this.boundCheckBox.setSelected(SDMObjectDialog.this.shouldObjectBeBound(objectName));
            }
        });
        SDMObjectDialog.enableCompletion(this.objectNameCombo);
        constraints.insets = new Insets(0, 3, 0, 3);
        gridBag.setConstraints(this.objectNameCombo, constraints);
        leftPanel.add(this.objectNameCombo);
        JLabel objectTypeLabel = new JLabel("Type");
        constraints.insets = new Insets(8, 3, 0, 3);
        gridBag.setConstraints(objectTypeLabel, constraints);
        leftPanel.add(objectTypeLabel);
        this.typeComboBox = new JComboBox();
        this.typeComboBox.setEditable(true);
        SDMObjectDialog.enableCompletion(this.typeComboBox);
        this.typeComboBox.setRenderer(new TypeListRenderer());
        constraints.insets = new Insets(0, 3, 0, 3);
        gridBag.setConstraints(this.typeComboBox, constraints);
        leftPanel.add(this.typeComboBox);
        JLabel typeCastLabel = new JLabel("Direct Assignment");
        constraints.insets = new Insets(8, 3, 0, 3);
        gridBag.setConstraints(typeCastLabel, constraints);
        leftPanel.add((Component)typeCastLabel, constraints);
        this.typeCastCheckBox = new JCheckBox("Type cast");
        this.typeCastCheckBox.addActionListener(new TypeCastCheckBoxListener());
        constraints.insets = new Insets(0, 3, 0, 3);
        gridBag.setConstraints(this.typeCastCheckBox, constraints);
        leftPanel.add(this.typeCastCheckBox);
        this.typeCastComboBox = new JComboBox(this.objectNames);
        this.typeCastComboBox.setEditable(true);
        SDMObjectDialog.enableCompletion(this.typeCastComboBox);
        gridBag.setConstraints(this.typeCastComboBox, constraints);
        leftPanel.add(this.typeCastComboBox);
        JLabel boundLabel = new JLabel("State");
        constraints.insets = new Insets(8, 3, 0, 3);
        gridBag.setConstraints(boundLabel, constraints);
        leftPanel.add(boundLabel);
        this.boundCheckBox = new JCheckBox("Bound");
        this.boundCheckBox.setMnemonic('b');
        constraints.insets = new Insets(0, 3, 3, 3);
        gridBag.setConstraints(this.boundCheckBox, constraints);
        leftPanel.add(this.boundCheckBox);
        panel.add(leftPanel);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(gridBag);
        rightPanel.setBorder(new TitledBorder("Properties"));
        ButtonGroup constraintButtonGroup = new ButtonGroup();
        TypeModifierListener tmListener = new TypeModifierListener();
        JLabel constraintLabel = new JLabel("Constraint");
        constraints.insets = new Insets(3, 3, 0, 3);
        gridBag.setConstraints(constraintLabel, constraints);
        rightPanel.add(constraintLabel);
        this.noConstraintRadioButton = new JRadioButton("None");
        constraints.insets = new Insets(0, 9, 0, 3);
        gridBag.setConstraints(this.noConstraintRadioButton, constraints);
        constraintButtonGroup.add(this.noConstraintRadioButton);
        this.noConstraintRadioButton.addActionListener(tmListener);
        rightPanel.add(this.noConstraintRadioButton);
        this.negativeRadioButton = new JRadioButton("Negative");
        this.negativeRadioButton.setMnemonic('n');
        gridBag.setConstraints(this.negativeRadioButton, constraints);
        constraintButtonGroup.add(this.negativeRadioButton);
        this.negativeRadioButton.addActionListener(tmListener);
        rightPanel.add(this.negativeRadioButton);
        this.optionalRadioButton = new JRadioButton("Optional");
        this.negativeRadioButton.setMnemonic('o');
        gridBag.setConstraints(this.optionalRadioButton, constraints);
        constraintButtonGroup.add(this.optionalRadioButton);
        this.optionalRadioButton.addActionListener(tmListener);
        rightPanel.add(this.optionalRadioButton);
        this.setRadioButton = new JRadioButton("Set");
        this.negativeRadioButton.setMnemonic('s');
        gridBag.setConstraints(this.setRadioButton, constraints);
        constraintButtonGroup.add(this.setRadioButton);
        this.setRadioButton.addActionListener(tmListener);
        rightPanel.add(this.setRadioButton);
        this.assertCheckBox = new JCheckBox("Assert");
        this.negativeRadioButton.setMnemonic('a');
        gridBag.setConstraints(this.assertCheckBox, constraints);
        rightPanel.add(this.assertCheckBox);
        ButtonGroup modifierButtonGroup = new ButtonGroup();
        JLabel modifierLabel = new JLabel("Modifier");
        constraints.insets = new Insets(8, 3, 0, 3);
        gridBag.setConstraints(modifierLabel, constraints);
        rightPanel.add(modifierLabel);
        this.noneRadioButton = new JRadioButton("None");
        constraints.insets = new Insets(0, 9, 0, 3);
        gridBag.setConstraints(this.noneRadioButton, constraints);
        modifierButtonGroup.add(this.noneRadioButton);
        this.noneRadioButton.addActionListener(tmListener);
        rightPanel.add(this.noneRadioButton);
        this.createRadioButton = new JRadioButton("Create");
        this.negativeRadioButton.setMnemonic('c');
        gridBag.setConstraints(this.createRadioButton, constraints);
        modifierButtonGroup.add(this.createRadioButton);
        this.createRadioButton.addActionListener(tmListener);
        rightPanel.add(this.createRadioButton);
        this.destroyRadioButton = new JRadioButton("Destroy");
        this.negativeRadioButton.setMnemonic('d');
        gridBag.setConstraints(this.destroyRadioButton, constraints);
        modifierButtonGroup.add(this.destroyRadioButton);
        this.destroyRadioButton.addActionListener(tmListener);
        rightPanel.add(this.destroyRadioButton);
        JLabel iconLabel = new JLabel("Current Icon");
        constraints.insets = new Insets(0, 3, 0, 3);
        gridBag.setConstraints(iconLabel, constraints);
        leftPanel.add(iconLabel);
        this.currentIcon = new JTextField();
        constraints.insets = new Insets(0, 3, 0, 3);
        gridBag.setConstraints(this.currentIcon, constraints);
        leftPanel.add(this.currentIcon);
        JPanel buttonPanel = new JPanel();
        this.browseButton = new JButton("Browse...");
        this.browseButton.addActionListener(this.createBrowseListener());
        this.defaultButton = new JButton("Default");
        this.defaultButton.addActionListener(this.createDefaultListener());
        buttonPanel.add(this.browseButton);
        buttonPanel.add(this.defaultButton);
        leftPanel.add(buttonPanel);
        panel.add(rightPanel);
        return panel;
    }

    Map getObjectMap() {
        if (this.objectMap == null) {
            this.objectMap = new TreeMap();
            UMLDiagram firstFromDiagrams = this.storyPattern.getRevStoryPattern().getFirstFromDiagrams();
            if (firstFromDiagrams instanceof UMLActivityDiagram) {
                UMLMethod method;
                UMLActivityDiagram activityDiagram = (UMLActivityDiagram)firstFromDiagrams;
                Iterator it = activityDiagram.iteratorOfObjects();
                while (it.hasNext()) {
                    UMLObject object = (UMLObject)it.next();
                    this.objectMap.put(object.getObjectName(), object.getInstanceOf());
                }
                UMLMethod uMLMethod = method = activityDiagram.getStartActivity() != null ? activityDiagram.getStartActivity().getSpec() : null;
                if (method != null) {
                    this.objectMap.put("this", method.getParent());
                    Iterator it2 = method.iteratorOfParam();
                    while (it2.hasNext()) {
                        UMLParam param = (UMLParam)it2.next();
                        if (!(param.getParamType() instanceof UMLClass)) continue;
                        this.objectMap.put(param.getName(), param.getParamType());
                    }
                }
            }
        }
        return this.objectMap;
    }

    public static void enableCompletion(final JComboBox comboBox) {
        Component editorComponent = comboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            final JTextField textField = (JTextField)editorComponent;
            final Document document = textField.getDocument();
            document.addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    SwingUtilities.invokeLater(new Runnable(this, document, comboBox, textField){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ Document val$document;
                        private final /* synthetic */ JComboBox val$comboBox;
                        private final /* synthetic */ JTextField val$textField;
                        {
                            this.this$1 = var1_1;
                            this.val$document = document;
                            this.val$comboBox = jComboBox;
                            this.val$textField = jTextField;
                        }

                        public void run() {
                            try {
                                String text = this.val$document.getText(0, this.val$document.getLength());
                                int shortest = Integer.MAX_VALUE;
                                String shortestMatchingItem = null;
                                int shortestMatchingIndex = -1;
                                int i = 0;
                                while (i < this.val$comboBox.getItemCount()) {
                                    String item = "" + this.val$comboBox.getItemAt(i);
                                    if (item.length() < shortest && item.startsWith(text)) {
                                        shortestMatchingItem = item;
                                        shortestMatchingIndex = i;
                                        shortest = item.length();
                                    }
                                    ++i;
                                }
                                if (shortestMatchingItem != null && !text.equals(shortestMatchingItem)) {
                                    this.val$textField.setText(shortestMatchingItem);
                                    this.val$comboBox.setSelectedIndex(shortestMatchingIndex);
                                    this.val$textField.setCaretPosition(text.length());
                                    this.val$textField.moveCaretPosition(shortestMatchingItem.length());
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                }

                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                public void removeUpdate(DocumentEvent e) {
                }
            });
        }
    }

    protected boolean shouldObjectBeBound(String objectName) {
        UMLMethod myMethod;
        UMLActivityDiagram activityDiagram;
        UMLDiagram firstFromDiagrams;
        if (this.getObject() != null) {
            return this.getObject().isBound();
        }
        if ("this".equals(objectName)) {
            return true;
        }
        if (this.getObjectMap().containsKey(objectName) && (firstFromDiagrams = this.storyPattern.getRevStoryPattern().getFirstFromDiagrams()) instanceof UMLActivityDiagram && (activityDiagram = (UMLActivityDiagram)firstFromDiagrams).getStartActivity() != null && (myMethod = activityDiagram.getStartActivity().getSpec()) != null) {
            Iterator params = myMethod.iteratorOfParam();
            while (params.hasNext()) {
                UMLParam param = (UMLParam)params.next();
                if (!param.getName().equals(objectName) || !(param.getParamType() instanceof UMLClass)) continue;
                return true;
            }
        }
        return false;
    }

    private ActionListener createBrowseListener() {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SDMObjectDialog.this.browse();
            }
        };
        return listener;
    }

    private ActionListener createDefaultListener() {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SDMObjectDialog.this.currentIcon.setText(SDMObjectDialog.this.object.getInstanceOf().getDefaultIcon());
            }
        };
        return listener;
    }

    void browse() {
        JFileChooser jf = new JFileChooser(".");
        int opt = jf.showDialog(this, "Choose an icon");
        if (opt == 0) {
            this.currentIcon.setText(jf.getSelectedFile().getPath());
        }
    }

    protected void unparse() {
        this.fillTypeComboBox();
        if (this.umlIncrement instanceof UMLObject) {
            this.object = (UMLObject)this.umlIncrement;
            this.storyPattern = (UMLStoryPattern)this.object.getFirstFromDiagrams();
            this.objectNameCombo.getEditor().setItem(this.object.getObjectName());
            this.typeComboBox.setSelectedItem(this.object.getInstanceOf());
            if (this.object.isCheckTypeCast()) {
                this.typeCastCheckBox.setSelected(true);
            } else {
                this.typeCastCheckBox.setSelected(false);
            }
            this.typeCastComboBox.setSelectedItem(this.object.getTypeCastSource());
            this.boundCheckBox.setSelected(this.object.isBound());
            switch (this.object.getType()) {
                case 0: {
                    this.noConstraintRadioButton.setSelected(true);
                    break;
                }
                case 2: {
                    this.negativeRadioButton.setSelected(true);
                    break;
                }
                case 1: {
                    this.optionalRadioButton.setSelected(true);
                    break;
                }
                case 3: {
                    this.setRadioButton.setSelected(true);
                }
            }
            this.assertCheckBox.setSelected(this.object.isAssertInUnitTest());
            switch (this.object.getModifier()) {
                case 0: {
                    this.noneRadioButton.setSelected(true);
                    break;
                }
                case 2: {
                    this.createRadioButton.setSelected(true);
                    break;
                }
                case 1: {
                    this.destroyRadioButton.setSelected(true);
                }
            }
            this.enableRadioButtons();
            this.getOkButton().setText("Apply");
            this.setTitle("Edit Object");
            this.currentIcon.setText(this.object.getCurrentIcon());
        } else {
            this.storyPattern = this.umlIncrement instanceof UMLStoryActivity ? ((UMLStoryActivity)this.umlIncrement).getStoryPattern() : (UMLStoryPattern)this.umlIncrement;
            this.typeCastCheckBox.setSelected(false);
            this.typeCastComboBox.setSelectedItem(null);
            this.boundCheckBox.setSelected(false);
            this.assertCheckBox.setSelected(false);
            this.noConstraintRadioButton.setSelected(true);
            this.noneRadioButton.setSelected(true);
            this.setTitle("New Object");
        }
        this.updateObjectNames();
    }

    private void fillTypeComboBox() {
        Iterator iter = UMLProject.get().getTypeList().sortedIteratorOfTypes();
        while (iter.hasNext()) {
            UMLType type = (UMLType)iter.next();
            if (!(type instanceof UMLClass)) continue;
            this.typeComboBox.addItem(type);
        }
    }

    protected void parse() {
        if (this.umlIncrement instanceof UMLObject) {
            UMLObject obj = (UMLObject)this.umlIncrement;
            this.writeAttributesToUMLObject(obj);
            obj.setCurrentIcon(this.currentIcon.getText());
        } else if ((this.umlIncrement instanceof UMLStoryActivity || this.umlIncrement instanceof UMLStoryPattern) && this.storyPattern != null) {
            this.object = new UMLObject();
            this.writeAttributesToUMLObject(this.object);
            this.storyPattern.addToElements(this.object);
            if (this.viewDiag != null) {
                Iterator viewDefIter = this.viewDiag.iteratorOfViewDefinitions();
                if (viewDefIter.hasNext()) {
                    ViewDefinition viewDefinition = (ViewDefinition)viewDefIter.next();
                    viewDefinition.addToItems(this.object, this.storyPattern);
                    viewDefinition.addToStartItems(this.object);
                }
                this.viewDiag.update();
            }
        }
        UMLProject.get().refreshDisplay();
    }

    private void updateObjectNames() {
        this.objectMap = null;
        this.objectNames.clear();
        this.objectNames.addAll(this.getObjectMap().keySet());
    }

    private void writeAttributesToUMLObject(UMLObject object) {
        object.setObjectName((String)this.objectNameCombo.getSelectedItem());
        Object usertype = this.typeComboBox.getSelectedItem();
        UMLClass type = null;
        if (usertype instanceof UMLClass) {
            type = (UMLClass)usertype;
        } else if (usertype instanceof String && !((String)usertype).trim().equals("")) {
            String userClassName = (String)usertype;
            Pattern bracketExpr = Pattern.compile("^(.+?)\\s*\\((.*)\\)\\s*$");
            Matcher matcher = bracketExpr.matcher(userClassName);
            if (matcher.find()) {
                String prefix = matcher.group(2).trim();
                userClassName = !"".equals(prefix) ? String.valueOf(matcher.group(2)) + "." + matcher.group(1) : matcher.group(1);
            }
            if (!(userClassName = userClassName.trim()).equals("")) {
                type = UMLProject.get().findClass(null, userClassName, false);
                if (type == null && "".equals(UMLProject.getPackageOfFullQualifiedType(userClassName))) {
                    Iterator typeIter = UMLProject.get().getTypeList().iteratorOfTypes();
                    while (typeIter.hasNext() && type == null) {
                        UMLType tmpType = (UMLType)typeIter.next();
                        if (!(tmpType instanceof UMLClass) || !tmpType.getName().equals(userClassName)) continue;
                        type = (UMLClass)tmpType;
                    }
                    if (type != null) {
                        Object[] options = new String[]{"Use this", "Create new"};
                        String message = "A class with name \"" + userClassName + "\" was found in ";
                        message = type.getDeclaredInPackage() != null ? String.valueOf(message) + "package " + type.getDeclaredInPackage().getFullPackageName() : (type.getDeclaredInClass() != null ? String.valueOf(message) + "class " + type.getDeclaredInClass().getFullClassName() : String.valueOf(message) + "a mysterious place");
                        int answer = JOptionPane.showOptionDialog(this, message = String.valueOf(message) + ".\n\nDo you want to use that class or create a new one in the root package?", "Existing class found", 0, 3, null, options, options[0]);
                        if (answer == 1) {
                            type = null;
                        }
                    }
                }
                if (type == null) {
                    type = UMLProject.get().getOrNewClass(userClassName);
                    Iterator iter = UMLProject.get().iteratorOfDiags();
                    boolean done = false;
                    while (iter.hasNext()) {
                        Object obj = iter.next();
                        if (!(obj instanceof UMLClassDiagram)) continue;
                        UMLClassDiagram myDiag = (UMLClassDiagram)obj;
                        myDiag.addToElements(type);
                        done = true;
                        break;
                    }
                    if (!done) {
                        UMLClassDiagram newDiag = new UMLClassDiagram("Main", UMLProject.get());
                        newDiag.addToElements(type);
                        UMLDiagram designDiag = UMLProject.get().getFromDiags("Design");
                        if (designDiag instanceof PackageDiagram) {
                            PackageDiagram packageDiag = (PackageDiagram)designDiag;
                            DiagramUsage usage = new DiagramUsage();
                            usage.setDiagram(newDiag);
                            packageDiag.addToElements(usage);
                        }
                    }
                }
            }
        }
        if (type != null) {
            object.setInstanceOf(type);
        }
        object.setCheckTypeCast(this.typeCastCheckBox.isSelected());
        object.setTypeCastSource((String)this.typeCastComboBox.getSelectedItem());
        boolean isAssignment = object.getTypeCastSource() != null && !"".equals(object.getTypeCastSource());
        object.setBound(isAssignment || this.boundCheckBox.isSelected());
        object.setAssertInUnitTest(this.assertCheckBox.isSelected());
        if (this.negativeRadioButton.isSelected()) {
            object.setType(2);
        } else if (this.optionalRadioButton.isSelected()) {
            object.setType(1);
        } else if (this.setRadioButton.isSelected()) {
            object.setType(3);
        } else {
            object.setType(0);
        }
        if (this.createRadioButton.isSelected()) {
            object.setModifier(2);
        } else if (this.destroyRadioButton.isSelected()) {
            object.setModifier(1);
        } else {
            object.setModifier(0);
        }
        object.setCurrentIcon(this.currentIcon.getText());
    }

    protected UMLStoryActivity getStoryActivity() {
        ASGElement incr = this.umlIncrement;
        if (incr instanceof UMLObject) {
            incr = ((UMLObject)incr).getFirstFromDiagrams();
        }
        if (incr instanceof UMLStoryPattern) {
            incr = ((UMLStoryPattern)incr).getRevStoryPattern();
        }
        if (incr instanceof UMLStoryActivity) {
            return (UMLStoryActivity)incr;
        }
        return null;
    }

    protected boolean checkConstraints() {
        boolean result = true;
        if (((String)this.objectNameCombo.getSelectedItem()).trim().length() == 0) {
            result = false;
            JOptionPane.showMessageDialog(this, "Please specify a name for the object!", "Object has no name", 0);
        }
        return result;
    }

    public void enableRadioButtons() {
        if (this.noConstraintRadioButton.isSelected()) {
            this.createRadioButton.setEnabled(true);
            this.destroyRadioButton.setEnabled(true);
            this.negativeRadioButton.setEnabled(true);
        } else if (this.negativeRadioButton.isSelected()) {
            this.createRadioButton.setEnabled(false);
            this.destroyRadioButton.setEnabled(false);
        } else if (this.setRadioButton.isSelected()) {
            this.createRadioButton.setEnabled(false);
            this.destroyRadioButton.setEnabled(true);
        } else if (this.optionalRadioButton.isSelected()) {
            this.createRadioButton.setEnabled(true);
            this.destroyRadioButton.setEnabled(true);
        }
        if (this.noneRadioButton.isSelected()) {
            this.negativeRadioButton.setEnabled(true);
            this.optionalRadioButton.setEnabled(true);
            this.setRadioButton.setEnabled(true);
        } else if (this.createRadioButton.isSelected()) {
            this.negativeRadioButton.setEnabled(false);
            this.optionalRadioButton.setEnabled(true);
            this.setRadioButton.setEnabled(false);
        } else if (this.destroyRadioButton.isSelected()) {
            this.negativeRadioButton.setEnabled(false);
            this.optionalRadioButton.setEnabled(true);
            this.setRadioButton.setEnabled(true);
        }
    }

    public UMLObject getObject() {
        return this.object;
    }

    public void setObject(UMLObject object) {
        if (this.object != object) {
            this.object = object;
        }
    }

    private class TypeModifierListener
    implements ActionListener {
        TypeModifierListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SDMObjectDialog.this.enableRadioButtons();
        }
    }

    private class TypeCastCheckBoxListener
    implements ActionListener {
        private boolean oldBoundCheckBoxValue;

        TypeCastCheckBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (SDMObjectDialog.this.typeCastCheckBox.isSelected()) {
                this.oldBoundCheckBoxValue = SDMObjectDialog.this.boundCheckBox.isSelected();
                SDMObjectDialog.this.boundCheckBox.setSelected(true);
                SDMObjectDialog.this.boundCheckBox.setEnabled(false);
            } else {
                SDMObjectDialog.this.typeCastComboBox.setSelectedItem("");
                SDMObjectDialog.this.boundCheckBox.setSelected(this.oldBoundCheckBoxValue);
                SDMObjectDialog.this.boundCheckBox.setEnabled(true);
            }
        }
    }

    private static class TypeListRenderer
    extends DefaultListCellRenderer {
        TypeListRenderer() {
        }

        public Component getListCellRendererComponent(JList arg0, Object arg1, int arg2, boolean arg3, boolean arg4) {
            UMLClass umlClass = (UMLClass)arg1;
            String text = umlClass.getName();
            if (umlClass.getDeclaredInClass() != null) {
                text = String.valueOf(text) + " (" + umlClass.getDeclaredInClass().getFullClassName() + ")";
            } else if (umlClass.getDeclaredInPackage() != null && UMLProject.get().getRootPackage() != umlClass.getDeclaredInPackage()) {
                text = String.valueOf(text) + " (" + umlClass.getDeclaredInPackage().getFullPackageName() + ")";
            }
            return super.getListCellRendererComponent((JList<?>)arg0, text, arg2, arg3, arg4);
        }
    }
}

