/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.tu_bs.coobra.LocalRepository;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.basic.FD;
import de.uni_paderborn.fujaba.coobra.FujabaChangeManager;
import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.uml.UMLBaseTypes;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLPackage;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class RepairProjectDialog
extends FujabaDialog
implements ActionListener {
    private static final transient Logger log;
    private final JButton jCallGC = new JButton("Call the garbage collector");
    private final JButton jRebuildFragments = new JButton("Rebuild fragments of all classes");
    private final JButton jRemoveMethods = new JButton("Remove all method with no result type");
    private final JButton jRemoveGenMethods = new JButton("Remove all generated methods");
    private final JButton jRemoveParentlessElements = new JButton("Remove all parentless elements");
    private final JButton jRemoveUnusedClasses = new JButton("Remove unused classes");
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.gui.RepairProjectDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public RepairProjectDialog(JFrame frame) {
        super(frame, "Repair Project Dialog -- ONLY FOR DEVELOPER", true);
        this.guiInit();
    }

    private final void guiInit() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.guiWorkPanel(), "Center");
        container.add((Component)this.guiPanelCloseHelp(), "South");
        this.jCallGC.addActionListener(this);
        this.jRebuildFragments.addActionListener(this);
        this.jRemoveMethods.addActionListener(this);
        this.jRemoveGenMethods.addActionListener(this);
        this.jRemoveParentlessElements.addActionListener(this);
        this.jRemoveUnusedClasses.addActionListener(this);
        this.pack();
    }

    private final JPanel guiWorkPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.jCallGC);
        panel.add(this.jRebuildFragments);
        panel.add(this.jRemoveMethods);
        panel.add(this.jRemoveGenMethods);
        panel.add(this.jRemoveParentlessElements);
        panel.add(this.jRemoveUnusedClasses);
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.jCallGC) {
            this.callGC();
        } else if (source == this.jRebuildFragments) {
            this.rebuildFragments();
        } else if (source == this.jRemoveMethods) {
            if (log.isInfoEnabled()) {
                log.info((Object)"remove all methods without result type and adjust the constructor...");
            }
            this.removeMethods(UMLProject.get().getRootPackage());
        } else if (source == this.jRemoveGenMethods) {
            if (log.isInfoEnabled()) {
                log.info((Object)"remove all generated methods...");
            }
            this.removeGenMethods(UMLProject.get().getRootPackage());
        } else if (source == this.jRemoveParentlessElements) {
            this.cleanUp(FujabaChangeManager.getVMRepository());
        } else if (source == this.jRemoveUnusedClasses) {
            this.removeUnusedClasses(UMLProject.get());
        } else if (log.isInfoEnabled()) {
            log.info((Object)e);
        }
    }

    private final void callGC() {
        System.out.print("call gc ...");
        System.gc();
        if (log.isInfoEnabled()) {
            log.info((Object)" - ok");
        }
    }

    private final void rebuildFragments() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Rebuild fragments for project.");
        }
    }

    private final void removeMethods(UMLPackage pack) {
        Iterator iter = pack.iteratorOfPackages();
        while (iter.hasNext()) {
            this.removeMethods((UMLPackage)iter.next());
        }
        iter = pack.iteratorOfDeclares();
        while (iter.hasNext()) {
            this.removeMethods((UMLClass)iter.next());
        }
    }

    private final void removeUnusedClasses(UMLProject project) {
        LocalRepository repo = project.getRepository();
        Iterator iter = repo.iteratorOfKnownObjects();
        HashSet<UMLClass> objects = new HashSet<UMLClass>();
        while (iter.hasNext()) {
            UMLClass clazz;
            Object obj = iter.next();
            if (!(obj instanceof UMLClass) || (clazz = (UMLClass)obj).getName() != null || clazz.getRevTypes() != null) continue;
            objects.add(clazz);
        }
        if (objects.size() > 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Found " + objects.size() + " unused classes."));
            }
            iter = objects.iterator();
            while (iter.hasNext()) {
                ((UMLClass)iter.next()).removeYou();
            }
            repo.compact();
        }
    }

    private final void removeMethods(UMLClass cls) {
        Iterator iter = cls.iteratorOfDeclares();
        while (iter.hasNext()) {
            this.removeMethods((UMLClass)iter.next());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("  check class " + cls.getFullClassName()));
        }
        String clsName = cls.getName();
        UMLBaseTypes retType = UMLProject.get().getFromBaseTypes("constructor");
        iter = cls.iteratorOfMethods();
        while (iter.hasNext()) {
            UMLMethod method = (UMLMethod)iter.next();
            System.out.print("    check method " + method.getFullMethodName());
            if (method.getResultType() == null) {
                if (clsName.equals(method.getName())) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)" - set result type to constructor");
                    }
                    method.setResultType(retType);
                    continue;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)" - remove method");
                }
                method.removeYou();
                continue;
            }
            if (!log.isInfoEnabled()) continue;
            log.info((Object)" - OK");
        }
    }

    public final void removeGenMethods(UMLPackage pack) {
        Iterator iter = pack.iteratorOfPackages();
        while (iter.hasNext()) {
            this.removeGenMethods((UMLPackage)iter.next());
        }
        iter = pack.iteratorOfDeclares();
        while (iter.hasNext()) {
            this.removeGenMethods((UMLClass)iter.next());
        }
    }

    private final void removeGenMethods(UMLClass cls) {
        Iterator iter = cls.iteratorOfDeclares();
        while (iter.hasNext()) {
            this.removeGenMethods((UMLClass)iter.next());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("  check " + FD.toString(cls)));
        }
        iter = cls.iteratorOfMethods();
        while (iter.hasNext()) {
            UMLMethod method = (UMLMethod)iter.next();
            System.out.print("    check " + FD.toString(method));
            if (method.isGenerated()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)" - remove method");
                }
                method.removeYou();
                continue;
            }
            if (!log.isInfoEnabled()) continue;
            log.info((Object)" - ok");
        }
    }

    private void cleanUp(LocalRepository repository) {
        Map.Entry entry;
        Iterator it;
        TreeMap objectCountByType = new TreeMap();
        TreeMap<String, Throwable> getParentFailures = new TreeMap<String, Throwable>();
        HashSet parentless = new HashSet();
        int total = 0;
        if (repository != null) {
            it = repository.iteratorOfKnownObjects();
            while (it.hasNext()) {
                Map.Entry obj = it.next();
                String className = obj.getClass().getName();
                this.count(objectCountByType, className);
                ++total;
                try {
                    if (((ASGElement)((Object)obj)).getParentElement() != null) continue;
                    if (!(obj instanceof UMLProject)) {
                        parentless.add(obj);
                    }
                    this.count(objectCountByType, "*" + className);
                }
                catch (Throwable e) {
                    getParentFailures.put(className, e);
                }
            }
        }
        it = getParentFailures.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            log.error(entry.getKey());
            ((Throwable)entry.getValue()).printStackTrace();
        }
        it = objectCountByType.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            String classname = (String)entry.getKey();
            if (classname.startsWith("*")) continue;
            Integer nullCount = (Integer)objectCountByType.get("*" + classname);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)(entry.getValue() + "\twhere\t" + (nullCount != null ? nullCount : 0) + "\tfloating\t" + classname));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(String.valueOf(total) + " total"));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Type\t attrs\t attrs in hierarchy\t methods");
        }
        it = UMLProject.get().getTypeList().iteratorOfTypes();
        while (it.hasNext()) {
            UMLClass cls;
            UMLType type = (UMLType)it.next();
            if (!(type instanceof UMLClass)) continue;
            UMLClass parent = cls = (UMLClass)type;
            int numAttrInHier = 0;
            while (parent != null) {
                numAttrInHier += parent.sizeOfAttrs();
                parent = parent.getSuperClass();
            }
            if (!log.isInfoEnabled()) continue;
            log.info((Object)(String.valueOf(cls.getFullClassName()) + "\t" + cls.sizeOfAttrs() + "\t" + numAttrInHier + "\t" + cls.sizeOfMethods()));
        }
        int choice = JOptionPane.showOptionDialog(this, "Delete " + parentless.size() + " floating objects?", "Repair", 0, 3, null, null, null);
        if (choice == 0) {
            Iterator it2 = parentless.iterator();
            while (it2.hasNext()) {
                ASGElement element = (ASGElement)it2.next();
                element.removeYou();
            }
        }
    }

    private void count(Map objectCountByType, String className) {
        Integer count = (Integer)objectCountByType.get(className);
        if (count == null) {
            count = new Integer(0);
        }
        objectCountByType.put(className, new Integer(count + 1));
    }
}

