/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.BasicPropertyEditor;
import de.uni_paderborn.fujaba.gui.PESelection;
import de.uni_paderborn.fujaba.gui.PETextField;
import de.uni_paderborn.fujaba.uml.UMLArray;
import de.uni_paderborn.fujaba.uml.UMLBaseTypes;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.uni_paderborn.fujaba.uml.UMLTypeList;
import java.util.Iterator;

public class PETypeSelection
extends PESelection {
    private PETextField typeName;
    private PETextField detailedTypeDescription;
    private String initialSelection;

    public PETypeSelection(BasicPropertyEditor parent, String initialSelection) {
        super(parent);
        this.getSource().setHeader("Types");
        this.typeName = new PETextField(this.parent, "Type Name");
        this.initialSelection = initialSelection;
    }

    private PETextField getDetailedTypeDescription() {
        if (this.detailedTypeDescription == null) {
            this.detailedTypeDescription = new PETextField(this.parent, "");
            this.detailedTypeDescription.setReadOnly(true);
        }
        return this.detailedTypeDescription;
    }

    public void setTypeName(String type) {
        this.typeName.setText(type);
    }

    protected boolean filter(UMLType type) {
        return true;
    }

    protected void fillSourceList() {
        UMLTypeList typeList;
        this.clearSource();
        ASGElement incr = this.getIncrement();
        if (incr instanceof UMLClass && (typeList = UMLProject.get().getTypeList()) != null) {
            Iterator types = typeList.sortedIteratorOfTypes();
            while (types.hasNext()) {
                UMLType umlType = (UMLType)types.next();
                if (umlType == null || !this.filter(umlType)) continue;
                this.addToSource((UMLIncrement)((Object)umlType));
                if (!umlType.getName().equals(this.initialSelection)) continue;
                this.setSourceSelectedIncr((UMLIncrement)((Object)umlType));
            }
        }
    }

    protected void fillDestList() {
    }

    public String getTypeName() {
        return this.typeName.getText();
    }

    protected void sourceSelectionChanged() {
        ASGElement incr = this.source.getSelectedIncrement();
        if (incr != null) {
            this.typeName.setText(incr.getText());
            PETextField tmpDescritionTextField = this.getDetailedTypeDescription();
            String detailedDescription = incr.getText();
            if (incr instanceof UMLClass) {
                detailedDescription = String.valueOf(detailedDescription) + " - UMLClass '" + ((UMLClass)incr).getTypeName() + "'";
            } else if (incr instanceof UMLBaseTypes) {
                detailedDescription = String.valueOf(detailedDescription) + " - UMLBaseType";
            } else if (incr instanceof UMLArray) {
                detailedDescription = String.valueOf(detailedDescription) + " - UMLArray of type '" + ((UMLArray)incr).getBaseTypeName() + "'";
            }
            tmpDescritionTextField.setText(detailedDescription);
            tmpDescritionTextField.setToolTipText("selected type: " + detailedDescription);
        }
    }

    protected void addComponents() {
        super.addComponents();
        this.add(this.getDetailedTypeDescription());
    }
}

