/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.PEItem;
import de.uni_paderborn.fujaba.gui.PEThrowsCancelActionListener;
import de.uni_paderborn.fujaba.gui.PEThrowsOKActionListener;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class PEThrowsDialog
extends JDialog {
    public static final int XSCREEN = 300;
    public static final int YSCREEN = 300;
    public JList myTypes;
    private UMLMethod method;

    public PEThrowsDialog() {
    }

    public PEThrowsDialog(JFrame frame, UMLMethod method, Enumeration listOfTypes) {
        this.setSize(300, 300);
        this.setResizable(false);
        this.setModal(true);
        this.setMethod(method);
        int[] selpos = new int[this.getMethod().sizeOfThrowsTypes()];
        int selarraypos = 0;
        int listpos = 0;
        Vector<ASGElement> tmpData = new Vector<ASGElement>();
        while (listOfTypes.hasMoreElements()) {
            PEItem item = (PEItem)listOfTypes.nextElement();
            String text = item.getText();
            ASGElement incr = item.getIncrement();
            if (text.indexOf("Exception") <= -1) continue;
            tmpData.add(incr);
            Iterator iter = this.getMethod().iteratorOfThrowsTypes();
            while (iter.hasNext()) {
                UMLType myType = (UMLType)iter.next();
                if (!myType.equals(incr)) continue;
                selpos[selarraypos] = listpos;
                ++selarraypos;
                break;
            }
            ++listpos;
        }
        if (tmpData.size() > 0) {
            this.myTypes = new JList<Object>(tmpData.toArray());
            this.myTypes.setSelectedIndices(selpos);
        } else {
            this.myTypes = null;
        }
        this.getContentPane().setSize(300, 300);
        this.getContentPane().add(this.createDialogPanel());
        this.centerDialog();
        this.setVisible(true);
    }

    public UMLMethod getMethod() {
        return this.method;
    }

    public UMLMethod setMethod(UMLMethod method) {
        if (this.method != method) {
            this.method = method;
        }
        return this.method;
    }

    protected JPanel createDialogPanel() {
        JPanel dialogPanel = new JPanel(new BorderLayout());
        dialogPanel.setSize(300, 300);
        dialogPanel.add((Component)this.createScreenFields(), "Center");
        dialogPanel.add((Component)this.createButtonPanel(), "South");
        return dialogPanel;
    }

    protected JPanel createScreenFields() {
        JPanel screenPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        screenPanel.setLayout(gridbag);
        screenPanel.setBorder(new TitledBorder("Select throws..."));
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 1;
        if (this.myTypes != null) {
            JScrollPane myPane = new JScrollPane(this.myTypes);
            gridbag.setConstraints(myPane, c);
            screenPanel.add(myPane);
        } else {
            Label tmpLabel1 = new Label("Sorry, no exception classes found.");
            gridbag.setConstraints(tmpLabel1, c);
            screenPanel.add(tmpLabel1);
        }
        return screenPanel;
    }

    protected JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.setSize(240, 50);
        JButton ok = new JButton("OK");
        ok.setSize(100, 30);
        ok.addActionListener(new PEThrowsOKActionListener(this));
        buttonPanel.add(ok);
        JButton cancel = new JButton("Cancel");
        cancel.setSize(100, 30);
        cancel.addActionListener(new PEThrowsCancelActionListener(this));
        buttonPanel.add(cancel);
        this.getRootPane().setDefaultButton(ok);
        return buttonPanel;
    }

    public void okPressed() {
        this.setVisible(false);
        if (this.myTypes != null) {
            this.getMethod().removeAllFromThrowsTypes();
            Object[] listElements = this.myTypes.getSelectedValues();
            int i = 0;
            while (i < listElements.length) {
                this.getMethod().addToThrowsTypes((UMLType)listElements[i]);
                ++i;
            }
        }
    }

    public void cancelPressed() {
        this.setVisible(false);
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        int y = (screenSize.height - size.height) / 2;
        int x = (screenSize.width - size.width) / 2;
        this.setLocation(x, y);
    }
}

