/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.gui.BasicPropertyEditor;
import de.uni_paderborn.fujaba.gui.PEBaseComponent;
import de.uni_paderborn.fujaba.gui.RadioButtonListener;
import java.awt.GridLayout;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class PERadioGroup
extends PEBaseComponent {
    private ButtonGroup group;
    private String[] radionames = null;

    public PERadioGroup(BasicPropertyEditor parent, String title, String[] names) {
        super(parent);
        this.setBorder(new TitledBorder(title));
        this.setLayout(new GridLayout(0, 1));
        this.radionames = new String[names.length];
        int i = 0;
        while (i < names.length) {
            this.radionames[i] = names[i];
            ++i;
        }
        this.addComponents();
    }

    public ButtonGroup getGroup() {
        return this.group;
    }

    public void setReadOnly(boolean b) {
    }

    public void addComponents() {
        if (this.parent == null || this.radionames == null) {
            return;
        }
        this.group = new ButtonGroup();
        int i = 0;
        while (i < this.radionames.length) {
            JRadioButton button = new JRadioButton(this.radionames[i]);
            this.group.add(button);
            if (i == 0) {
                button.setSelected(true);
            }
            this.add(button);
            button.addActionListener(new RadioButtonListener(this.parent, this.radionames[i]));
            ++i;
        }
    }

    public void setEnabled(boolean enabled) {
        Enumeration<AbstractButton> buttons = this.group.getElements();
        while (buttons.hasMoreElements()) {
            JRadioButton button = (JRadioButton)buttons.nextElement();
            button.setEnabled(enabled);
        }
    }

    public void setSelectedButtonIndex(int index) {
        Enumeration<AbstractButton> buttons = this.group.getElements();
        int i = 0;
        if (buttons != null) {
            JRadioButton button = null;
            while (buttons.hasMoreElements() && i <= index) {
                button = (JRadioButton)buttons.nextElement();
                ++i;
            }
            if (i == index + 1 && button != null) {
                button.setSelected(true);
            }
        }
    }

    public int getSelectedButtonIndex() {
        Enumeration<AbstractButton> buttons = this.group.getElements();
        int i = 0;
        if (buttons != null) {
            while (buttons.hasMoreElements()) {
                JRadioButton button = (JRadioButton)buttons.nextElement();
                if (button.isSelected()) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean isHorzResizable() {
        boolean resizable = false;
        Enumeration<AbstractButton> buttons = this.group.getElements();
        if (buttons != null) {
            AbstractButton button = null;
            while (buttons.hasMoreElements()) {
                button = buttons.nextElement();
                if (!(button instanceof PEBaseComponent) || !((PEBaseComponent)((Object)button)).isHorzResizable()) continue;
                resizable = true;
            }
        }
        return resizable;
    }

    public boolean isVertResizable() {
        boolean resizable = false;
        Enumeration<AbstractButton> buttons = this.group.getElements();
        if (buttons != null) {
            AbstractButton button = null;
            while (buttons.hasMoreElements()) {
                button = buttons.nextElement();
                if (!(button instanceof PEBaseComponent) || !((PEBaseComponent)((Object)button)).isVertResizable()) continue;
                resizable = true;
            }
        }
        return resizable;
    }
}

