/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.CMAFocusListener;
import de.uni_paderborn.fujaba.gui.PEButton;
import de.uni_paderborn.fujaba.gui.PECheck;
import de.uni_paderborn.fujaba.gui.PEColumn;
import de.uni_paderborn.fujaba.gui.PECombo;
import de.uni_paderborn.fujaba.gui.PEEditPanel;
import de.uni_paderborn.fujaba.gui.PEItem;
import de.uni_paderborn.fujaba.gui.PEListIncr;
import de.uni_paderborn.fujaba.gui.PEListbox;
import de.uni_paderborn.fujaba.gui.PEMethodSelection;
import de.uni_paderborn.fujaba.gui.PEParameters;
import de.uni_paderborn.fujaba.gui.PETextField;
import de.uni_paderborn.fujaba.gui.PEThrowsDialog;
import de.uni_paderborn.fujaba.gui.PropertyEditor;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.uni_paderborn.fujaba.uml.UMLTypeList;
import de.uni_paderborn.tools.util.MethodDeclaration;
import de.uni_paderborn.tools.util.TextUtil;
import de.upb.tools.fca.FLinkedList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PEMethod
extends PropertyEditor {
    private static final transient Logger log;
    JFrame frame = null;
    FLinkedList addMethods = new FLinkedList();
    FLinkedList delMethods = new FLinkedList();
    FLinkedList refClasses = new FLinkedList();
    PETextField propertyName;
    PECheck signalModifier;
    PECheck finalModifier;
    PECheck staticModifier;
    PECheck abstractModifier;
    PECheck synchronizedModifier;
    PECheck nativeModifier;
    PECombo visibilityChoice;
    PEMethodSelection selection;
    PECheck pointer = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.gui.PEMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public PEMethod(JFrame frame, String title, boolean modal) {
        super(frame);
        try {
            this.pack();
            this.frame = frame;
            this.setTitle("Method Editor");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initPE();
        this.addFocusListener(new CMAFocusListener(this.propertyName));
        this.propertyName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PEMethod.this.addButton_actionPerformed(e);
            }
        });
    }

    public PEMethod(JFrame frame) {
        this(frame, "", false);
    }

    public PEMethod(JFrame frame, boolean modal) {
        this(frame, "", modal);
    }

    public PEMethod(JFrame frame, String title) {
        this(frame, title, false);
    }

    public void setPropertyName(String name) {
        this.propertyName.setText(name);
    }

    public void setVisibilityChoice(int index) {
        this.visibilityChoice.setSelectedIndex(index);
    }

    public void setIncrement(ASGElement incr) {
        this.setReadOnly(this.isReadOnly());
        if (incr instanceof UMLMethod) {
            super.setIncrement(((UMLMethod)incr).getParent());
            this.selection.getDest().selectIncrement(incr);
        } else {
            super.setIncrement(incr);
        }
        if (this.getClassIncrement() != null) {
            this.propertyName.setReadOnly(this.isReadOnly());
            this.setTitle("Method Editor: " + this.getClassIncrement().getName());
        }
    }

    public void setSignalModifier(boolean b) {
        this.signalModifier.setSelected(b);
    }

    public void setFinalModifier(boolean b) {
        this.finalModifier.setSelected(b);
    }

    public void setStaticModifier(boolean b) {
        this.staticModifier.setSelected(b);
    }

    public void setAbstractModifier(boolean b) {
        this.abstractModifier.setSelected(b);
    }

    public void setSynchronizedModifier(boolean b) {
        this.synchronizedModifier.setSelected(b);
    }

    public void setNativeModifier(boolean b) {
        this.nativeModifier.setSelected(b);
    }

    protected void additionalProperties(PEEditPanel panel) {
        this.propertyName = new PETextField(this, "Method Name");
        this.signalModifier = new PECheck(this, "Signal Modifier", "Signal");
        this.finalModifier = new PECheck(this, "Final Modifier", "Method is final");
        this.staticModifier = new PECheck(this, "Static Modifier", "Method is static");
        this.abstractModifier = new PECheck(this, "Abstract Modifier", "Method is abstract");
        this.synchronizedModifier = new PECheck(this, "Synchronized Modifier", "Method is synchronized");
        this.nativeModifier = new PECheck(this, "Native Modifier", "Method is native");
        this.visibilityChoice = new PECombo(this, "visibility");
        this.selection = new PEMethodSelection(this);
        this.pointer = new PECheck(this, "Pointer", "result type is pointer");
        this.pointer.setSelected(this.isResultTypeIsPointer());
        this.selection.setSourceMouseListener(new SourceMouseListener(this.selection.getSource().getList()));
        this.selection.setDestMouseListener(new DestMouseListener(this.selection.getSource().getList()));
        this.propertyName.setText(this.getPropertyName());
        this.propertyName.setStatus("Enter the new name");
        this.visibilityChoice.add("- private");
        this.visibilityChoice.add("+ public");
        this.visibilityChoice.add("# protected");
        this.visibilityChoice.add("~ package");
        this.visibilityChoice.setSelectedIndex(1);
        this.visibilityChoice.setStatus("select the visibility of the method");
        PEColumn column = new PEColumn(this);
        column.add(this.propertyName);
        column.add(this.signalModifier);
        column.add(this.finalModifier);
        column.add(this.staticModifier);
        column.add(this.abstractModifier);
        column.add(this.synchronizedModifier);
        column.add(this.nativeModifier);
        column.add(this.visibilityChoice);
        column.add(this.pointer);
        column.add(this.selection);
        panel.add(column);
    }

    protected void unparse() {
        this.propertyName.setText(this.getPropertyName());
        this.propertyName.selectAll();
        this.selection.setIncrement(this.getIncrement());
    }

    protected void parse() {
        if (!this.isReadOnly()) {
            ASGElement incr = this.getIncrement();
            if (incr instanceof UMLClass) {
                UMLClass umlClass = (UMLClass)incr;
                UMLMethod method = null;
                Iterator iter = this.addMethods.iterator();
                while (iter.hasNext()) {
                    method = (UMLMethod)iter.next();
                    method.setParent(umlClass);
                }
                this.addMethods.clear();
                iter = this.delMethods.iterator();
                while (iter.hasNext()) {
                    method = (UMLMethod)iter.next();
                    method.removeYou();
                }
                this.delMethods.clear();
                iter = this.refClasses.iterator();
                while (iter.hasNext()) {
                    UMLClass refClass = (UMLClass)iter.next();
                    Iterator diags = umlClass.iteratorOfDiagrams();
                    if (diags == null) continue;
                    UMLDiagram diag = null;
                    while (diags.hasNext()) {
                        diag = (UMLDiagram)diags.next();
                        diag.addToElements(refClass);
                    }
                }
                this.refClasses.clear();
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Editor in ReadOnly mode.");
        }
    }

    protected void cancel() {
        this.addMethods.clear();
        this.delMethods.clear();
        this.setVisible(false);
        this.dispose();
    }

    protected String getPropertyName() {
        if (this.getClassIncrement() != null) {
            int count = 1;
            Iterator methodIter = this.getClassIncrement().iteratorOfMethods();
            while (methodIter.hasNext()) {
                ++count;
                methodIter.next();
            }
            return "m" + count;
        }
        return "New Method";
    }

    public void setResultTypeIsPointer(boolean isResultTypeIsPointer) {
        this.pointer.setSelected(isResultTypeIsPointer);
    }

    protected boolean isResultTypeIsPointer() {
        return false;
    }

    public PEMethodSelection getPEMethodSelection() {
        return this.selection;
    }

    public PETextField getPropertyNameTextField() {
        return this.propertyName;
    }

    public PECombo getVisibilityChoiceCombo() {
        return this.visibilityChoice;
    }

    public boolean buttonActionPerformed(String buttonIdentifier, ActionEvent e) {
        if (buttonIdentifier.equals("add")) {
            this.addButton_actionPerformed(e);
            return PEButton.caughtEvent;
        }
        if (buttonIdentifier.equals("remove")) {
            this.removeButton_actionPerformed(e);
            return PEButton.caughtEvent;
        }
        if (buttonIdentifier.equals("apply")) {
            this.modifyButton_actionPerformed(e);
            return PEButton.caughtEvent;
        }
        return PEButton.remainedUnbound;
    }

    void addButton_actionPerformed(ActionEvent e) {
        if (this.selection.getTypeName().length() > 0) {
            UMLMethod newMethod = new UMLMethod();
            boolean skipParsing = false;
            ASGElement selectedIncr = this.selection.getSourceSelectedIncr();
            if (selectedIncr != null && selectedIncr instanceof UMLType) {
                String typeName = ((UMLType)((Object)selectedIncr)).getName();
                if (typeName.equals("Constructor")) {
                    this.setPropertyName(this.getClassIncrement().getName());
                }
                if (typeName.equals("Initializer")) {
                    this.setPropertyName("");
                    this.setSignalModifier(false);
                    this.setFinalModifier(false);
                    this.setStaticModifier(true);
                    this.setVisibilityChoice(1);
                    this.setAbstractModifier(false);
                    this.setSynchronizedModifier(false);
                    this.setNativeModifier(false);
                    skipParsing = true;
                }
            }
            if (!skipParsing) {
                String declReturnType;
                MethodDeclaration decl = new MethodDeclaration(this.propertyName.getText());
                if (!decl.isValid()) {
                    JOptionPane.showMessageDialog(null, "Invalid method declaration");
                    return;
                }
                if ("Illegal parameter declaration".equals(decl.getMethodError())) {
                    JOptionPane.showMessageDialog(null, "Illegal parameter declaration.\n\nParameters will be ignored.");
                } else if ("Illegal return type declaration".equals(decl.getMethodError())) {
                    JOptionPane.showMessageDialog(null, "Illegal return type declaration.\n\nReturn type won't be changed.");
                } else if ("Illegal parameter and return type declaration".equals(decl.getMethodError())) {
                    JOptionPane.showMessageDialog(null, "Illegal parameter and return type declaration.\n\nParameters will be ignored,\nreturn type won't be changed");
                }
                newMethod.setName(decl.getName());
                newMethod.setSignal(this.signalModifier.isSelected());
                newMethod.setFinal(decl.isFinal() || this.finalModifier.isSelected());
                newMethod.setStatic(decl.isStatic() || this.staticModifier.isSelected());
                newMethod.setAbstract(decl.isAbstract() || this.abstractModifier.isSelected());
                newMethod.setSynchronized(decl.isSynchronized() || this.synchronizedModifier.isSelected());
                newMethod.setUmlNative(decl.isNative() || this.nativeModifier.isSelected());
                newMethod.setResultTypeIsPointer(this.pointer.isSelected());
                if (decl.isPublic()) {
                    this.visibilityChoice.setSelectedString("+ public");
                }
                if (decl.isPackage()) {
                    this.visibilityChoice.setSelectedString("~ package");
                }
                if (decl.isProtected()) {
                    this.visibilityChoice.setSelectedString("# protected");
                }
                if (decl.isPrivate()) {
                    this.visibilityChoice.setSelectedString("- private");
                }
                ASGElement incr = this.getIncrement();
                UMLClass umlClass = null;
                if (incr instanceof UMLClass) {
                    umlClass = (UMLClass)incr;
                }
                if (((declReturnType = decl.getReturnType()) == null || declReturnType.equals("")) && umlClass != null && umlClass.getName().equals(decl.getName())) {
                    declReturnType = "constructor";
                }
                String rType = TextUtil.makeFujabaSuitable(declReturnType);
                Enumeration enumeration = this.selection.getSourceList();
                while (enumeration.hasMoreElements()) {
                    String str = ((PEItem)enumeration.nextElement()).getText();
                    if (!str.equals(rType)) continue;
                    this.selection.setSourceSelectedIncr(this.selection.getSourceIncrementByName(rType));
                    break;
                }
                String[] param = decl.getParameters();
                String[] var = decl.getParameterVariables();
                int i = 0;
                while (i < param.length) {
                    if (var[i].length() == 0) {
                        var[i] = "p" + newMethod.sizeOfParam();
                    }
                    newMethod.addToParam(new UMLParam(var[i], TextUtil.makeFujabaSuitable(param[i])));
                    ++i;
                }
            } else {
                newMethod.setName(this.propertyName.getText());
                newMethod.setSignal(this.signalModifier.isSelected());
                newMethod.setFinal(this.finalModifier.isSelected());
                newMethod.setStatic(this.staticModifier.isSelected());
                newMethod.setAbstract(this.abstractModifier.isSelected());
                newMethod.setSynchronized(this.synchronizedModifier.isSelected());
                newMethod.setUmlNative(this.nativeModifier.isSelected());
                newMethod.setResultTypeIsPointer(this.pointer.isSelected());
            }
            skipParsing = false;
            ASGElement incr = null;
            PEListIncr listIncr = this.selection.getSource();
            if (listIncr != null) {
                incr = listIncr.getSelectedIncrement();
            }
            if (incr == null) {
                incr = this.selection.getSourceIncrementByName(this.selection.getTypeName());
            }
            if (incr == null) {
                UMLTypeList typelist = null;
                if (this.getIncrement() instanceof UMLClass) {
                    typelist = ((UMLClass)this.getIncrement()).getRevTypes();
                }
                UMLClass refClass = new UMLClass(this.selection.getTypeName(), UMLStereotypeManager.get().getFromStereotypes("reference"), typelist, null);
                newMethod.setResultType(refClass);
                this.refClasses.add(refClass);
            } else {
                newMethod.setResultType((UMLType)((Object)incr));
            }
            switch (this.visibilityChoice.getSelectedIndex()) {
                case 0: {
                    newMethod.setVisibility(0);
                    this.addMethods.add(newMethod);
                    break;
                }
                case 1: {
                    newMethod.setVisibility(1);
                    this.addMethods.add(newMethod);
                    break;
                }
                case 2: {
                    newMethod.setVisibility(2);
                    this.addMethods.add(newMethod);
                    break;
                }
                case 3: {
                    newMethod.setVisibility(3);
                    this.addMethods.add(newMethod);
                }
            }
            this.selection.addToDest(newMethod);
            this.setPropertyName("");
            this.propertyName.requestFocus();
        }
    }

    void removeButton_actionPerformed(ActionEvent e) {
        ASGElement incr = this.selection.getDestSelectedIncr();
        if (incr != null) {
            this.delMethods.add(incr);
            this.selection.removeFromDest(incr);
            this.addMethods.remove(incr);
        }
    }

    void modifyButton_actionPerformed(ActionEvent e) {
        ASGElement oldIncr = this.selection.getDestSelectedIncr();
        if (oldIncr != null && oldIncr instanceof UMLMethod && this.selection.getTypeName().length() > 0) {
            String declReturnType;
            UMLMethod curMethod = (UMLMethod)oldIncr;
            ASGElement incr = null;
            PEListIncr listIncr = this.selection.getSource();
            if (listIncr != null) {
                incr = listIncr.getSelectedIncrement();
            }
            if (incr == null) {
                incr = this.selection.getSourceIncrementByName(this.selection.getTypeName());
            }
            if (incr.getName().equals("Constructor") && !this.propertyName.getText().equals(this.getClassIncrement().getName())) {
                JOptionPane.showMessageDialog(null, "The returntype Constructor cannot be applied to this Method", "Wrong Type", 1);
                return;
            }
            MethodDeclaration decl = new MethodDeclaration(this.propertyName.getText());
            if (!decl.isValid()) {
                JOptionPane.showMessageDialog(null, "Invalid method declaration");
                return;
            }
            if ("Illegal parameter declaration".equals(decl.getMethodError())) {
                JOptionPane.showMessageDialog(null, "Illegal parameter declaration.\n\nParameters will be ignored.");
            } else if ("Illegal return type declaration".equals(decl.getMethodError())) {
                JOptionPane.showMessageDialog(null, "Illegal return type declaration.\n\nReturn type won't be changed.");
            } else if ("Illegal parameter and return type declaration".equals(decl.getMethodError())) {
                JOptionPane.showMessageDialog(null, "Illegal parameter and return type declaration.\n\nParameters will be ignored,\nreturn type won't be changed");
            }
            curMethod.setName(decl.getName());
            curMethod.setSignal(this.signalModifier.isSelected());
            curMethod.setFinal(decl.isFinal() || this.finalModifier.isSelected());
            curMethod.setStatic(decl.isStatic() || this.staticModifier.isSelected());
            curMethod.setAbstract(decl.isAbstract() || this.abstractModifier.isSelected());
            curMethod.setSynchronized(decl.isSynchronized() || this.synchronizedModifier.isSelected());
            curMethod.setUmlNative(decl.isNative() || this.nativeModifier.isSelected());
            curMethod.setResultTypeIsPointer(this.pointer.isSelected());
            if (decl.isPublic()) {
                this.visibilityChoice.setSelectedString("+ public");
            }
            if (decl.isPackage()) {
                this.visibilityChoice.setSelectedString("~ package");
            }
            if (decl.isProtected()) {
                this.visibilityChoice.setSelectedString("# protected");
            }
            if (decl.isPrivate()) {
                this.visibilityChoice.setSelectedString("- private");
            }
            ASGElement increment = this.getIncrement();
            UMLClass umlClass = null;
            if (increment instanceof UMLClass) {
                umlClass = (UMLClass)increment;
            }
            if (((declReturnType = decl.getReturnType()) == null || declReturnType.equals("")) && umlClass != null && umlClass.getName().equals(decl.getName())) {
                declReturnType = "constructor";
            }
            String rType = TextUtil.makeFujabaSuitable(declReturnType);
            Enumeration enumeration = this.selection.getSourceList();
            while (enumeration.hasMoreElements()) {
                String str = ((PEItem)enumeration.nextElement()).getText();
                if (!str.equals(rType)) continue;
                this.selection.setSourceSelectedIncr(this.selection.getSourceIncrementByName(rType));
                break;
            }
            String[] param = decl.getParameters();
            String[] var = decl.getParameterVariables();
            if (param.length != 0) {
                curMethod.removeAllFromParam();
            }
            int i = 0;
            while (i < param.length) {
                if (var[i].length() == 0) {
                    var[i] = "p" + curMethod.sizeOfParam();
                }
                curMethod.addToParam(new UMLParam(var[i], TextUtil.makeFujabaSuitable(param[i])));
                ++i;
            }
            curMethod.setResultType((UMLType)((Object)incr));
            curMethod.setVisibility(this.visibilityChoice.getSelectedIndex());
            this.selection.removeFromDest(curMethod);
            this.selection.addToDest(curMethod);
        }
    }

    void parametersButton_actionPerformed(ActionEvent e) {
        UMLMethod method = (UMLMethod)this.selection.getDestSelectedIncr();
        if (method != null) {
            PEParameters umlParameterEditor = new PEParameters(this.frame);
            umlParameterEditor.setIncrement(method, this.getIncrement());
            umlParameterEditor.setTypeList(this.selection.getSourceList());
            umlParameterEditor.showCentered();
            this.selection.removeFromDest(method);
            this.selection.addToDest(method);
        }
    }

    void throwsButton_actionPerformed(ActionEvent e) {
        UMLMethod method = (UMLMethod)this.selection.getDestSelectedIncr();
        if (method != null) {
            new PEThrowsDialog(this.frame, method, this.selection.getSourceList());
            this.selection.removeFromDest(method);
            this.selection.addToDest(method);
        }
    }

    private class SourceMouseListener
    implements MouseListener {
        PEListbox liste;

        SourceMouseListener(PEListbox list) {
            this.liste = list;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                ASGElement oldIncr = PEMethod.this.selection.getDestSelectedIncr();
                if (oldIncr != null && oldIncr instanceof UMLMethod) {
                    UMLMethod curMethod = (UMLMethod)oldIncr;
                    if (PEMethod.this.propertyName.getText().equals(curMethod.getName())) {
                        PEMethod.this.modifyButton_actionPerformed(null);
                    } else {
                        PEMethod.this.addButton_actionPerformed(null);
                    }
                } else {
                    PEMethod.this.addButton_actionPerformed(null);
                }
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    private class DestMouseListener
    implements MouseListener {
        PEListbox liste;

        DestMouseListener(PEListbox list) {
            this.liste = list;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                PEMethod.this.parametersButton_actionPerformed(null);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2 && SwingUtilities.isRightMouseButton(e)) {
                PEMethod.this.removeButton_actionPerformed(null);
            }
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

