/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.BasicPropertyEditor;
import de.uni_paderborn.fujaba.gui.CMAFocusListener;
import de.uni_paderborn.fujaba.gui.PEButton;
import de.uni_paderborn.fujaba.gui.PECheck;
import de.uni_paderborn.fujaba.gui.PEColumn;
import de.uni_paderborn.fujaba.gui.PEComboBox;
import de.uni_paderborn.fujaba.gui.PEEditPanel;
import de.uni_paderborn.fujaba.gui.PEListIncr;
import de.uni_paderborn.fujaba.gui.PERow;
import de.uni_paderborn.fujaba.gui.PETextField;
import de.uni_paderborn.fujaba.gui.PropertyEditor;
import de.uni_paderborn.fujaba.gui.SDMObjectDialog;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLFile;
import de.uni_paderborn.fujaba.uml.UMLGeneralization;
import de.uni_paderborn.fujaba.uml.UMLMethod;
import de.uni_paderborn.fujaba.uml.UMLPackage;
import de.uni_paderborn.fujaba.uml.UMLParam;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.uni_paderborn.fujaba.uml.UMLTypeList;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.uni_paderborn.tools.util.ClassDeclaration;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class PEClass
extends PropertyEditor {
    private static final transient Logger log;
    private PECheck staticModifier;
    private PECheck abstractModifier;
    private PETextField className;
    PEListIncr generalList;
    PEListIncr stereotypeList;
    PEListIncr basicStereotypeList;
    private PEButton resetGeneral;
    private PEButton resetBasic;
    private PEButton resetStereo;
    private PEComboBox packageName;
    private PETextField defaultIcon;
    private PEButton browseButton;
    private UMLTypeList typeList = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.gui.PEClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public PEClass(JFrame frame) {
        super(frame);
        this.setTitle("Class Editor");
        this.initPE();
        this.addFocusListener(new CMAFocusListener(this.className));
        this.className.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PEClass.this.buttonOK_actionPerformed(e);
            }
        });
    }

    protected String getPropertyName() {
        return "New Class";
    }

    public void setIncrement(ASGElement asgElement) {
        this.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.setReadOnly(this.isReadOnly());
        super.setIncrement(asgElement);
        this.className.setReadOnly(this.isReadOnly());
        if (asgElement instanceof UMLClass) {
            this.setTitle("Class Editor: " + ((UMLClass)asgElement).getName());
        }
        this.getFrame().setCursor(Cursor.getPredefinedCursor(0));
    }

    protected void unparse() {
        ASGElement asgElement = this.getIncrement();
        this.fillStereotypeList();
        TreeSet<String> packageNames = new TreeSet<String>();
        Iterator it = UMLProject.get().getTypeList().iteratorOfTypes();
        while (it.hasNext()) {
            FClass cls;
            FType type = (FType)it.next();
            this.packageName.removeAllItems();
            if (!(type instanceof FClass) || (cls = (FClass)type).getFDeclaredInPackage() == null) continue;
            String packageName = cls.getFDeclaredInPackage().getFullPackageName();
            packageNames.add(packageName);
        }
        it = packageNames.iterator();
        while (it.hasNext()) {
            String packageName = (String)it.next();
            this.packageName.add(packageName);
        }
        if (asgElement instanceof UMLClass) {
            UMLClass clazz = (UMLClass)asgElement;
            UMLClass outerClass = clazz.getDeclaredInClass();
            UMLPackage thePackage = null;
            if (outerClass != null) {
                this.className.setText(String.valueOf(outerClass.getName()) + "$" + clazz.getText());
                thePackage = outerClass.getDeclaredInPackage();
            } else {
                this.className.setText(clazz.getName());
                thePackage = clazz.getDeclaredInPackage();
            }
            if (thePackage != null) {
                this.packageName.setSelectedItem(thePackage.getFullPackageName());
            }
            this.staticModifier.setSelected(clazz.isStatic());
            this.abstractModifier.setSelected(clazz.isAbstract());
            this.fillTypeList();
            Enumeration superclasses = clazz.elementsOfRevSubclass();
            if (superclasses != null) {
                int count = 0;
                while (superclasses.hasMoreElements()) {
                    ++count;
                    superclasses.nextElement();
                }
                superclasses = clazz.elementsOfRevSubclass();
                ASGElement[] selectedClasses = new ASGElement[count];
                int i = 0;
                while (superclasses.hasMoreElements()) {
                    UMLGeneralization gen = (UMLGeneralization)superclasses.nextElement();
                    selectedClasses[i] = gen.getSuperclass();
                    ++i;
                }
                this.generalList.selectIncrements(selectedClasses);
            }
            this.selectStereotypes(clazz);
            this.defaultIcon.setText(clazz.getDefaultIcon());
        } else if (asgElement instanceof UMLDiagram) {
            this.fillTypeList();
        }
    }

    private void parsePackage(UMLClass clazz) {
        String tmpPackageName = (String)this.packageName.getSelectedItem();
        if (tmpPackageName == null || tmpPackageName.length() == 0) {
            clazz.setDeclaredInPackage(UMLProject.get().getDefaultPackage());
        } else {
            UMLPackage tmpPackage = UMLProject.get().getNewFromPackages(tmpPackageName);
            if (clazz.getDeclaredInPackage() != tmpPackage) {
                clazz.setDeclaredInPackage(tmpPackage);
            }
        }
    }

    private void parseStatic(UMLClass clazz) {
        clazz.setStatic(this.staticModifier.isSelected());
    }

    private void parseAbstract(UMLClass clazz) {
        clazz.setAbstract(this.abstractModifier.isSelected());
    }

    private void parseStereotypes(UMLClass clazz) {
        if (clazz != null) {
            UMLStereotype selectedStereotype;
            clazz.removeAllFromStereotypes();
            int[] indices = this.basicStereotypeList.getSelectedIndices();
            int i = 0;
            while (i < indices.length) {
                selectedStereotype = (UMLStereotype)this.basicStereotypeList.getItemByIndex(indices[i]).getIncrement();
                clazz.addToStereotypes(selectedStereotype);
                ++i;
            }
            indices = this.stereotypeList.getSelectedIndices();
            i = 0;
            while (i < indices.length) {
                selectedStereotype = (UMLStereotype)this.stereotypeList.getItemByIndex(indices[i]).getIncrement();
                clazz.addToStereotypes(selectedStereotype);
                ++i;
            }
        }
    }

    private void parseGeneralisation(UMLClass clazz) {
        UMLGeneralization gen = null;
        Enumeration enumeration = clazz.elementsOfRevSubclass();
        while (enumeration.hasMoreElements()) {
            gen = (UMLGeneralization)enumeration.nextElement();
            if (this.generalList.isIncrementSelected(gen.getSuperclass())) continue;
            gen.removeYou();
        }
        UMLClass selectedClass = null;
        boolean genExists = false;
        int[] indices = this.generalList.getSelectedIndices();
        int i = 0;
        while (i < indices.length) {
            UMLDiagram item;
            selectedClass = (UMLClass)this.generalList.getItemByIndex(indices[i]).getIncrement();
            Enumeration genList = selectedClass.elementsOfRevSuperclass();
            genExists = false;
            while (genList.hasMoreElements() && !genExists) {
                gen = (UMLGeneralization)genList.nextElement();
                if (gen.getSubclass() != clazz) continue;
                genExists = true;
            }
            if (!genExists) {
                gen = new UMLGeneralization("test", null, clazz, selectedClass);
            }
            if (((item = UMLProject.get().getCurrentUMLDiagram()) != null && item instanceof UMLClassDiagram || item instanceof ViewDiagram && ((ViewDiagram)item).getOriginalDiagram() instanceof UMLClassDiagram) && item.hasInElements(clazz) && item.hasInElements(selectedClass) && !item.hasInElements(gen)) {
                item.addToElements(gen);
            }
            Iterator diagrams = UMLProject.get().iteratorOfDiags();
            while (diagrams.hasNext()) {
                ASGDiagram tmpItem = (ASGDiagram)diagrams.next();
                if (!(tmpItem instanceof UMLDiagram) || !(item = (UMLDiagram)tmpItem).hasInElements(clazz) || !item.hasInElements(selectedClass) || item.hasInElements(gen)) continue;
                item.addToElements(gen);
            }
            ++i;
        }
    }

    protected void parse() throws BasicPropertyEditor.ParseException {
        Object pkg;
        String fullClassName;
        if (this.className.getText().length() == 0) {
            JOptionPane.showMessageDialog(this.getFrame(), "You entered no name for the class!", "Class Editor", 0);
            throw new BasicPropertyEditor.ParseException("no class name");
        }
        UMLFile myFile = null;
        UMLClass clazz = null;
        UMLStereotype referenceType = UMLStereotypeManager.get().getFromStereotypes("reference");
        ASGElement asgElement = this.getIncrement();
        if (asgElement instanceof UMLClass) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("------class:" + asgElement.getName()));
            }
            clazz = (UMLClass)asgElement;
        }
        String string = fullClassName = (pkg = this.packageName.getSelectedItem()) == null || "".equals(pkg) ? this.className.getText() : pkg + "." + this.className.getText();
        if ((clazz == null || !fullClassName.equals(clazz.getFullClassName())) && UMLProject.get().hasInClasses(fullClassName)) {
            JOptionPane.showMessageDialog(this.getFrame(), "Please enter a unique name for the class!", "Class Editor", 0);
            throw new BasicPropertyEditor.ParseException("class name not unique");
        }
        if (asgElement instanceof UMLDiagram) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("------diagram:" + asgElement.getName()));
            }
            clazz = new UMLClass(this.className.getText(), null, this.typeList, null);
        }
        if (clazz != null) {
            UMLDiagram diag;
            clazz.setName(this.className.getText());
            UMLClass parentClass = clazz.getDeclaredInClass();
            this.parsePackage(parentClass == null ? clazz : parentClass);
            this.parseStereotypes(clazz);
            myFile = clazz.getFile();
            if (clazz.hasInStereotypes(referenceType)) {
                clazz.setDeclaredInReferences(UMLProject.get());
                clazz.setFile(null);
                if (myFile != null) {
                    myFile.removeYou();
                }
            } else {
                clazz.setDeclaredInReferences(null);
                if (myFile == null) {
                    myFile = new UMLFile(clazz);
                }
            }
            if ((diag = UMLProject.get().getCurrentUMLDiagram()) instanceof UMLClassDiagram) {
                diag.addToElements(clazz);
            }
            this.parseStatic(clazz);
            this.parseAbstract(clazz);
            this.parseGeneralisation(clazz);
            clazz.setDefaultIcon(this.defaultIcon.getText());
        }
    }

    protected void cancel() {
    }

    private void selectStereotypes(UMLClass clazz) {
        int size;
        if (clazz != null && (size = clazz.sizeOfStereotypes()) != 0) {
            Iterator it = clazz.iteratorOfStereotypes();
            ASGElement[] selectedStereotypes = new ASGElement[size];
            int i = 0;
            while (i < size) {
                selectedStereotypes[i] = (ASGElement)it.next();
                ++i;
            }
            this.basicStereotypeList.selectIncrements(selectedStereotypes);
            this.stereotypeList.selectIncrements(selectedStereotypes);
        }
    }

    private void fillStereotypeList() {
        this.basicStereotypeList.removeAll();
        this.stereotypeList.removeAll();
        TreeMap<String, UMLStereotype> basicTypes = new TreeMap<String, UMLStereotype>();
        TreeMap<String, UMLStereotype> stereoTypes = new TreeMap<String, UMLStereotype>();
        Iterator iter = UMLStereotypeManager.get().iteratorOfBasicStereotypes();
        while (iter.hasNext()) {
            UMLStereotype stereotype = (UMLStereotype)iter.next();
            basicTypes.put(stereotype.getText(), stereotype);
        }
        iter = UMLStereotypeManager.get().iteratorOfStereotypes();
        while (iter.hasNext()) {
            UMLStereotype type = (UMLStereotype)iter.next();
            if (basicTypes.containsValue(type)) continue;
            stereoTypes.put(type.getText(), type);
        }
        iter = basicTypes.keySet().iterator();
        while (iter.hasNext()) {
            this.basicStereotypeList.add((ASGElement)basicTypes.get(iter.next()));
        }
        iter = stereoTypes.keySet().iterator();
        while (iter.hasNext()) {
            this.stereotypeList.add((ASGElement)stereoTypes.get(iter.next()));
        }
    }

    private void fillTypeList() {
        UMLType type = null;
        this.typeList = UMLProject.get().getTypeList();
        Iterator list = this.typeList.sortedIteratorOfTypes();
        this.generalList.removeAll();
        while (list.hasNext()) {
            type = (UMLType)list.next();
            if (!(type instanceof UMLClass) || (UMLClass)type == this.getClassIncrement()) continue;
            this.generalList.add((ASGElement)((Object)type));
        }
    }

    protected void additionalProperties(PEEditPanel panel) {
        this.className = new PETextField(this, "Class name", "NewClass");
        this.className.setStatus("Enter the new class name");
        this.className.selectAll();
        this.staticModifier = new PECheck(this, "Static modifier", "Class is static");
        this.abstractModifier = new PECheck(this, "Abstract modifier", "Class is abstract");
        this.generalList = new PEListIncr(this, "Derived from");
        this.generalList.setStatus("Select all generalized classes");
        this.generalList.setSingleSelection(false);
        this.resetGeneral = new PEButton(this, "reset selection");
        this.resetGeneral.addActionListener(this.createResetGeneralizationListener());
        this.basicStereotypeList = new PEListIncr(this, "UML stereotypes");
        this.basicStereotypeList.setStatus("Select UML stereotypes");
        this.basicStereotypeList.setSingleSelection(false);
        this.resetBasic = new PEButton(this, "reset selection");
        this.resetBasic.addActionListener(this.createResetBasicStereotypesListener());
        this.stereotypeList = new PEListIncr(this, "User defined stereotypes");
        this.stereotypeList.setStatus("Select user defined stereotypes");
        this.stereotypeList.setSingleSelection(false);
        this.resetStereo = new PEButton(this, "reset selection");
        this.resetStereo.addActionListener(this.createResetStereotypesListener());
        this.packageName = new PEComboBox();
        this.packageName.setEditable(true);
        this.packageName.setPreferredSize(new Dimension(300, (int)this.packageName.getPreferredSize().getHeight()));
        SDMObjectDialog.enableCompletion(this.packageName);
        PEColumn leftFirst = new PEColumn(this);
        PEColumn rightFirst = new PEColumn(this);
        PEColumn generalColumn = new PEColumn(this);
        generalColumn.add(this.generalList);
        generalColumn.add(this.resetGeneral);
        PEColumn basicColumn = new PEColumn(this);
        basicColumn.add(this.basicStereotypeList);
        basicColumn.add(this.resetBasic);
        PEColumn stereoColumn = new PEColumn(this);
        stereoColumn.add(this.stereotypeList);
        stereoColumn.add(this.resetStereo);
        leftFirst.add(this.className);
        leftFirst.add(new JLabel("Package name"));
        leftFirst.add(this.packageName);
        leftFirst.add(this.staticModifier);
        leftFirst.add(this.abstractModifier);
        rightFirst.add(basicColumn);
        PERow firstRow = new PERow(this);
        firstRow.add(leftFirst);
        firstRow.add(rightFirst);
        panel.add(firstRow);
        PEColumn leftSnd = new PEColumn(this);
        PEColumn rightSnd = new PEColumn(this);
        leftSnd.add(generalColumn);
        rightSnd.add(stereoColumn);
        PERow sndRow = new PERow(this);
        sndRow.add(leftSnd);
        sndRow.add(rightSnd);
        panel.add(sndRow);
        PERow iconRow = new PERow(this);
        this.defaultIcon = new PETextField(this, "Default icon");
        iconRow.add(this.defaultIcon);
        this.browseButton = new PEButton(this, "Browse ...");
        this.browseButton.addActionListener(this.createBrowseListener());
        iconRow.add(this.browseButton);
        panel.add(iconRow);
    }

    public void buttonOK_actionPerformed(ActionEvent e) {
        ClassDeclaration decl = new ClassDeclaration(this.className.getText());
        if (!this.syntaxCheck(decl)) {
            return;
        }
        super.buttonOK_actionPerformed(e);
        Iterator iter = decl.getConstructors().iterator();
        while (iter.hasNext()) {
            Vector vector = (Vector)iter.next();
            ASGElement asgElement = this.getIncrement();
            if (asgElement instanceof UMLDiagram) {
                Iterator it = ((UMLDiagram)asgElement).iteratorOfElements();
                while (it.hasNext()) {
                    String name;
                    Object o = it.next();
                    if (!(o instanceof UMLClass) || !(name = ((UMLClass)o).getName()).equalsIgnoreCase(decl.getName())) continue;
                    UMLClass umlclass = (UMLClass)o;
                    UMLMethod method = new UMLMethod();
                    method.setName(umlclass.getName());
                    method.setResultType(UMLProject.get().getTypeList().getFromTypes("constructor"));
                    method.setVisibility(1);
                    int i = 0;
                    while (i < vector.size()) {
                        method.addToParam(new UMLParam((String)vector.get(i + 1), (String)vector.get(i)));
                        i += 2;
                    }
                    umlclass.addToMethods(method);
                }
                continue;
            }
            return;
        }
    }

    private boolean syntaxCheck(ClassDeclaration decl) {
        if (!decl.isValid()) {
            JOptionPane.showMessageDialog(null, decl.getClassError());
            return false;
        }
        if ("Illegal declaration of constructors".equals(decl.getClassError())) {
            JOptionPane.showMessageDialog(null, "Illegal declaration of constructors.\n\nNo constructor will be created.");
        }
        this.className.setText(decl.getName());
        this.staticModifier.setSelected(decl.isStatic() || this.staticModifier.isSelected());
        this.abstractModifier.setSelected(decl.isAbstract() || this.abstractModifier.isSelected());
        if (decl.getPackage().length() != 0) {
            this.packageName.setSelectedItem(decl.getPackage());
        }
        if ("Interfaces are not allowed to own constructors".equals(decl.getClassError())) {
            JOptionPane.showMessageDialog(null, "Interfaces are not allowed to own constructors.\n\nConstructor declaration will be ignored.");
            return false;
        }
        return true;
    }

    private ActionListener createResetGeneralizationListener() {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PEClass.this.generalList.clearSelection();
            }
        };
        return listener;
    }

    private ActionListener createResetBasicStereotypesListener() {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PEClass.this.basicStereotypeList.clearSelection();
            }
        };
        return listener;
    }

    private ActionListener createBrowseListener() {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PEClass.this.browse();
            }
        };
        return listener;
    }

    void browse() {
        JFileChooser jf = new JFileChooser(".");
        int opt = jf.showDialog(this, "Choose an icon");
        if (opt == 0) {
            this.defaultIcon.setText(jf.getSelectedFile().getPath());
        }
    }

    private ActionListener createResetStereotypesListener() {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PEClass.this.stereotypeList.clearSelection();
            }
        };
        return listener;
    }
}

