/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.PEColumn;
import de.uni_paderborn.fujaba.gui.PECombo;
import de.uni_paderborn.fujaba.gui.PEEditPanel;
import de.uni_paderborn.fujaba.gui.PEListEntry;
import de.uni_paderborn.fujaba.gui.PERolePanel;
import de.uni_paderborn.fujaba.gui.PETextField;
import de.uni_paderborn.fujaba.gui.PropertyEditor;
import de.uni_paderborn.fujaba.uml.UMLActivity;
import de.uni_paderborn.fujaba.uml.UMLActivityDiagram;
import de.uni_paderborn.fujaba.uml.UMLComplexState;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLNopActivity;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStartActivity;
import de.uni_paderborn.fujaba.uml.UMLStatementActivity;
import de.uni_paderborn.fujaba.uml.UMLStopActivity;
import de.uni_paderborn.fujaba.uml.UMLStoryActivity;
import de.uni_paderborn.fujaba.uml.UMLTransition;
import de.uni_paderborn.fujaba.uml.UMLTransitionGuard;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.JFrame;

public class PEActTransition
extends PropertyEditor {
    public static final String GuardNone = "None";
    public static final String GuardSuccess = "Success";
    public static final String GuardFailure = "Failure";
    public static final String GuardEachTime = "Each Time";
    public static final String GuardTermination = "End (for all)";
    public static final String GuardElse = "Else";
    public static final String GuardBooleanExpression = "Boolean Expression";
    public static final String GuardException = "Exception";
    public static final String[] Guards = new String[]{"None", "Success", "Failure", "Each Time", "End (for all)", "Else", "Boolean Expression", "Exception"};
    private ASGElement second;
    private PERolePanel rolePanel;
    private PECombo guardType;
    private PETextField expression;
    private PETextField eventTrigger;
    private PETextField action;

    public PEActTransition(JFrame frame) {
        super(frame);
        this.setTitle("Transition Editor");
        this.initPE();
    }

    protected void additionalProperties(PEEditPanel panel) {
        this.rolePanel = new PERolePanel();
        this.guardType = new PECombo(this, "Guard Type");
        this.guardType.addItemListener(new PEGuardListener(this));
        this.guardType.setStatus("Select the type of this guard");
        this.expression = new PETextField(this, "Boolean Expression / Exception");
        this.expression.setStatus("Enter a boolean expression or exception");
        this.eventTrigger = new PETextField(this, "Event trigger");
        this.eventTrigger.setStatus("Enter event trigger");
        this.action = new PETextField(this, "Action");
        this.action.setStatus("Enter the action");
        PEColumn column = new PEColumn(this);
        column.add(this.rolePanel);
        column.add(this.guardType);
        column.add(this.expression);
        UMLActivityDiagram curActDiag = (UMLActivityDiagram)UMLProject.get().getCurrentDiagram();
        if (curActDiag.getStartActivity() != null && curActDiag.getStartActivity().getRevStartOfStateChart() != null) {
            column.add(this.eventTrigger);
            column.add(this.action);
        }
        panel.add(column);
    }

    public void setIncrement(ASGElement asgElement, ASGElement addIncr) {
        this.second = addIncr;
        super.setIncrement(asgElement);
    }

    public String getPropertyName() {
        return "ActivityTransition";
    }

    private void fillRolePanel(UMLActivity sourceActivity, UMLActivity targetActivity, UMLDiagram diag) {
        PEActListEntry newEntry;
        boolean sourceActivityAdded = false;
        boolean targetActivityAdded = false;
        Iterator itemsIter = diag.iteratorOfElements();
        while (itemsIter.hasNext()) {
            ASGElement tmpItem = (ASGElement)itemsIter.next();
            if (!(tmpItem instanceof UMLActivity)) continue;
            UMLActivity tmpActivity = (UMLActivity)tmpItem;
            newEntry = new PEActListEntry(tmpActivity);
            if (!(tmpActivity instanceof UMLStartActivity)) {
                this.rolePanel.addItemToRightComboBox(newEntry);
            }
            if (!(tmpActivity instanceof UMLStopActivity)) {
                this.rolePanel.addItemToLeftComboBox(newEntry);
            }
            if (tmpActivity == sourceActivity) {
                this.rolePanel.setLeftComboSelectedItem(newEntry);
                sourceActivityAdded = true;
            }
            if (tmpActivity != targetActivity) continue;
            this.rolePanel.setRightComboSelectedItem(newEntry);
            targetActivityAdded = true;
        }
        if (!sourceActivityAdded && !(sourceActivity instanceof UMLStopActivity)) {
            newEntry = new PEActListEntry(sourceActivity);
            this.rolePanel.addItemToLeftComboBox(newEntry);
            this.rolePanel.setLeftComboSelectedItem(newEntry);
        }
        if (!(targetActivityAdded || targetActivity instanceof UMLStartActivity && ((UMLStartActivity)targetActivity).getHistoryKind() == 0)) {
            newEntry = new PEActListEntry(targetActivity);
            this.rolePanel.addItemToRightComboBox(newEntry);
            this.rolePanel.setRightComboSelectedItem(newEntry);
        }
    }

    protected void unparse() {
        if (this.getIncrement() != null) {
            int i = 0;
            while (i < Guards.length) {
                this.guardType.add(Guards[i]);
                ++i;
            }
            this.guardType.setSelectedIndex(0);
            this.expression.setReadOnly(true);
            ASGElement asgElement = this.getIncrement();
            if (asgElement instanceof UMLTransition) {
                UMLTransition transition = (UMLTransition)asgElement;
                this.fillRolePanel(transition.getRevExit(), transition.getRevEntry(), transition.getCurrentActiveDiagram());
                UMLTransitionGuard guard = transition.getGuard();
                if (guard != null) {
                    this.guardType.setSelectedIndex(guard.getType());
                    if (guard.getType() == 6 || guard.getType() == 7) {
                        this.expression.setText(guard.getBoolExpr());
                    }
                }
                this.eventTrigger.setText(transition.getEvent());
                this.action.setText(transition.getAction());
            } else if (asgElement instanceof UMLActivity && this.second != null && this.second instanceof UMLActivity) {
                UMLActivity srcAct = (UMLActivity)asgElement;
                UMLActivity tgtAct = (UMLActivity)this.second;
                this.fillRolePanel(srcAct, tgtAct, srcAct.getCurrentActiveDiagram());
            }
        }
    }

    protected void parse() {
        if (this.getIncrement() != null) {
            ASGElement asgElement = this.getIncrement();
            int guardTypeValue = this.guardType.getSelectedIndex();
            if (asgElement instanceof UMLTransition) {
                UMLActivity sourceAct = (UMLActivity)this.rolePanel.getLeftComboSelectedItem().getItem();
                UMLActivity targetAct = (UMLActivity)this.rolePanel.getRightComboSelectedItem().getItem();
                UMLTransition transition = (UMLTransition)asgElement;
                UMLActivity oldSourceAct = transition.getRevExit();
                UMLActivity oldTargetAct = transition.getRevEntry();
                if (oldSourceAct != sourceAct) {
                    transition.setRevExit(sourceAct);
                }
                if (oldTargetAct != targetAct) {
                    transition.setRevEntry(targetAct);
                }
                UMLTransitionGuard guard = transition.getGuard();
                if (guardTypeValue == 0) {
                    if (guard != null) {
                        guard.removeYou();
                        guard = null;
                    }
                } else {
                    if (guard == null) {
                        guard = new UMLTransitionGuard();
                        transition.setGuard(guard);
                    }
                    guard.setType(guardTypeValue);
                    if (guard.getType() == 6 || guard.getType() == 7) {
                        guard.setBoolExpr(this.expression.getText());
                    }
                }
                transition.setEvent(this.eventTrigger.getText());
                transition.setAction(this.action.getText());
            } else if (asgElement instanceof UMLActivity && this.second != null && this.second instanceof UMLActivity) {
                UMLTransitionGuard guard = new UMLTransitionGuard(guardTypeValue, null, null);
                if (guardTypeValue == 6) {
                    guard.setBoolExpr(this.expression.getText());
                }
                UMLActivity sourceAct = (UMLActivity)this.rolePanel.getLeftComboSelectedItem().getItem();
                UMLActivity targetAct = (UMLActivity)this.rolePanel.getRightComboSelectedItem().getItem();
                UMLTransition transition = new UMLTransition(sourceAct, targetAct, guard);
                UMLDiagram diag = (UMLDiagram)this.upperCommonDiagram(sourceAct, targetAct);
                transition.setEvent(this.eventTrigger.getText());
                transition.setAction(this.action.getText());
                diag.addToElements(transition);
            }
        }
    }

    private Object climbUp(Object object) {
        if (object == null) {
            return null;
        }
        object = object instanceof UMLStoryActivity ? ((UMLStoryActivity)object).getFirstFromDiagrams() : (object instanceof UMLStartActivity ? ((UMLStartActivity)object).getFirstFromDiagrams() : (object instanceof UMLStopActivity ? ((UMLStopActivity)object).getFirstFromDiagrams() : (object instanceof UMLNopActivity ? ((UMLNopActivity)object).getFirstFromDiagrams() : (object instanceof UMLStatementActivity ? ((UMLStatementActivity)object).getFirstFromDiagrams() : (object instanceof UMLComplexState ? ((UMLComplexState)object).getFirstFromDiagrams() : (object instanceof UMLActivityDiagram ? ((UMLActivityDiagram)object).getRevContains() : null))))));
        return object;
    }

    private int countActivityDepth(UMLActivity activity) {
        int depth = 0;
        Object object = activity;
        while (object != null) {
            object = this.climbUp(object);
            ++depth;
        }
        return depth;
    }

    private Object upperCommonDiagram(UMLActivity activity1, UMLActivity activity2) {
        int depth2;
        if (activity1.equals(activity2)) {
            return this.climbUp(activity1);
        }
        int depth1 = this.countActivityDepth(activity1);
        if (depth1 > (depth2 = this.countActivityDepth(activity2))) {
            UMLActivity tmpActivity = activity1;
            activity1 = activity2;
            activity2 = tmpActivity;
            int tmpDepth = depth1;
            depth1 = depth2;
            depth2 = tmpDepth;
        }
        Object object2 = activity2;
        while (depth1 < depth2) {
            object2 = this.climbUp(object2);
            --depth2;
        }
        Object object1 = activity1;
        while (object1 != object2) {
            if (object1 == null && object2 == null) {
                return activity1;
            }
            object1 = this.climbUp(object1);
            object2 = this.climbUp(object2);
        }
        if (object1 instanceof UMLComplexState) {
            object1 = ((UMLComplexState)object1).getFirstFromDiagrams();
        }
        return object1;
    }

    protected void cancel() {
    }

    public void selectionChanged() {
        this.expression.setReadOnly(!this.guardType.getSelectedItem().equals(GuardBooleanExpression) && !this.guardType.getSelectedItem().equals(GuardException));
    }

    private class PEGuardListener
    implements ItemListener {
        PEActTransition adaptor;

        PEGuardListener(PEActTransition adapter) {
            this.adaptor = adapter;
        }

        public void itemStateChanged(ItemEvent e) {
            this.adaptor.selectionChanged();
        }
    }

    private class PEActListEntry
    extends PEListEntry {
        public PEActListEntry(UMLActivity activity) {
            super(activity);
        }

        public String toString() {
            return ((UMLActivity)this.getItem()).getText();
        }
    }
}

