/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.uml.UMLAssoc;
import de.uni_paderborn.fujaba.uml.UMLRole;
import javax.swing.JComboBox;

public class KindComboBox
extends JComboBox {
    public static final String NORMAL = "--------------------";
    public static final String RIGHT_AGG = "------------------< >";
    public static final String LEFT_AGG = "< >------------------";
    public static final String RIGHT_COMP = "------------------<*>";
    public static final String LEFT_COMP = "<*>------------------";
    public static final String LEFT_REF = "<--------------------";
    public static final String RIGHT_REF = "-------------------->";

    public KindComboBox() {
        this.addItem(NORMAL);
        this.addItem(RIGHT_AGG);
        this.addItem(LEFT_AGG);
        this.addItem(RIGHT_COMP);
        this.addItem(LEFT_COMP);
        this.addItem(RIGHT_REF);
        this.addItem(LEFT_REF);
    }

    public void swapDirection() {
        int direction = this.getDirection();
        if (direction == 11) {
            this.adjustDirection(10);
        } else if (direction == 10) {
            this.adjustDirection(11);
        }
    }

    public void adjustDirection(int direction) {
        Object sel = this.getSelectedItem();
        if (direction == 11) {
            if (sel == LEFT_AGG) {
                this.setSelectedItem(RIGHT_AGG);
            } else if (sel == LEFT_COMP) {
                this.setSelectedItem(RIGHT_COMP);
            } else if (sel == LEFT_REF) {
                this.setSelectedItem(RIGHT_REF);
            }
        } else if (sel == RIGHT_AGG) {
            this.setSelectedItem(LEFT_AGG);
        } else if (sel == RIGHT_COMP) {
            this.setSelectedItem(LEFT_COMP);
        } else if (sel == RIGHT_REF) {
            this.setSelectedItem(LEFT_REF);
        }
    }

    public int getDirection() {
        Object sel = this.getSelectedItem();
        if (sel == RIGHT_AGG || sel == RIGHT_COMP || sel == RIGHT_REF) {
            return 11;
        }
        if (sel == LEFT_AGG || sel == LEFT_COMP || sel == LEFT_REF) {
            return 10;
        }
        return -1;
    }

    public String getSelected() {
        Object sel = this.getSelectedItem();
        return (String)sel;
    }

    public void unparse(UMLAssoc assoc, UMLRole leftRole, UMLRole rightRole) {
        if (leftRole != null && rightRole != null && assoc != null) {
            if (assoc.getDirection() == 10) {
                if (leftRole.getAdornment() == 1) {
                    this.setSelectedItem(LEFT_AGG);
                } else if (leftRole.getAdornment() == 2) {
                    this.setSelectedItem(LEFT_COMP);
                } else if (rightRole.getAdornment() == 3) {
                    this.setSelectedItem(RIGHT_REF);
                } else {
                    this.setSelectedItem(NORMAL);
                }
            } else if (rightRole.getAdornment() == 1) {
                this.setSelectedItem(RIGHT_AGG);
            } else if (rightRole.getAdornment() == 2) {
                this.setSelectedItem(RIGHT_COMP);
            } else if (leftRole.getAdornment() == 3) {
                this.setSelectedItem(LEFT_REF);
            } else {
                this.setSelectedItem(NORMAL);
            }
        } else {
            this.setSelectedItem(NORMAL);
        }
    }

    public void parse(UMLRole leftRole, UMLRole rightRole) {
        Object sel = this.getSelectedItem();
        if (sel == LEFT_AGG) {
            leftRole.setAdornment(1);
            rightRole.setAdornment(0);
        } else if (sel == LEFT_COMP) {
            leftRole.setAdornment(2);
            rightRole.setAdornment(0);
        } else if (sel == LEFT_REF) {
            leftRole.setAdornment(3);
            rightRole.setAdornment(0);
        } else if (sel == RIGHT_AGG) {
            leftRole.setAdornment(0);
            rightRole.setAdornment(1);
        } else if (sel == RIGHT_COMP) {
            leftRole.setAdornment(0);
            rightRole.setAdornment(2);
        } else if (sel == RIGHT_REF) {
            leftRole.setAdornment(0);
            rightRole.setAdornment(3);
        } else {
            leftRole.setAdornment(0);
            rightRole.setAdornment(0);
        }
    }
}

