/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.AbstractDialog;
import de.uni_paderborn.fujaba.gui.PathExpressionKeyListener;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLPath;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.upb.tools.sdm.Path;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class EditPathExprDialog
extends AbstractDialog {
    private static final transient Logger log;
    private JTextField pathExprField;
    private JTextField targetNameField;
    private JLabel startObjectLabel;
    private UMLObject object;
    private ASGElement elem;
    private JPanel panel;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.gui.EditPathExprDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public EditPathExprDialog(JFrame frame, ASGElement asgElem) {
        super(frame, false);
        this.elem = asgElem;
        this.createUserInterface();
        this.initialize();
    }

    protected JPanel createMainPanel() {
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        this.panel = new JPanel();
        this.panel.setBorder(new TitledBorder("Create Path Expression"));
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        JPanel pathExprPanel = new JPanel();
        pathExprPanel.setLayout(gridBag);
        JLabel startLabel = new JLabel("Start Object");
        this.startObjectLabel = new JLabel();
        constraints.insets = new Insets(6, 3, 0, 3);
        gridBag.setConstraints(startLabel, constraints);
        constraints.insets = new Insets(3, 3, 0, 3);
        gridBag.setConstraints(this.startObjectLabel, constraints);
        JLabel pathExprLabel = new JLabel("Path Expression");
        this.pathExprField = new JTextField(20);
        PathExpressionKeyListener pathExpressionKeyListener = new PathExpressionKeyListener(this);
        this.pathExprField.addKeyListener(pathExpressionKeyListener);
        this.getOkButton().setEnabled(false);
        constraints.insets = new Insets(6, 3, 0, 3);
        gridBag.setConstraints(pathExprLabel, constraints);
        constraints.insets = new Insets(3, 3, 0, 3);
        gridBag.setConstraints(this.pathExprField, constraints);
        JLabel targetNameLabel = new JLabel("Name of Target Set");
        this.targetNameField = new JTextField(20);
        constraints.insets = new Insets(6, 3, 0, 3);
        gridBag.setConstraints(targetNameLabel, constraints);
        constraints.insets = new Insets(3, 3, 0, 3);
        gridBag.setConstraints(this.targetNameField, constraints);
        pathExprPanel.add(startLabel);
        pathExprPanel.add(this.startObjectLabel);
        pathExprPanel.add(pathExprLabel);
        pathExprPanel.add(this.pathExprField);
        pathExprPanel.add(targetNameLabel);
        pathExprPanel.add(this.targetNameField);
        this.panel.add(pathExprPanel);
        return this.panel;
    }

    protected void unparse() {
        if (this.elem instanceof UMLPath) {
            this.panel.setBorder(new TitledBorder("Edit Path Expression"));
            UMLPath path = (UMLPath)this.elem;
            this.startObjectLabel.setText(path.getSource().getObjectName());
            this.pathExprField.setText(path.getExpression());
            this.targetNameField.setText(path.getTarget().getObjectName());
        } else if (this.elem instanceof UMLObject) {
            this.object = (UMLObject)this.elem;
            this.startObjectLabel.setText(this.object.getObjectName());
            if (log.isInfoEnabled()) {
                log.info((Object)("Object unparse else: " + this.object));
            }
        }
    }

    protected void parse() {
        String expr = this.pathExprField.getText();
        String targetName = this.targetNameField.getText();
        try {
            if (this.elem instanceof UMLObject) {
                UMLObject targetSet = new UMLObject();
                targetSet.setObjectName(targetName);
                targetSet.setType(3);
                UMLPath pathObject = new UMLPath(this.object, expr, targetSet);
                UMLDiagram diagram = this.object.getCurrentActiveDiagram();
                try {
                    diagram.addToElements(pathObject);
                    diagram.addToElements(targetSet);
                }
                catch (Exception e) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"diagram.addToItems does not work");
                    }
                    e.printStackTrace();
                }
            } else {
                UMLPath pathObject = (UMLPath)this.elem;
                pathObject.setExpression(expr);
                pathObject.getTarget().setObjectName(targetName);
            }
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                log.info((Object)"pathExpression could not be read");
            }
            e.printStackTrace();
        }
    }

    protected UMLClass getTargetClass(String e) {
        UMLClass targetClass = null;
        String[] stringArray = e.split("\\.");
        String classString = stringArray[stringArray.length - 1];
        String className = Path.upFirstChar(classString);
        Iterator iter = UMLProject.get().getTypeList().iteratorOfTypes();
        while (iter.hasNext()) {
            UMLType type = (UMLType)iter.next();
            if (!(type instanceof UMLClass) || className.compareTo(type.getName()) != 0) continue;
            targetClass = (UMLClass)type;
            break;
        }
        return targetClass;
    }
}

