/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.gui.ImportListCellRenderer;
import de.uni_paderborn.fujaba.gui.PackageTreeCellRenderer;
import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLFile;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLPackage;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class EditImportDialog
extends FujabaDialog {
    static final transient Logger log;
    JTree fullTree;
    JList fileImportList;
    private JComboBox fileBox;
    private DefaultMutableTreeNode rootNodeFullTree = new DefaultMutableTreeNode(UMLProject.get().getRootPackage());
    DefaultListModel importListModel = new DefaultListModel();
    DefaultTreeModel fullTreeModel;
    HashSet simAddHashSet = new HashSet();
    HashSet simRemoveHashSet = new HashSet();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.gui.EditImportDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public EditImportDialog(JFrame frame) {
        super(frame, "Import Editor", true);
        this.guiInit();
        this.unparse();
    }

    private final void guiInit() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.guiWorkPanel(), "Center");
        panel.add((Component)this.guiPanelOkCancelHelp(), "South");
        this.getContentPane().add(panel);
    }

    private final JPanel guiWorkPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel mainPanel = new JPanel(gridbag);
        JPanel addRemovePanel = new JPanel(new GridLayout(2, 1));
        JButton add = new JButton("->");
        JButton remove = new JButton("<-");
        addRemovePanel.add(add);
        addRemovePanel.add(remove);
        remove.addActionListener(new RemoveFromImportsListener());
        add.addActionListener(new AddToImportsListener());
        JPanel leftPanel = new JPanel(new BorderLayout());
        this.fullTreeModel = new DefaultTreeModel(this.rootNodeFullTree);
        this.fullTree = new JTree(this.fullTreeModel);
        this.fullTree.setCellRenderer(new PackageTreeCellRenderer());
        JPanel fullTreePanel = this.makeLabeledPanel("full tree", new JScrollPane(this.fullTree), 0);
        leftPanel.add((Component)fullTreePanel, "Center");
        JPanel leftButtonPanel = new JPanel();
        JButton importButton = new JButton("import");
        JButton newButton = new JButton("new");
        JButton removeButton = new JButton("remove");
        newButton.addActionListener(new NewActionListener(this));
        removeButton.addActionListener(new RemoveActionListener(this));
        importButton.addActionListener(new ImportActionListener());
        leftButtonPanel.add(importButton);
        leftButtonPanel.add(newButton);
        leftButtonPanel.add(removeButton);
        leftPanel.add((Component)leftButtonPanel, "South");
        JPanel rightPanel = new JPanel(new BorderLayout());
        JPanel rightComboPanel = new JPanel();
        this.fileBox = new JComboBox();
        this.fileBox.addItemListener(new FileBoxItemListener());
        rightComboPanel.add(this.fileBox);
        this.fileImportList = new JList(this.importListModel);
        this.fileImportList.setCellRenderer(new ImportListCellRenderer());
        rightPanel.add((Component)rightComboPanel, "South");
        rightPanel.add((Component)this.makeLabeledPanel("imports", new JScrollPane(this.fileImportList), 0), "Center");
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 4;
        c.fill = 1;
        gridbag.setConstraints(leftPanel, c);
        mainPanel.add(leftPanel);
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.fill = 2;
        gridbag.setConstraints(addRemovePanel, c);
        mainPanel.add(addRemovePanel);
        c.weighty = 1.0;
        c.gridwidth = 4;
        c.fill = 1;
        gridbag.setConstraints(rightPanel, c);
        mainPanel.add(rightPanel);
        return mainPanel;
    }

    public void setFile(UMLFile file) {
        if (file != null) {
            this.fileBox.setSelectedItem(file);
        }
    }

    private final void fillTree(DefaultMutableTreeNode root, UMLPackage pack) {
        Iterator iter = pack.iteratorOfDeclares();
        while (iter.hasNext()) {
            UMLClass clazz = (UMLClass)iter.next();
            root.add(new DefaultMutableTreeNode(clazz));
        }
        iter = pack.iteratorOfPackages();
        while (iter.hasNext()) {
            UMLPackage child = (UMLPackage)iter.next();
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(child);
            root.add(newNode);
            this.fillTree(newNode, child);
        }
    }

    public void unparse() {
        this.fillTree(this.rootNodeFullTree, UMLProject.get().getRootPackage());
        this.fullTree.expandRow(0);
        Iterator iter = UMLProject.get().iteratorOfFiles();
        while (iter.hasNext()) {
            UMLFile file = (UMLFile)iter.next();
            this.fileBox.addItem(file);
        }
    }

    public void parse() {
        UMLFile file = (UMLFile)this.fileBox.getSelectedItem();
        if (file != null) {
            Iterator addIter = this.simAddHashSet.iterator();
            while (addIter.hasNext()) {
                Object obj = addIter.next();
                if (obj instanceof UMLPackage) {
                    file.addToImportedPackages((UMLPackage)obj);
                }
                if (!(obj instanceof UMLClass)) continue;
                file.addToImportedClasses((UMLClass)obj);
            }
            Iterator removeIter = this.simRemoveHashSet.iterator();
            while (removeIter.hasNext()) {
                Object obj = removeIter.next();
                if (obj instanceof UMLPackage) {
                    file.removeFromImportedPackages((UMLPackage)obj);
                }
                if (!(obj instanceof UMLClass)) continue;
                file.removeFromImportedClasses((UMLClass)obj);
            }
        }
    }

    public DefaultMutableTreeNode findPlace(DefaultMutableTreeNode rootNode, String name) {
        int index = name.indexOf(46);
        if (index != -1) {
            String first = name.substring(0, index);
            String rest = name.substring(index + 1, name.length());
            Enumeration<TreeNode> packages = rootNode.children();
            while (packages.hasMoreElements()) {
                UMLPackage umlPack;
                DefaultMutableTreeNode pack = (DefaultMutableTreeNode)packages.nextElement();
                if (pack.getUserObject() instanceof UMLClass || !(umlPack = (UMLPackage)pack.getUserObject()).toString().equals(first)) continue;
                return this.findPlace(pack, rest);
            }
            UMLPackage newPackage = new UMLPackage();
            newPackage.setName(first);
            UMLPackage rootPackage = (UMLPackage)rootNode.getUserObject();
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(newPackage);
            rootNode.add(newNode);
            rootPackage.addToPackages(newPackage);
            return this.findPlace(newNode, rest);
        }
        return rootNode;
    }

    private String convertToNormalName(String name) {
        name = name.replace(File.separatorChar, '.');
        name = name.replace('/', '.');
        if ((name = name.replace('\\', '.')).endsWith(".class")) {
            name = name.substring(0, name.length() - 6);
        }
        if (name.endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public void addToTreeAndPackages(String name, boolean isClass) {
        if (name.indexOf("$") == -1) {
            name = this.convertToNormalName(name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding: " + name));
            }
            DefaultMutableTreeNode placeNode = this.findPlace(this.rootNodeFullTree, name);
            UMLPackage place = (UMLPackage)placeNode.getUserObject();
            name = name.substring(name.lastIndexOf(46) + 1, name.length());
            if (isClass) {
                if (!place.hasKeyInDeclares(name)) {
                    UMLClass newClass = new UMLClass(name);
                    UMLStereotype referenceType = UMLStereotypeManager.get().getFromStereotypes("reference");
                    newClass.setStereotype(referenceType, true);
                    place.addToDeclares(newClass);
                    placeNode.add(new DefaultMutableTreeNode(newClass));
                }
            } else if (!place.hasKeyInPackages(name)) {
                UMLPackage newPackage = new UMLPackage();
                newPackage.setName(name);
                place.addToPackages(newPackage);
                placeNode.add(new DefaultMutableTreeNode(newPackage));
            }
        }
    }

    private class FileBoxItemListener
    implements ItemListener {
        FileBoxItemListener() {
        }

        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                UMLFile file = (UMLFile)event.getItem();
                EditImportDialog.this.importListModel.clear();
                Iterator iter = file.iteratorOfImportedClasses();
                while (iter.hasNext()) {
                    UMLClass clazz = (UMLClass)iter.next();
                    EditImportDialog.this.importListModel.addElement(clazz);
                }
                iter = file.iteratorOfImportedPackages();
                while (iter.hasNext()) {
                    UMLPackage pack = (UMLPackage)iter.next();
                    EditImportDialog.this.importListModel.addElement(pack);
                }
                EditImportDialog.this.simAddHashSet.clear();
                EditImportDialog.this.simRemoveHashSet.clear();
            }
        }
    }

    private class AddToImportsListener
    implements ActionListener {
        AddToImportsListener() {
        }

        public void actionPerformed(ActionEvent event) {
            TreePath[] paths = EditImportDialog.this.fullTree.getSelectionPaths();
            if (paths != null) {
                int i = 0;
                while (i < paths.length) {
                    Object obj = null;
                    TreePath path = paths[i];
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node != null) {
                        obj = node.getUserObject();
                    }
                    if (obj != null) {
                        if (EditImportDialog.this.simRemoveHashSet.contains(obj)) {
                            EditImportDialog.this.simRemoveHashSet.remove(obj);
                        } else {
                            EditImportDialog.this.simAddHashSet.add(obj);
                        }
                        if (!EditImportDialog.this.importListModel.contains(obj)) {
                            EditImportDialog.this.importListModel.addElement(obj);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private class RemoveFromImportsListener
    implements ActionListener {
        RemoveFromImportsListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Object[] obj = EditImportDialog.this.fileImportList.getSelectedValues();
            if (obj != null) {
                int i = 0;
                while (i < obj.length) {
                    Object tmp = obj[i];
                    if (EditImportDialog.this.simAddHashSet.contains(tmp)) {
                        EditImportDialog.this.simAddHashSet.remove(tmp);
                    } else {
                        EditImportDialog.this.simRemoveHashSet.add(tmp);
                    }
                    EditImportDialog.this.importListModel.removeElement(tmp);
                    ++i;
                }
            }
        }
    }

    private class RemoveActionListener
    implements ActionListener {
        private Dialog dialog;

        public RemoveActionListener(Dialog aDialog) {
            this.dialog = aDialog;
        }

        public void removeAllSubPackages(UMLPackage remove) {
            Enumeration enumeration = remove.elementsOfAllChildren();
            while (enumeration.hasMoreElements()) {
                UMLIncrement incr = (UMLIncrement)enumeration.nextElement();
                EditImportDialog.this.importListModel.removeElement(incr);
                if (!(incr instanceof UMLPackage)) continue;
                this.removeAllSubPackages((UMLPackage)incr);
            }
        }

        public void actionPerformed(ActionEvent event) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)EditImportDialog.this.fullTree.getLastSelectedPathComponent();
            if (node != null) {
                int rc;
                UMLIncrement incr = (UMLIncrement)node.getUserObject();
                String name = null;
                if (incr instanceof UMLPackage) {
                    name = ((UMLPackage)incr).getFullPackageName();
                }
                if (incr instanceof UMLClass) {
                    name = ((UMLClass)incr).getFullClassName();
                }
                if ((rc = JOptionPane.showConfirmDialog(this.dialog, "Deleting this class/package may do harm to your project. Are you sure?", "Really delete " + name, 0, 2)) == 0) {
                    node.removeFromParent();
                    EditImportDialog.this.fullTreeModel.reload();
                    if (incr instanceof UMLPackage) {
                        this.removeAllSubPackages((UMLPackage)incr);
                    }
                    EditImportDialog.this.importListModel.removeElement(incr);
                    incr.removeYou();
                }
            }
        }
    }

    private class NewActionListener
    implements ActionListener {
        private Dialog dialog;

        public NewActionListener(Dialog aDialog) {
            this.dialog = aDialog;
        }

        public void actionPerformed(ActionEvent e) {
            NewDialog newDialog = new NewDialog(this.dialog);
            newDialog.showCentered();
        }
    }

    private class NewDialog
    extends FujabaDialog {
        private JTextField nameField;
        private JRadioButton packButton;
        private JRadioButton classButton;

        public NewDialog(Dialog dialog) {
            super(dialog, "New", true);
            this.guiInit();
            this.unparse();
        }

        private final void guiInit() {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)this.guiWorkPanel(), "Center");
            panel.add((Component)this.guiPanelOkCancelHelp(), "South");
            this.getContentPane().add(panel);
        }

        private final JPanel guiWorkPanel() {
            JPanel mainPanel = new JPanel(new GridLayout(2, 1));
            JPanel namePanel = new JPanel();
            JPanel groupPanel = new JPanel();
            JLabel nameLabel = new JLabel("Name:");
            this.nameField = new JTextField(30);
            namePanel.add(nameLabel);
            namePanel.add(this.nameField);
            this.packButton = new JRadioButton("Package");
            this.packButton.setSelected(true);
            this.classButton = new JRadioButton("Class");
            ButtonGroup group = new ButtonGroup();
            group.add(this.packButton);
            group.add(this.classButton);
            groupPanel.add(this.packButton);
            groupPanel.add(this.classButton);
            mainPanel.add(namePanel);
            mainPanel.add(groupPanel);
            return mainPanel;
        }

        public void unparse() {
        }

        public void parse() {
            EditImportDialog.this.addToTreeAndPackages(this.nameField.getText(), this.classButton.isSelected());
            EditImportDialog.this.fullTreeModel.reload();
        }
    }

    private class ImportActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            FrameMain frame = UMLProject.get().getGui();
            JFileChooser fileChooser = frame.getFileChooser();
            fileChooser.setFileFilter(frame.getFilterJarFiles());
            fileChooser.setFileSelectionMode(2);
            if (fileChooser.showOpenDialog(frame) == 0) {
                File file = fileChooser.getSelectedFile();
                if (file.isDirectory()) {
                    this.importDirectory(file.getAbsoluteFile().toString().lastIndexOf(File.separatorChar) + 1, file);
                } else {
                    this.importFile(file);
                }
                EditImportDialog.this.fullTreeModel.reload();
            }
        }

        private void importFile(File file) {
            block6: {
                String fileName = file.getName();
                String extension = "";
                if (fileName.lastIndexOf(46) != -1) {
                    extension = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
                }
                if (extension.equals("jar")) {
                    try {
                        JarFile jar = new JarFile(file);
                        Enumeration<JarEntry> entries = jar.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String name = entry.getName();
                            if (name.startsWith("META") || !name.endsWith(".class") && !entry.isDirectory()) continue;
                            if (entry.isDirectory()) {
                                EditImportDialog.this.addToTreeAndPackages(entry.getName(), false);
                                continue;
                            }
                            EditImportDialog.this.addToTreeAndPackages(entry.getName(), true);
                        }
                    }
                    catch (IOException e) {
                        if (!log.isInfoEnabled()) break block6;
                        log.info((Object)"Some problem occured while accessing the jar file");
                    }
                }
            }
        }

        private void importDirectory(int index, File file) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                File tmpFile = files[i];
                String fileName = tmpFile.getAbsoluteFile().toString();
                fileName = fileName.substring(index, fileName.length());
                if (!tmpFile.isDirectory()) {
                    if (fileName.endsWith(".class")) {
                        EditImportDialog.this.addToTreeAndPackages(fileName, true);
                    }
                } else if (!fileName.startsWith(".") && !tmpFile.getName().equals("CVS")) {
                    EditImportDialog.this.addToTreeAndPackages(fileName, false);
                    this.importDirectory(index, tmpFile);
                }
                ++i;
            }
        }
    }
}

