/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.gui.TextEditAction;
import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.uml.UMLCommentary;
import de.uni_paderborn.fujaba.uml.UMLProject;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class EditCommentDialog
extends FujabaDialog
implements TextEditAction.ClosableDialog,
ActionListener {
    JTextArea sourceEditor;
    JButton switchCommentVisibilityButton;
    JButton convertToTextButton;
    private UMLCommentary uMLCommentary;
    private boolean newUMLCommentaryCreated = false;

    public EditCommentDialog(JFrame frame) {
        super(frame, "Comment editor", true);
        this.guiInit();
    }

    public void guiInit() {
        JPanel mainPanel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        mainPanel.setLayout(gridBag);
        constraints.fill = 1;
        constraints.gridwidth = 0;
        constraints.anchor = 11;
        constraints.weightx = 1.0;
        JLabel commentLabel = new JLabel("Comment");
        constraints.insets = new Insets(0, 3, 0, 3);
        gridBag.setConstraints(commentLabel, constraints);
        mainPanel.add(commentLabel);
        this.sourceEditor = new JTextArea();
        this.sourceEditor.setToolTipText("Edit Comment");
        this.sourceEditor.setColumns(55);
        this.sourceEditor.setRows(25);
        JScrollPane scrollPane = new JScrollPane(this.sourceEditor);
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 3, 3, 3);
        gridBag.setConstraints(scrollPane, constraints);
        mainPanel.add(scrollPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        mainPanel.add(buttonPanel);
        constraints.weightx = 0.5;
        constraints.weighty = 0.0;
        JButton textEditButton = new JButton("Open in editor");
        textEditButton.addActionListener(new TextEditAction(this, this.sourceEditor));
        gridBag.setConstraints(textEditButton, constraints);
        buttonPanel.add(textEditButton);
        this.switchCommentVisibilityButton = new JButton("switch visibility");
        this.switchCommentVisibilityButton.setActionCommand("editor:switchVisibility");
        this.switchCommentVisibilityButton.addActionListener(this);
        this.switchCommentVisibilityButton.setToolTipText("show/hide the UML commentary in the current diagram");
        gridBag.setConstraints(this.switchCommentVisibilityButton, constraints);
        buttonPanel.add(this.switchCommentVisibilityButton);
        this.switchCommentVisibilityButton.setEnabled(false);
        this.convertToTextButton = new JButton("comment -> text");
        this.convertToTextButton.setActionCommand("editor:convertToText");
        this.convertToTextButton.addActionListener(this);
        this.convertToTextButton.setToolTipText("convert java-style-commented text to uncommented text");
        gridBag.setConstraints(this.convertToTextButton, constraints);
        buttonPanel.add(this.convertToTextButton);
        Container container = this.getContentPane();
        container.add((Component)mainPanel, "Center");
        JPanel panel = this.guiPanelOkCancelHelp();
        container.add((Component)panel, "South");
        this.pack();
    }

    public UMLCommentary getUMLCommentary() {
        return this.uMLCommentary;
    }

    public boolean isNewUMLCommentaryCreated() {
        return this.newUMLCommentaryCreated;
    }

    public void parse() {
        if (this.uMLCommentary == null) {
            this.uMLCommentary = new UMLCommentary();
            this.newUMLCommentaryCreated = true;
        }
        this.uMLCommentary.setText(this.sourceEditor.getText());
        UMLProject.get().refreshDisplay();
    }

    public void unparse(UMLCommentary value) {
        if (value == null) {
            this.uMLCommentary = new UMLCommentary();
            this.newUMLCommentaryCreated = true;
            this.switchCommentVisibilityButton.setEnabled(false);
        } else {
            this.uMLCommentary = value;
            this.switchCommentVisibilityButton.setEnabled(true);
        }
        String commentStr = this.uMLCommentary.getText();
        if (commentStr != null) {
            this.sourceEditor.setText(commentStr);
        }
    }

    public void hideWhileEditing() {
        this.hide();
    }

    public void okPressed() {
        super.actionOkButton();
    }

    public void actionCancelButton() {
        if (this.isNewUMLCommentaryCreated()) {
            this.uMLCommentary.removeYou();
            this.uMLCommentary = null;
        }
        super.actionCancelButton();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("editor:switchVisibility")) {
            if (this.uMLCommentary != null) {
                this.uMLCommentary.setVisible(!this.uMLCommentary.isVisible());
                UMLProject.get().refreshDisplay();
            }
        } else if (e.getActionCommand().equals("editor:convertToText") && this.uMLCommentary != null) {
            this.sourceEditor.setText(UMLCommentary.getUncommentedText(this.sourceEditor.getText()));
        }
    }
}

