/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.gui.CompletionKeyListener;
import de.uni_paderborn.fujaba.gui.MyCellRenderer;
import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.uml.UMLBaseTypes;
import de.uni_paderborn.fujaba.uml.UMLCollabStat;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStoryActivity;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.uni_paderborn.fujaba.uml.UMLTypeList;
import de.uni_paderborn.lib.basic.ImageResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditCollabStatDialog
extends FujabaDialog {
    private static final String nullObject = "\u00d8";
    JList collabStatList;
    private DefaultListModel collabStats = new DefaultListModel();
    JComboBox targetComboBox;
    private JComboBox sourceComboBox;
    private DefaultComboBoxModel targets = new DefaultComboBoxModel();
    private DefaultComboBoxModel sources = new DefaultComboBoxModel();
    JTextField callTextField;
    private JTextField loopVarNameField;
    private JTextField startValueField;
    private JTextField stopValueField;
    private JTextField ifCondTextField;
    private JTextField whileLoopTextField;
    private JTextField numberTextField;
    JTextField assignTargetField;
    private JComboBox assignTargetTypeField;
    private JCheckBox storyPatternBox;
    private JCheckBox sequenceBarBox;
    JCheckBox callOnElementsOfSetBox;
    private UMLIncrement incr;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(\\d+)([_a-zA-Z]\\w*)?");
    UMLCollabStat masterCollabStat;
    private UMLStoryPattern myPattern = null;

    public EditCollabStatDialog(JFrame frame) {
        super(frame, "Collaboration statements editor", true);
        this.guiInit();
    }

    public JComboBox getTargetComboBox() {
        return this.targetComboBox;
    }

    public void guiInit() {
        JPanel myPanel = new JPanel(new BorderLayout());
        JPanel collabStatListPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(myPanel);
        collabStatListPanel.setBorder(new TitledBorder("Select a collab. stat. to modify or delete"));
        this.collabStatList = new JList(this.collabStats);
        this.collabStatList.setVisibleRowCount(5);
        this.collabStats.addElement("[empty]");
        JScrollPane collabStatScrollPane = new JScrollPane(this.collabStatList);
        this.collabStatList.setPreferredSize(new Dimension(100, 500));
        this.collabStatList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                EditCollabStatDialog.this.fillFieldsFromCollabStat((UMLCollabStat)EditCollabStatDialog.this.collabStatList.getSelectedValue());
            }
        });
        collabStatListPanel.add((Component)collabStatScrollPane, "Center");
        myPanel.add((Component)collabStatListPanel, "North");
        JPanel sourceTargetPanel = new JPanel(new FlowLayout());
        JPanel sourceComboBoxPanel = new JPanel(new BorderLayout());
        sourceComboBoxPanel.setBorder(new TitledBorder("source"));
        this.sourceComboBox = new JComboBox(this.sources);
        this.sourceComboBox.setRenderer(new MyCellRenderer());
        sourceComboBoxPanel.add(this.sourceComboBox);
        sourceTargetPanel.add(sourceComboBoxPanel);
        ImageResourceManager imgManager = ImageResourceManager.get();
        ImageIcon arrowIcon = imgManager.getImageIcon("fujaba.core", "de/uni_paderborn/fujaba/app/images/arrowright.gif");
        JLabel arrowIconLabel = new JLabel(arrowIcon);
        sourceTargetPanel.add("Center", arrowIconLabel);
        JPanel targetComboBoxPanel = new JPanel(new BorderLayout());
        targetComboBoxPanel.setBorder(new TitledBorder("target"));
        this.targetComboBox = new JComboBox(this.targets);
        this.targetComboBox.setRenderer(new MyCellRenderer());
        this.targetComboBox.addActionListener(new CheckForSetActionListener(this));
        targetComboBoxPanel.add(this.targetComboBox);
        sourceTargetPanel.add(targetComboBoxPanel);
        myPanel.add(sourceTargetPanel);
        JPanel forPanel = new JPanel(new FlowLayout());
        forPanel.add(new JLabel("for "));
        this.loopVarNameField = new JTextField(2);
        forPanel.add(this.loopVarNameField);
        forPanel.add(new JLabel(" := "));
        this.startValueField = new JTextField(2);
        forPanel.add(this.startValueField);
        forPanel.add(new JLabel(" to "));
        this.stopValueField = new JTextField(2);
        forPanel.add(this.stopValueField);
        forPanel.add(new JLabel(" do ..."));
        JPanel ifPanel = new JPanel(new FlowLayout());
        ifPanel.add(new JLabel("if "));
        this.ifCondTextField = new JTextField(11);
        ifPanel.add(this.ifCondTextField);
        ifPanel.add(new JLabel(" then ..."));
        JPanel whilePanel = new JPanel(new FlowLayout());
        whilePanel.add(new JLabel("while "));
        this.whileLoopTextField = new JTextField(10);
        whilePanel.add(this.whileLoopTextField);
        whilePanel.add(new JLabel(" do ..."));
        JPanel numberThreadPanel = new JPanel(new FlowLayout());
        numberThreadPanel.setBorder(new TitledBorder("time flow"));
        this.numberTextField = new JTextField(10);
        numberThreadPanel.add(this.numberTextField);
        numberThreadPanel.add(new JLabel(" :"));
        JPanel forIfWhilePanel = new JPanel();
        forIfWhilePanel.setLayout(new BoxLayout(forIfWhilePanel, 1));
        forIfWhilePanel.setBorder(new TitledBorder("conditions / iterations"));
        forIfWhilePanel.add(forPanel);
        forIfWhilePanel.add(ifPanel);
        forIfWhilePanel.add(whilePanel);
        JPanel assignCallPanel = new JPanel(new FlowLayout());
        this.assignTargetField = new JTextField(7);
        this.assignTargetTypeField = new JComboBox<String>(new String[]{""});
        UMLTypeList typeList = UMLProject.get().getTypeList();
        if (typeList != null) {
            Iterator types = typeList.sortedIteratorOfTypes();
            while (types.hasNext()) {
                String name;
                UMLType umlType = (UMLType)types.next();
                if (!(umlType instanceof UMLBaseTypes) || "Initializer".equals(name = ((UMLBaseTypes)umlType).getName()) || "Void".equals(name) || "constructor".equals(name)) continue;
                this.assignTargetTypeField.addItem(umlType);
            }
        }
        assignCallPanel.add(new JLabel(" ... "));
        assignCallPanel.add(this.assignTargetTypeField);
        assignCallPanel.add(this.assignTargetField);
        assignCallPanel.add(new JLabel(" := "));
        this.callTextField = new JTextField(20);
        this.callTextField.addKeyListener(new CompletionKeyListener(null));
        assignCallPanel.add(this.callTextField);
        JPanel setModePanel = new JPanel(new FlowLayout());
        this.callOnElementsOfSetBox = new JCheckBox("Call on each element of the set");
        this.callOnElementsOfSetBox.setSelected(true);
        this.callOnElementsOfSetBox.setToolTipText("The call is performed on the elements of the set.");
        this.callOnElementsOfSetBox.addChangeListener(new AssignTargetFieldDisablerChangeListener(this));
        setModePanel.add(this.callOnElementsOfSetBox);
        JPanel assignCallSetmodePanel = new JPanel();
        assignCallSetmodePanel.setLayout(new BoxLayout(assignCallSetmodePanel, 1));
        assignCallSetmodePanel.setBorder(new TitledBorder("assign target and call text"));
        assignCallSetmodePanel.add(assignCallPanel);
        assignCallSetmodePanel.add(setModePanel);
        JPanel showTypePanel = new JPanel(new FlowLayout());
        showTypePanel.setBorder(new TitledBorder("show"));
        this.storyPatternBox = new JCheckBox("storypattern");
        this.sequenceBarBox = new JCheckBox("sequencebar");
        showTypePanel.add(this.storyPatternBox);
        showTypePanel.add(this.sequenceBarBox);
        this.storyPatternBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                EditCollabStatDialog.this.updateShowType();
            }
        });
        this.sequenceBarBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                EditCollabStatDialog.this.updateShowType();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton applyButton = new JButton("Apply");
        JButton newButton = new JButton("New");
        JButton removeButton = new JButton("Remove");
        applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    EditCollabStatDialog.this.writeFieldsToCollabStat((UMLCollabStat)EditCollabStatDialog.this.collabStatList.getSelectedValue());
                }
                catch (IllegalStateException ise) {
                    EditCollabStatDialog.this.showPropertyError();
                }
            }
        });
        newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditCollabStatDialog.this.makeNewCollabStat();
            }
        });
        removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditCollabStatDialog.this.removeCollabStat((UMLCollabStat)EditCollabStatDialog.this.collabStatList.getSelectedValue());
            }
        });
        buttonPanel.add(newButton);
        buttonPanel.add(applyButton);
        buttonPanel.add(removeButton);
        JPanel textFieldsPanel = new JPanel();
        textFieldsPanel.setLayout(new BoxLayout(textFieldsPanel, 1));
        myPanel.add("South", textFieldsPanel);
        textFieldsPanel.add(numberThreadPanel);
        textFieldsPanel.add(forIfWhilePanel);
        textFieldsPanel.add(assignCallSetmodePanel);
        textFieldsPanel.add(showTypePanel);
        textFieldsPanel.add(buttonPanel);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("Center", scrollPane);
        container.add("South", this.guiPanelCloseHelp());
        this.pack();
        this.collabStatList.setPreferredSize(this.collabStatList.getSize());
        this.collabStats.removeAllElements();
    }

    void updateShowType() {
        if (this.myPattern != null) {
            boolean showStoryPattern = this.storyPatternBox.isSelected();
            boolean showSequenceBar = this.sequenceBarBox.isSelected();
            if (showStoryPattern && showSequenceBar) {
                this.myPattern.setShowType(2);
            } else if (showStoryPattern) {
                this.myPattern.setShowType(0);
            } else if (showSequenceBar) {
                this.myPattern.setShowType(1);
            } else {
                this.myPattern.setShowType(0);
                this.storyPatternBox.setSelected(true);
            }
        }
    }

    void fillFieldsFromCollabStat(UMLCollabStat collabStat) {
        if (collabStat != null) {
            this.callTextField.setText(collabStat.getCallText());
            this.loopVarNameField.setText(collabStat.getLoopVarName());
            this.startValueField.setText(collabStat.getLoopStartVal());
            this.stopValueField.setText(collabStat.getLoopStopVal());
            this.ifCondTextField.setText(collabStat.getIfCondText());
            this.whileLoopTextField.setText(collabStat.getWhileLoopText());
            this.numberTextField.setText(String.valueOf(collabStat.getNoText()) + collabStat.getThreadId());
            this.assignTargetField.setText(collabStat.getAssignTgtText());
            this.assignTargetTypeField.setSelectedItem(collabStat.getAssignTgtType());
            this.callOnElementsOfSetBox.setSelected(collabStat.isCallOnElementsOfSet());
            UMLObject target = collabStat.getCallTarget();
            if (target != null) {
                this.targetComboBox.setSelectedItem(target);
            } else {
                this.targetComboBox.setSelectedItem(nullObject);
            }
            UMLObject source = collabStat.getCallSource();
            if (source != null) {
                this.sourceComboBox.setSelectedItem(source);
            } else {
                this.sourceComboBox.setSelectedItem("this");
            }
        }
    }

    void makeNewCollabStat() {
        UMLCollabStat collabStat = new UMLCollabStat();
        if (this.masterCollabStat == null) {
            this.masterCollabStat = new UMLCollabStat();
            this.masterCollabStat.setMyPattern(this.myPattern);
        }
        this.masterCollabStat.addFirstToSubStats(collabStat);
        try {
            this.writeFieldsToCollabStat(collabStat);
            this.clearFieldsAndUpdateListBox();
        }
        catch (IllegalStateException ise) {
            collabStat.removeYou();
            this.showPropertyError();
        }
    }

    void removeCollabStat(UMLCollabStat collabStat) {
        if (collabStat.sizeOfSubStats() == 0) {
            UMLCollabStat parent = collabStat.getFatherStat();
            collabStat.removeYou();
            while (parent != null && parent.sizeOfSubStats() == 0 && parent.sizeOfDiagrams() == 0) {
                UMLCollabStat tmp = parent;
                if ((parent = parent.getFatherStat()) == tmp) {
                    parent = null;
                }
                tmp.removeYou();
            }
            this.myPattern.renumberCollabStats();
            this.clearFieldsAndUpdateListBox();
        }
    }

    void parseNoText(UMLCollabStat collabStat, String noText) throws IllegalArgumentException, NumberFormatException {
        Matcher matcher;
        UMLCollabStat master;
        UMLCollabStat parent = master = collabStat.getRootFatherStat();
        String parentNoText = null;
        int lastDot = (noText = noText.trim()).lastIndexOf(46);
        if (lastDot > -1) {
            parentNoText = noText.substring(0, lastDot);
            noText = noText.substring(lastDot + 1);
        }
        if ((matcher = NUMBER_PATTERN.matcher(noText)).matches()) {
            int number = Integer.parseInt(matcher.group(1));
            String thread = matcher.group(2);
            collabStat.setNumber(number);
            if (thread != null && thread.length() > 0) {
                collabStat.setThreadId(thread);
            }
            if (parentNoText != null && (parent = master.findSubStat(parentNoText)) == null) {
                parent = master.createSubStat(parentNoText);
            }
        } else {
            throw new IllegalArgumentException("Malformed sequence path expression: " + noText);
        }
        parent.addFirstToSubStats(collabStat);
    }

    void writeFieldsToCollabStat(UMLCollabStat collabStat) throws IllegalStateException {
        if (collabStat != null) {
            boolean show;
            String noText = this.numberTextField.getText();
            if (noText.trim().length() == 0) {
                collabStat.setNumber(Integer.MAX_VALUE);
                collabStat.setThreadId(null);
                collabStat.setFatherStat(this.masterCollabStat);
            } else {
                String oldText = collabStat.getNoText();
                try {
                    this.parseNoText(collabStat, noText);
                }
                catch (IllegalArgumentException iae) {
                    try {
                        collabStat.setNoText(oldText);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.showNumberError(this.numberTextField.getText());
                }
            }
            collabStat.setCallText(this.callTextField.getText());
            collabStat.setLoopVarName(this.loopVarNameField.getText());
            collabStat.setLoopStartVal(this.startValueField.getText());
            collabStat.setLoopStopVal(this.stopValueField.getText());
            collabStat.setIfCondText(this.ifCondTextField.getText());
            collabStat.setWhileLoopText(this.whileLoopTextField.getText());
            collabStat.setAssignTgtText(this.assignTargetField.getText());
            Object type = this.assignTargetTypeField.getSelectedItem();
            boolean bl = show = collabStat.getCallText().trim().length() + collabStat.getAssignTgtText().trim().length() + collabStat.getLoopVarName().trim().length() + collabStat.getIfCondText().trim().length() + collabStat.getWhileLoopText().trim().length() > 0;
            if (type instanceof UMLType) {
                collabStat.setAssignTgtType((UMLType)type);
            } else {
                collabStat.setAssignTgtType(null);
            }
            if (this.callOnElementsOfSetBox.isEnabled()) {
                collabStat.setCallOnElementsOfSet(this.callOnElementsOfSetBox.isSelected());
            } else {
                collabStat.setCallOnElementsOfSet(false);
            }
            Object selectedItem = this.targetComboBox.getSelectedItem();
            if (selectedItem instanceof UMLObject) {
                collabStat.setCallTarget((UMLObject)selectedItem);
            } else {
                collabStat.setCallTarget(null);
            }
            selectedItem = this.sourceComboBox.getSelectedItem();
            if (selectedItem instanceof UMLObject) {
                collabStat.setCallSource((UMLObject)selectedItem);
            } else {
                collabStat.setCallSource(null);
            }
            if (!show && collabStat.sizeOfSubStats() == 0) {
                throw new IllegalStateException("Too few properties filled in");
            }
            if (collabStat.sizeOfDiagrams() == 0 && show) {
                this.myPattern.addToElements(collabStat);
            } else if (collabStat.sizeOfDiagrams() > 0 && !show) {
                collabStat.removeAllFromDiagrams();
            }
            this.myPattern.renumberCollabStats();
            this.clearFieldsAndUpdateListBox();
        }
    }

    private void showNumberError(String text) {
        JOptionPane.showMessageDialog(this, "Invalid Sequence Number: " + text, "Error: Invalid Parameter", 0);
    }

    void showPropertyError() {
        JOptionPane.showMessageDialog(this, "Too few parameters.\n\nPlease fill out at least the call text or one of the condition/iteration fields", "Error: Too few Parameters", 0);
    }

    private void clearFieldsAndUpdateListBox() {
        this.collabStats.clear();
        if (this.masterCollabStat != null) {
            this.myPattern.renumberCollabStats();
            this.collectCollabStats(this.masterCollabStat);
        }
        this.collabStatList.setModel(this.collabStats);
        this.callTextField.setText("");
        this.loopVarNameField.setText("");
        this.startValueField.setText("");
        this.stopValueField.setText("");
        this.ifCondTextField.setText("");
        this.whileLoopTextField.setText("");
        this.numberTextField.setText("");
        this.assignTargetField.setText("");
        this.assignTargetTypeField.setSelectedItem("");
        this.targetComboBox.setSelectedItem(nullObject);
    }

    public void setIncrement(UMLIncrement incr) {
        this.incr = incr;
        KeyListener callFieldListener = this.callTextField.getKeyListeners()[0];
        if (callFieldListener instanceof CompletionKeyListener) {
            ((CompletionKeyListener)callFieldListener).setContext(incr, false);
        }
        this.parse();
    }

    private void collectCollabStats(UMLCollabStat master) {
        if (master != null) {
            Enumeration enumeration = master.elementsOfSubStats();
            while (enumeration.hasMoreElements()) {
                UMLCollabStat aCollabStat = (UMLCollabStat)enumeration.nextElement();
                this.collabStats.addElement(aCollabStat);
                this.collectCollabStats(aCollabStat);
            }
        }
    }

    public void parse() {
        if (this.incr != null) {
            if (this.incr instanceof UMLCollabStat) {
                this.myPattern = ((UMLCollabStat)this.incr).findStoryPattern();
            } else if (this.incr instanceof UMLObject) {
                this.myPattern = (UMLStoryPattern)((UMLObject)this.incr).getFirstFromDiagrams();
            } else if (this.incr instanceof UMLStoryActivity) {
                this.myPattern = ((UMLStoryActivity)this.incr).getStoryPattern();
            }
            if (this.myPattern != null) {
                this.myPattern.renumberCollabStats();
                boolean showAllSources = this.myPattern.getType() == 1;
                this.masterCollabStat = this.myPattern.getRevMasterCollabStat();
                this.collectCollabStats(this.masterCollabStat);
                this.targets.addElement(nullObject);
                this.sources.addElement("this");
                Iterator objects = this.myPattern.iteratorOfObjects();
                Object obj = null;
                while (objects.hasNext()) {
                    obj = objects.next();
                    this.targets.addElement(obj);
                    if (!showAllSources) continue;
                    this.sources.addElement(obj);
                }
                if (this.incr instanceof UMLCollabStat) {
                    this.collabStatList.setSelectedValue(this.incr, true);
                    this.fillFieldsFromCollabStat((UMLCollabStat)this.incr);
                }
                switch (this.myPattern.getShowType()) {
                    case 0: {
                        this.storyPatternBox.setSelected(true);
                        this.sequenceBarBox.setSelected(false);
                        break;
                    }
                    case 1: {
                        this.storyPatternBox.setSelected(false);
                        this.sequenceBarBox.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.storyPatternBox.setSelected(true);
                        this.sequenceBarBox.setSelected(true);
                    }
                }
            }
        }
    }

    private static class AssignTargetFieldDisablerChangeListener
    implements ChangeListener {
        EditCollabStatDialog eCSDialog = null;

        public AssignTargetFieldDisablerChangeListener(EditCollabStatDialog editCollabStatDialog) {
            if (editCollabStatDialog != null) {
                this.eCSDialog = editCollabStatDialog;
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (this.eCSDialog != null) {
                this.eCSDialog.assignTargetField.setEnabled(true);
            }
        }
    }

    private static class CheckForSetActionListener
    implements ActionListener {
        EditCollabStatDialog eCSDialog = null;

        public CheckForSetActionListener(EditCollabStatDialog editCollabStatDialog) {
            if (editCollabStatDialog != null) {
                this.eCSDialog = editCollabStatDialog;
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this.eCSDialog != null && this.eCSDialog.targetComboBox.getSelectedItem() instanceof UMLObject) {
                UMLObject curObject = (UMLObject)this.eCSDialog.targetComboBox.getSelectedItem();
                if (curObject.getType() == 3 && curObject.getModifier() != 1) {
                    this.eCSDialog.callOnElementsOfSetBox.setEnabled(true);
                } else {
                    this.eCSDialog.callOnElementsOfSetBox.setEnabled(false);
                }
                CompletionKeyListener completionListener = (CompletionKeyListener)this.eCSDialog.callTextField.getKeyListeners()[0];
                completionListener.setContext(curObject, false);
            }
        }
    }
}

