/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.basic.Utility;
import de.uni_paderborn.fujaba.gui.KindComboBox;
import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.gui.comp.JglComboBoxModel;
import de.uni_paderborn.fujaba.gui.comp.VisibilityComboBox;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.uml.UMLArray;
import de.uni_paderborn.fujaba.uml.UMLAssoc;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.UMLCardinality;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLConstraint;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLQualifier;
import de.uni_paderborn.fujaba.uml.UMLRole;
import de.uni_paderborn.fujaba.uml.UMLStereotype;
import de.uni_paderborn.fujaba.uml.UMLStereotypeManager;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;

public class EditAssocDialog
extends FujabaDialog {
    private static final transient Logger log;
    JTextField textName = new JTextField();
    private JTextField textLeftRoleName = new JTextField();
    private JTextField textRightRoleName = new JTextField();
    private JTextField textLeftCardinality = new JTextField();
    private JTextField textRightCardinality = new JTextField();
    private JRadioButton radioLeftToRight = new JRadioButton("Left to right");
    private JCheckBox transientCheckBox = new JCheckBox("transient");
    private JRadioButton radioRightToLeft = new JRadioButton("Right to left");
    private VisibilityComboBox boxLeftVisibility = new VisibilityComboBox();
    private VisibilityComboBox boxRightVisibility = new VisibilityComboBox();
    JComboBox boxLeftClass = new JComboBox();
    JComboBox boxLeftQualifier = new JComboBox();
    JComboBox boxLeftQualifierAttrType = new JComboBox();
    KindComboBox boxKind = new KindComboBox();
    JComboBox boxRightClass = new JComboBox();
    JComboBox boxRightQualifier = new JComboBox();
    JComboBox boxRightQualifierType = new JComboBox();
    private JComboBox assocConstraints = new JComboBox();
    JTextField sortedComparator = new JTextField(10);
    JComboBox boxStereotype = new JComboBox();
    private UMLAssoc assoc = null;
    private UMLRole leftRole = null;
    private UMLRole rightRole = null;
    boolean leftQualifierEnabled;
    boolean rightQualifierEnabled;
    private transient TreeSet names = new TreeSet();
    boolean actionMode = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.gui.EditAssocDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public EditAssocDialog(JFrame frame, UMLAssoc assoc) {
        super(frame, "Association Editor - edit assoc", true);
        this.guiInit();
        this.assoc = assoc;
        this.leftRole = assoc.getLeftRole();
        this.rightRole = assoc.getRightRole();
        this.unparse(null, null);
        this.actionMode = true;
    }

    public EditAssocDialog(JFrame frame, UMLClass oneClass) {
        this(frame, oneClass, oneClass);
    }

    public EditAssocDialog(JFrame frame, UMLClass leftClass, UMLClass rightClass) {
        super(frame, "Association Editor - new assoc", true);
        this.guiInit();
        this.unparse(leftClass, rightClass);
        this.actionMode = true;
    }

    private final void guiInit() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.guiWorkPanel(), "Center");
        JPanel panel = this.guiPanelOkCancelHelp();
        container.add((Component)panel, "South");
        this.pack();
    }

    private final JPanel guiWorkPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel classPanel = new JPanel(new BorderLayout());
        classPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.add((Component)this.guiComboBoxBorder(this.boxLeftClass), "North");
        this.boxLeftClass.addActionListener(new BoxClassActionListener());
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        rightPanel.add((Component)this.guiComboBoxBorder(this.boxRightClass), "North");
        this.boxRightClass.addActionListener(new BoxClassActionListener());
        classPanel.add((Component)leftPanel, "West");
        classPanel.add((Component)rightPanel, "East");
        panel.add((Component)classPanel, "North");
        panel.add((Component)this.guiMiddle(), "Center");
        return panel;
    }

    private final JPanel guiMiddle() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panel.setLayout(gridbag);
        constraints.ipadx = 5;
        constraints.ipady = 5;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        panel.add(this.guiLeftPanel("LeftName", this.textLeftRoleName, constraints, gridbag));
        this.textLeftRoleName.addCaretListener(new TextRoleNameCaretListener());
        constraints.gridwidth = 2;
        constraints.anchor = 10;
        panel.add(this.guiCenterPanel("Assoc-Name", this.textName, constraints, gridbag));
        this.textName.addCaretListener(new TextNameCaretListener());
        constraints.gridwidth = 0;
        constraints.anchor = 13;
        panel.add(this.guiRightPanel("RightName", this.textRightRoleName, constraints, gridbag));
        this.textRightRoleName.addCaretListener(new TextRoleNameCaretListener());
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 2;
        panel.add(this.guiLeftPanel("Left Qualifier Name", this.boxLeftQualifier, constraints, gridbag));
        this.boxLeftQualifier.addActionListener(new BoxQualifierActionListener());
        constraints.gridwidth = -1;
        constraints.anchor = 10;
        panel.add(this.guiCenterPanel("Kind", this.boxKind, constraints, gridbag));
        this.boxKind.addActionListener(new BoxKindActionListener());
        constraints.gridwidth = 0;
        constraints.anchor = 13;
        panel.add(this.guiRightPanel("Right Qualifier Name", this.boxRightQualifier, constraints, gridbag));
        this.boxRightQualifier.addActionListener(new BoxQualifierActionListener());
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        panel.add(this.guiLeftPanel("Left Qualifer Type", this.boxLeftQualifierAttrType, constraints, gridbag));
        constraints.gridwidth = -1;
        constraints.anchor = 10;
        panel.add(this.guiCenterPanel("Constraints", this.assocConstraints, constraints, gridbag));
        constraints.gridwidth = 0;
        constraints.anchor = 13;
        panel.add(this.guiRightPanel("Right Qualifier Type", this.boxRightQualifierType, constraints, gridbag));
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        panel.add(this.guiLeftPanel("LeftCardinality", this.textLeftCardinality, constraints, gridbag));
        constraints.gridwidth = -1;
        constraints.anchor = 10;
        panel.add(this.guiCenterPanel("Comparator", this.sortedComparator, constraints, gridbag));
        constraints.gridwidth = 0;
        constraints.anchor = 13;
        panel.add(this.guiRightPanel("RightCardinality", this.textRightCardinality, constraints, gridbag));
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        panel.add(this.guiLeftPanel("LeftVisibility", this.boxLeftVisibility, constraints, gridbag));
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 2;
        constraints.anchor = 10;
        panel.add(this.guiCenterPanel(null, this.guiDirection(), constraints, gridbag));
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        panel.add(this.guiCenterPanel(null, this.transientCheckBox, constraints, gridbag));
        constraints.gridx = 3;
        constraints.gridwidth = 0;
        constraints.anchor = 13;
        panel.add(this.guiRightPanel("RightVisibility", this.boxRightVisibility, constraints, gridbag));
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        panel.add(this.guiLeftPanel("Stereotypes", this.boxStereotype, constraints, gridbag));
        return panel;
    }

    private final JPanel guiLeftPanel(String text, JComponent component, GridBagConstraints constraints, GridBagLayout gridbag) {
        JLabel label = new JLabel(text);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        label.setAlignmentX(0.0f);
        panel.add(label);
        component.setAlignmentX(0.0f);
        panel.add(component);
        gridbag.setConstraints(panel, constraints);
        return panel;
    }

    private final JPanel guiRightPanel(String text, JComponent component, GridBagConstraints constraints, GridBagLayout gridbag) {
        JLabel label = new JLabel(text);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        label.setAlignmentX(1.0f);
        panel.add(label);
        component.setAlignmentX(1.0f);
        panel.add(component);
        gridbag.setConstraints(panel, constraints);
        return panel;
    }

    private final JPanel guiCenterPanel(String text, JComponent component, GridBagConstraints constraints, GridBagLayout gridbag) {
        JLabel label = new JLabel(text);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        if (text != null) {
            label.setAlignmentX(0.5f);
            panel.add(label);
        }
        component.setAlignmentX(0.5f);
        panel.add(component);
        gridbag.setConstraints(panel, constraints);
        return panel;
    }

    private final JPanel guiComboBoxBorder(JComboBox box) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new LineBorder(Color.black));
        box.setAlignmentX(0.5f);
        box.setAlignmentY(0.5f);
        panel.add((Component)box, "Center");
        return panel;
    }

    private final JPanel guiDirection() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.radioLeftToRight);
        group.add(this.radioRightToLeft);
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder("Direction of the assoc"));
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.radioLeftToRight);
        panel.add(this.radioRightToLeft);
        this.radioLeftToRight.setEnabled(false);
        this.radioRightToLeft.setEnabled(false);
        return panel;
    }

    public void unparse(UMLClass leftClass, UMLClass rightClass) {
        if (this.assoc != null) {
            this.leftRole = this.assoc.getLeftRole();
            this.rightRole = this.assoc.getRightRole();
            if (this.leftRole == null || this.rightRole == null) {
                this.assoc.removeYou();
                this.assoc = null;
                this.leftRole = null;
                this.rightRole = null;
            }
        } else {
            this.rightRole = null;
            this.leftRole = null;
        }
        if (this.leftRole != null && this.rightRole != null) {
            leftClass = this.leftRole.getTarget();
            rightClass = this.rightRole.getTarget();
        }
        this.unparseClassComboBox(this.boxLeftClass, leftClass);
        this.unparseClassComboBox(this.boxRightClass, rightClass);
        this.unparseQualifierComboBox(this.boxLeftQualifier, this.boxLeftQualifierAttrType, rightClass);
        this.unparseQualifierComboBox(this.boxRightQualifier, this.boxRightQualifierType, leftClass);
        this.unparseConstraintsComboBox(this.assocConstraints);
        this.unparseStereotypesComboBox(this.boxStereotype);
        if (this.assoc != null) {
            this.textName.setText(this.assoc.getName());
            this.boxKind.unparse(this.assoc, this.leftRole, this.rightRole);
            if ("<--------------------".equals(this.boxKind.getSelected())) {
                this.setLeftEditable();
            } else if ("-------------------->".equals(this.boxKind.getSelected())) {
                this.setRightEditable();
            }
            this.transientCheckBox.setSelected(this.assoc.isRolesTransient());
            if (this.assoc.getDirection() == 11) {
                this.radioRightToLeft.setSelected(true);
            } else {
                this.radioLeftToRight.setSelected(true);
            }
            this.textLeftRoleName.setText(this.leftRole.getName());
            this.textLeftCardinality.setText(this.leftRole.getCard().getCardString());
            this.unparseQualifierSelect(this.boxLeftQualifier, this.boxLeftQualifierAttrType, this.leftRole);
            this.boxLeftVisibility.setUmlSelectedIndex(this.leftRole.getUmlVisibility());
            this.textRightRoleName.setText(this.rightRole.getName());
            this.textRightCardinality.setText(this.rightRole.getCard().getCardString());
            this.unparseQualifierSelect(this.boxRightQualifier, this.boxRightQualifierType, this.rightRole);
            this.boxRightVisibility.setUmlSelectedIndex(this.rightRole.getUmlVisibility());
            this.sortedComparator.setEnabled(false);
            if (this.assoc.getSortedComparator() != null) {
                this.sortedComparator.setText(this.assoc.getSortedComparator());
                this.sortedComparator.setEnabled(this.assocConstraints.getSelectedItem().equals("sorted"));
            }
        } else {
            this.textName.setText("Assoc");
            this.boxKind.setSelectedItem("--------------------");
            this.radioLeftToRight.setSelected(true);
            this.textLeftCardinality.setText("0..1");
            this.boxLeftVisibility.setUmlSelectedIndex(1);
            this.textRightCardinality.setText("0..1");
            this.boxRightVisibility.setUmlSelectedIndex(1);
        }
    }

    private void unparseClassComboBox(JComboBox box, UMLClass clazz) {
        UMLDiagram tmpDiag = UMLProject.get().getCurrentUMLDiagram();
        while (tmpDiag != null && tmpDiag instanceof ViewDiagram) {
            tmpDiag = ((ViewDiagram)tmpDiag).getDiagram();
        }
        if (tmpDiag == null || !(tmpDiag instanceof UMLClassDiagram)) {
            Exception e = new Exception("Something's wrong with diagram's editors");
            e.printStackTrace();
        }
        UMLClassDiagram diag = (UMLClassDiagram)tmpDiag;
        JglComboBoxModel model = new JglComboBoxModel(diag.getAllClassItems(), false);
        box.setModel(model);
        box.setSelectedItem(clazz);
    }

    private void addAttributesFromClassToQualifierComboBox(UMLClass clazz) {
        if (clazz != null) {
            Iterator iter = clazz.iteratorOfAllAttrs();
            while (iter.hasNext()) {
                UMLAttr attr = (UMLAttr)iter.next();
                this.names.add(attr.getName());
            }
            iter = clazz.iteratorOfAllRoles();
            while (iter.hasNext()) {
                Object next = iter.next();
                if (!(next instanceof UMLRole)) continue;
                UMLRole umlRole = (UMLRole)next;
                UMLRole partnerRole = umlRole.getPartnerRole();
                if (umlRole.getQualifier() != null || umlRole.getAdornment() == 3 || this.getCardinality(partnerRole) != 1) continue;
                this.names.add(partnerRole.getAttrName());
            }
        }
    }

    private int getCardinality(UMLRole umlRole) {
        int card = 1;
        UMLCardinality umlCard = umlRole.getCard();
        if (umlCard != null) {
            card = umlCard.getUpperBound();
        }
        return card;
    }

    void unparseQualifierComboBox(JComboBox boxName, JComboBox boxType, UMLClass clazz) {
        boxName.setEditable(true);
        boxType.setEnabled(true);
        if (clazz != null) {
            boxName.addItem("None");
            this.names.clear();
            this.addAttributesFromClassToQualifierComboBox(clazz);
            Iterator iter = this.names.iterator();
            while (iter.hasNext()) {
                boxName.addItem(iter.next());
            }
            iter = UMLProject.get().getTypeList().sortedIteratorOfTypes();
            while (iter.hasNext()) {
                UMLType type = (UMLType)iter.next();
                if (type instanceof UMLArray) continue;
                if (type instanceof FClass) {
                    boxType.addItem(((FClass)((Object)type)).getFullClassName());
                    continue;
                }
                boxType.addItem(type.getName());
            }
        } else {
            boxName.setModel(new DefaultComboBoxModel());
            boxType.setModel(new DefaultComboBoxModel());
        }
        boxName.setSelectedItem("None");
        boxType.setEnabled(false);
    }

    void unparseStereotypesComboBox(JComboBox box) {
        box.addItem(null);
        Iterator iter = UMLStereotypeManager.get().iteratorOfStereotypes();
        while (iter.hasNext()) {
            UMLStereotype stereotype = (UMLStereotype)iter.next();
            box.addItem(stereotype);
        }
        if (this.assoc != null) {
            Iterator it = this.assoc.iteratorOfStereotypes();
            if (it.hasNext()) {
                box.setSelectedItem(it.next());
            }
            if (it.hasNext()) {
                JOptionPane.showMessageDialog(this, "EditAssocDialog cannot handle multiple stereotype for an assoc yet. If you choose OK in the dialog only one stereotype will remain!");
            }
        }
    }

    private void unparseQualifierSelect(JComboBox boxName, JComboBox boxType, UMLRole role) {
        UMLQualifier qualifier = role.getQualifier();
        if (qualifier != null) {
            UMLType type;
            boxName.setSelectedItem(qualifier.getName());
            if (qualifier.getType() != null && !((type = qualifier.getType()) instanceof UMLArray)) {
                if (type instanceof FClass) {
                    boxType.setSelectedItem(((FClass)((Object)type)).getFullClassName());
                } else {
                    boxType.setSelectedItem(type.getName());
                }
            }
            if (!qualifier.isExternalQualifier()) {
                boxType.setEnabled(false);
            } else {
                boxType.setEnabled(true);
            }
        } else {
            boxName.setSelectedItem("None");
            boxType.setEnabled(false);
        }
    }

    private void unparseConstraintsComboBox(JComboBox assocConstraints) {
        assocConstraints.addActionListener(new ConstraintBoxActionListener());
        assocConstraints.addItem("No");
        assocConstraints.addItem("sorted");
        assocConstraints.addItem("ordered");
        assocConstraints.setSelectedIndex(0);
        if (this.assoc != null) {
            Iterator iter = this.assoc.iteratorOfConstraints();
            while (iter.hasNext()) {
                UMLConstraint constraint = (UMLConstraint)iter.next();
                if (constraint.getText().equals("sorted")) {
                    assocConstraints.setSelectedIndex(1);
                    continue;
                }
                if (!constraint.getText().equals("ordered")) continue;
                assocConstraints.setSelectedIndex(2);
            }
        }
    }

    private void setRoleName(UMLRole role, JTextField field, JComboBox nameBox, JComboBox classBox, String otherRoleName, UMLRole otherRole) {
        String roleName = field.getText().trim();
        if (!roleName.equals("") && roleName.equals(role.getName())) {
            return;
        }
        UMLClass nameClass = this.getSelected(nameBox);
        UMLClass classClass = this.getSelected(classBox);
        if (nameClass == null || classClass == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"ALERT: EditAssocDialog: Some class  and a role name are missing.");
            }
            if (roleName.equals("")) {
                roleName = "role";
            }
        } else {
            if (roleName.equals("")) {
                roleName = nameClass.getName();
            }
            roleName = EditAssocDialog.toUnused(roleName, role, otherRoleName, otherRole, classClass);
        }
        role.setName(roleName);
    }

    public static String toUnused(String roleName, UMLRole role, String otherRoleName, UMLRole otherRole, UMLClass clazz) {
        roleName = Utility.downFirstChar(roleName);
        UMLAttr existingAttr = clazz.getFromAllAttrs(roleName);
        UMLRole existingRole = EditAssocDialog.findRole(clazz, roleName);
        String result = roleName;
        boolean mayBeSameName = role.getTarget() == otherRole.getTarget() && (role.getCard().getCardString() == otherRole.getCard().getCardString() || role.getCard().getCardString() != null && role.getCard().getCardString().equals(otherRole.getCard().getCardString()));
        int i = 1;
        while (existingAttr != null && existingAttr.getImplementingAssocRole() != role && (!mayBeSameName || existingAttr.getImplementingAssocRole() != otherRole) || existingRole != null && existingRole != role && (!mayBeSameName || existingRole != otherRole) || !mayBeSameName && result.equals(otherRoleName)) {
            result = String.valueOf(roleName) + i;
            existingAttr = clazz.getFromAllAttrs(result);
            existingRole = EditAssocDialog.findRole(clazz, result);
            ++i;
        }
        return result;
    }

    private static UMLRole findRole(UMLClass umlClass, String name) {
        Iterator roleIter = umlClass.iteratorOfAllRoles();
        while (roleIter.hasNext()) {
            UMLRole umlRole = (UMLRole)roleIter.next();
            if ((umlRole = umlRole.getPartnerRole()) == null || !name.equals(umlRole.getName())) continue;
            return umlRole;
        }
        return null;
    }

    public void parse() {
        if (this.assoc == null) {
            this.leftRole = new UMLRole();
            this.leftRole.setCard(new UMLCardinality());
            this.rightRole = new UMLRole();
            this.rightRole.setCard(new UMLCardinality());
            this.assoc = new UMLAssoc(this.textName.getText(), 10, null, this.leftRole, this.rightRole);
        } else {
            this.assoc.setName(this.textName.getText());
        }
        this.assoc.setRolesTransient(this.transientCheckBox.isSelected());
        if (this.radioRightToLeft.isSelected()) {
            this.assoc.setDirection(11);
        } else {
            this.assoc.setDirection(10);
        }
        this.boxKind.parse(this.leftRole, this.rightRole);
        this.leftRole.getCard().setCardString(this.textLeftCardinality.getText());
        this.leftRole.setUmlVisibility(this.boxLeftVisibility.getUmlSelectedIndex());
        this.parseQualifierComboBox(this.boxLeftQualifier, this.boxLeftQualifierAttrType, this.leftRole);
        this.parseClassComboBox(this.boxLeftClass, this.leftRole);
        this.parseStereotypes(this.boxStereotype, this.assoc);
        this.rightRole.getCard().setCardString(this.textRightCardinality.getText());
        this.rightRole.setUmlVisibility(this.boxRightVisibility.getUmlSelectedIndex());
        this.parseQualifierComboBox(this.boxRightQualifier, this.boxRightQualifierType, this.rightRole);
        this.parseClassComboBox(this.boxRightClass, this.rightRole);
        this.parseConstraints(this.assocConstraints);
        this.assoc.setSortedComparator(this.sortedComparator.getText());
        this.setRoleName(this.leftRole, this.textLeftRoleName, this.boxLeftClass, this.boxRightClass, null, this.rightRole);
        this.setRoleName(this.rightRole, this.textRightRoleName, this.boxRightClass, this.boxLeftClass, this.leftRole.getName(), this.leftRole);
        EditAssocDialog.addAssocToAllClassDiags(this.assoc);
    }

    public static void addAssocToAllClassDiags(UMLAssoc assoc) {
        Iterator iter = UMLProject.get().iteratorOfDiags();
        UMLClass leftClass = assoc.getLeftRole().getTarget();
        UMLClass rightClass = assoc.getRightRole().getTarget();
        while (iter.hasNext()) {
            ASGDiagram tmpDiag = (ASGDiagram)iter.next();
            if (!(tmpDiag instanceof UMLDiagram)) continue;
            UMLDiagram diag = (UMLDiagram)tmpDiag;
            if (diag.hasInElements(leftClass) && diag.hasInElements(rightClass)) {
                diag.addToElements(assoc);
                diag.addToElements(leftClass);
                diag.addToElements(rightClass);
                continue;
            }
            if (!diag.hasInElements(assoc)) continue;
            diag.removeFromElements(assoc);
        }
    }

    private final void parseQualifierComboBox(JComboBox boxName, JComboBox boxType, UMLRole role) {
        UMLQualifier qualifier = role.getQualifier();
        String qName = (String)boxName.getSelectedItem();
        UMLType qType = UMLProject.get().getTypeList().getFromTypes((String)boxType.getSelectedItem());
        if (!qName.equals("None") && !qName.equals("")) {
            UMLClass clazz = (UMLClass)(boxName == this.boxLeftQualifier ? this.boxRightClass.getSelectedItem() : this.boxLeftClass.getSelectedItem());
            UMLAttr attr = clazz.getFromAllAttrs(qName);
            if (qualifier == null) {
                qualifier = new UMLQualifier();
                qualifier.setRevQualifier(role);
            }
            qualifier.setQualifiedAttr(attr);
            if (attr == null) {
                UMLRole qualRole = clazz.getFromAllPartnerRoles(qName);
                qualifier.setQualifiedRole(qualRole);
                if (qualRole == null) {
                    qualifier.setName(qName);
                    qualifier.setType(qType);
                }
            }
            role.setAdornment(4);
        } else if (qualifier != null) {
            role.setQualifier(null);
            qualifier.removeYou();
            if (role.getAdornment() == 4) {
                role.setAdornment(0);
            }
        }
    }

    private void parseStereotypes(JComboBox box, UMLAssoc association) {
        if (association != null) {
            association.removeAllFromStereotypes();
            UMLStereotype selectedStereotype = (UMLStereotype)box.getSelectedItem();
            association.addToStereotypes(selectedStereotype);
        }
    }

    private UMLClass getSelected(JComboBox box) {
        Object sel = box.getSelectedItem();
        return sel instanceof UMLClass ? (UMLClass)sel : null;
    }

    private final void parseClassComboBox(JComboBox box, UMLRole role) {
        UMLClass clazz = this.getSelected(box);
        if (clazz != null && role.getTarget() != clazz) {
            role.setTarget(clazz);
        }
    }

    private void parseConstraints(JComboBox assocConstraints) {
        String str = (String)assocConstraints.getSelectedItem();
        Iterator iter = this.assoc.iteratorOfConstraints();
        while (iter.hasNext()) {
            UMLConstraint constraint = (UMLConstraint)iter.next();
            if (!constraint.getText().equals("sorted") && !constraint.getText().equals("ordered")) continue;
            this.assoc.removeFromConstraints(constraint);
        }
        if (str.equals("sorted") || str.equals("ordered")) {
            this.assoc.addToConstraints(new UMLConstraint(str));
        }
    }

    void setLeftEditable() {
        this.textRightRoleName.setEditable(false);
        this.textRightCardinality.setEditable(false);
        this.boxRightVisibility.setEnabled(false);
        this.boxLeftQualifier.setSelectedItem("None");
        this.boxLeftQualifier.setEditable(false);
        this.boxLeftQualifier.setEnabled(false);
        this.boxLeftQualifierAttrType.setEnabled(false);
        this.textLeftRoleName.setEditable(true);
        this.textLeftCardinality.setEditable(true);
        this.boxRightQualifier.setEditable(true);
        this.boxRightQualifier.setEnabled(true);
        this.boxLeftVisibility.setEnabled(true);
        if (this.rightQualifierEnabled) {
            this.boxRightQualifierType.setEnabled(true);
        }
    }

    void setRightEditable() {
        this.textLeftRoleName.setEditable(false);
        this.textLeftCardinality.setEditable(false);
        this.boxLeftVisibility.setEnabled(false);
        this.boxRightQualifier.setSelectedItem("None");
        this.boxRightQualifier.setEditable(false);
        this.boxRightQualifier.setEnabled(false);
        this.boxRightQualifierType.setEnabled(false);
        this.textRightRoleName.setEditable(true);
        this.textRightCardinality.setEditable(true);
        this.boxLeftQualifier.setEditable(true);
        this.boxLeftQualifier.setEnabled(true);
        this.boxRightVisibility.setEnabled(true);
        if (this.leftQualifierEnabled) {
            this.boxLeftQualifierAttrType.setEnabled(true);
        }
    }

    void setAllEditable() {
        this.textRightRoleName.setEditable(true);
        this.textRightCardinality.setEditable(true);
        this.textLeftRoleName.setEditable(true);
        this.textLeftCardinality.setEditable(true);
        this.boxRightVisibility.setEnabled(true);
        this.boxRightQualifier.setEditable(true);
        this.boxRightQualifier.setEnabled(true);
        this.boxLeftVisibility.setEnabled(true);
        this.boxLeftQualifier.setEditable(true);
        this.boxLeftQualifier.setEnabled(true);
        if (this.leftQualifierEnabled) {
            this.boxLeftQualifierAttrType.setEnabled(true);
        }
        if (this.rightQualifierEnabled) {
            this.boxRightQualifierType.setEnabled(true);
        }
    }

    public void actionOkButton() {
        super.actionOkButton();
    }

    class BoxClassActionListener
    implements ActionListener {
        BoxClassActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (EditAssocDialog.this.actionMode) {
                EditAssocDialog.this.actionMode = false;
                JComboBox currentBox = (JComboBox)e.getSource();
                UMLClass selClass = (UMLClass)currentBox.getSelectedItem();
                if (currentBox == EditAssocDialog.this.boxLeftClass) {
                    EditAssocDialog.this.unparseQualifierComboBox(EditAssocDialog.this.boxRightQualifier, EditAssocDialog.this.boxRightQualifierType, selClass);
                    EditAssocDialog.this.boxRightQualifier.setSelectedItem("None");
                } else {
                    EditAssocDialog.this.unparseQualifierComboBox(EditAssocDialog.this.boxLeftQualifier, EditAssocDialog.this.boxLeftQualifierAttrType, selClass);
                    EditAssocDialog.this.boxLeftQualifier.setSelectedItem("None");
                }
                EditAssocDialog.this.actionMode = true;
            }
        }
    }

    class BoxKindActionListener
    implements ActionListener {
        BoxKindActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (EditAssocDialog.this.actionMode) {
                EditAssocDialog.this.actionMode = false;
                int direction = EditAssocDialog.this.boxKind.getDirection();
                if (direction == 10 && EditAssocDialog.this.boxLeftQualifier.getSelectedItem() instanceof UMLAttr) {
                    EditAssocDialog.this.boxLeftQualifier.setSelectedItem("NONE");
                } else if (direction == 11 && EditAssocDialog.this.boxRightQualifier.getSelectedItem() instanceof UMLAttr) {
                    EditAssocDialog.this.boxRightQualifier.setSelectedItem("NONE");
                }
                if ("-------------------->".equals(EditAssocDialog.this.boxKind.getSelected())) {
                    EditAssocDialog.this.setRightEditable();
                } else if ("<--------------------".equals(EditAssocDialog.this.boxKind.getSelected())) {
                    EditAssocDialog.this.setLeftEditable();
                } else {
                    EditAssocDialog.this.setAllEditable();
                }
                EditAssocDialog.this.actionMode = true;
            }
        }
    }

    class BoxQualifierActionListener
    implements ActionListener {
        BoxQualifierActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (EditAssocDialog.this.actionMode) {
                EditAssocDialog.this.actionMode = false;
                JComboBox currentBox = (JComboBox)e.getSource();
                Object sel = currentBox.getSelectedItem();
                int direction = EditAssocDialog.this.boxKind.getDirection();
                if (sel instanceof String || direction != -1) {
                    JComboBox boxType;
                    String selection = (String)sel;
                    if (currentBox == EditAssocDialog.this.boxLeftQualifier && direction == 10) {
                        EditAssocDialog.this.boxKind.setSelectedItem("--------------------");
                    } else if (currentBox == EditAssocDialog.this.boxRightQualifier && direction == 11) {
                        EditAssocDialog.this.boxKind.setSelectedItem("--------------------");
                    }
                    UMLClass clazz = (UMLClass)(currentBox == EditAssocDialog.this.boxLeftQualifier ? EditAssocDialog.this.boxRightClass.getSelectedItem() : EditAssocDialog.this.boxLeftClass.getSelectedItem());
                    JComboBox jComboBox = boxType = currentBox == EditAssocDialog.this.boxLeftQualifier ? EditAssocDialog.this.boxLeftQualifierAttrType : EditAssocDialog.this.boxRightQualifierType;
                    if (!selection.equals("None") && !selection.equals("")) {
                        UMLAttr attr = clazz.getFromAllAttrs(selection);
                        if (attr != null) {
                            boxType.setSelectedItem(attr.getUMLType().getName());
                            boxType.setEnabled(false);
                            if (boxType == EditAssocDialog.this.boxLeftQualifierAttrType) {
                                EditAssocDialog.this.leftQualifierEnabled = false;
                            } else {
                                EditAssocDialog.this.rightQualifierEnabled = false;
                            }
                        } else {
                            UMLRole qualRole = clazz.getFromAllPartnerRoles(selection);
                            if (qualRole != null) {
                                boxType.setSelectedItem(qualRole.getPartnerRole().getTarget());
                                boxType.setEnabled(false);
                                if (boxType == EditAssocDialog.this.boxLeftQualifierAttrType) {
                                    EditAssocDialog.this.leftQualifierEnabled = false;
                                } else {
                                    EditAssocDialog.this.rightQualifierEnabled = false;
                                }
                            } else {
                                boxType.setEnabled(true);
                                if (boxType == EditAssocDialog.this.boxLeftQualifierAttrType) {
                                    EditAssocDialog.this.leftQualifierEnabled = true;
                                } else {
                                    EditAssocDialog.this.rightQualifierEnabled = true;
                                }
                            }
                        }
                    } else {
                        boxType.setEnabled(false);
                        if (boxType == EditAssocDialog.this.boxLeftQualifierAttrType) {
                            EditAssocDialog.this.leftQualifierEnabled = false;
                        } else {
                            EditAssocDialog.this.rightQualifierEnabled = false;
                        }
                    }
                }
                EditAssocDialog.this.actionMode = true;
            }
        }
    }

    class TextNameCaretListener
    implements CaretListener {
        TextNameCaretListener() {
        }

        public void caretUpdate(CaretEvent e) {
            if (EditAssocDialog.this.actionMode) {
                EditAssocDialog.this.getButtonOk().setEnabled(EditAssocDialog.this.textName.getText().length() != 0);
                EditAssocDialog.this.actionMode = true;
            }
        }
    }

    class TextRoleNameCaretListener
    implements CaretListener {
        TextRoleNameCaretListener() {
        }

        public void caretUpdate(CaretEvent e) {
            if (EditAssocDialog.this.actionMode) {
                EditAssocDialog.this.actionMode = true;
            }
        }
    }

    class ConstraintBoxActionListener
    implements ActionListener {
        ConstraintBoxActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            JComboBox box = (JComboBox)event.getSource();
            Object str = box.getSelectedItem();
            EditAssocDialog.this.sortedComparator.setEnabled(str.equals("sorted"));
        }
    }
}

