/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ComboDialog
extends JDialog {
    public static final int NO_OTHER = 0;
    public static final int USR_DEF = 1;
    private static String defLabel = "Please choose an item:";
    private static String defTitle = "Chooser";
    public static int OK_PRESSED = 0;
    public static int CANCEL_PRESSED = 1;
    public static int OTHER_PRESSED = 2;
    Object selItem = null;
    JComboBox itemBox;
    private JButton okButton;
    private JButton cancelButton;
    private JButton otherButton;
    private JLabel textLabel;
    private int pressed = 0;
    private JPanel center;
    private JLabel errorLabel;

    public ComboDialog(JFrame f, Object[] itemlist) {
        super(f);
        this.init(defLabel, defTitle, itemlist, 0);
    }

    public ComboDialog(JFrame f, String label, String title, Object[] itemlist) {
        super(f);
        this.init(label, title, itemlist, 0);
    }

    public ComboDialog(JFrame f, String label, String title, Object[] itemlist, int other) {
        super(f);
        this.init(label, title, itemlist, other);
    }

    private void init(String label, String title, Object[] itemlist, int other) {
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(title);
        this.setSize(600, 125);
        Dimension mydim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((int)((mydim.getWidth() - (double)this.getWidth()) / 2.0), (int)(mydim.getHeight() - (double)this.getHeight()) / 2);
        this.setModal(true);
        this.setResizable(false);
        JPanel north = new JPanel(new BorderLayout());
        this.textLabel = new JLabel(label);
        north.add((Component)new JLabel(" "), "North");
        north.add((Component)new JLabel("  "), "West");
        north.add((Component)this.textLabel, "Center");
        this.center = new JPanel(new BorderLayout());
        this.center.setBackground(Color.white);
        JPanel south = new JPanel(new FlowLayout(2));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new okListener());
        south.add(this.okButton);
        this.itemBox = new JComboBox<Object>(itemlist);
        this.itemBox.setEditable(false);
        this.itemBox.setBackground(Color.white);
        this.itemBox.setRenderer(new MyCellRenderer(this.itemBox));
        this.setItemList(itemlist);
        if (other > 0) {
            this.otherButton = new JButton("Other...");
            this.otherButton.addActionListener(new otherListener());
            south.add(this.otherButton);
        }
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new cancelListener());
        south.add(this.cancelButton);
        this.getContentPane().add((Component)north, "North");
        this.getContentPane().add((Component)this.center, "Center");
        this.getContentPane().add((Component)south, "South");
    }

    public void setItemList(Object[] itemlist) {
        Object selectedFile = null;
        if (this.itemBox != null) {
            selectedFile = this.itemBox.getSelectedItem();
            this.center.remove(this.itemBox);
        }
        if (this.errorLabel != null) {
            this.center.remove(this.errorLabel);
        }
        this.itemBox.removeAllItems();
        if (itemlist != null && itemlist.length > 0) {
            int i = 0;
            while (i < itemlist.length) {
                this.itemBox.addItem(itemlist[i]);
                ++i;
            }
            if (this.itemBox.getItemCount() != 0) {
                this.itemBox.setSelectedIndex(0);
            }
            if (selectedFile != null) {
                this.itemBox.setSelectedItem(selectedFile);
            }
            this.center.add((Component)this.itemBox, "Center");
            this.okButton.setVisible(true);
        } else {
            this.errorLabel = new JLabel("  ERROR: No matching item found!");
            this.center.add((Component)this.errorLabel, "Center");
            this.okButton.setVisible(false);
        }
    }

    public Object getSelectedItem() {
        return this.selItem;
    }

    public ListCellRenderer getRenderer() {
        return this.itemBox.getRenderer();
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.itemBox.setRenderer(renderer);
    }

    public int getPressed() {
        return this.pressed;
    }

    void setPressed(int value) {
        this.pressed = value;
    }

    private class okListener
    implements ActionListener {
        okListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ComboDialog.this.setPressed(OK_PRESSED);
            ComboDialog.this.selItem = ComboDialog.this.itemBox.getSelectedItem();
            ComboDialog.this.hide();
        }
    }

    private class cancelListener
    implements ActionListener {
        cancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ComboDialog.this.selItem = null;
            ComboDialog.this.setPressed(CANCEL_PRESSED);
            ComboDialog.this.hide();
        }
    }

    private class otherListener
    implements ActionListener {
        otherListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ComboDialog.this.setPressed(OTHER_PRESSED);
            ComboDialog.this.hide();
        }
    }

    private class MyCellRenderer
    extends DefaultListCellRenderer {
        private JComboBox parent;
        private static final int maxTextLength = 70;

        public MyCellRenderer(JComboBox parent) {
            this.parent = parent;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String itemText = label.getText();
            if (itemText.length() > 70) {
                if (this.parent != null && cellHasFocus || isSelected) {
                    this.parent.setToolTipText(itemText);
                } else {
                    this.parent.setToolTipText("");
                }
                itemText = "..." + itemText.substring(itemText.length() - 70);
                label.setText(itemText);
            }
            return label;
        }
    }
}

