/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.unparse;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.listener.CascadedPropertyChangeSupport;
import de.uni_paderborn.fujaba.fsa.unparse.FSAInterface;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.unparse.UnparseInterface;
import de.uni_paderborn.fujaba.fsa.unparse.WeakKey;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.pcs.CollectionChangeEvent;
import de.upb.tools.sdm.Path;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class UnparseManager {
    private static final transient Logger log;
    private static transient UnparseManager singleton;
    private transient TreeMap unparseModules = new TreeMap();
    private transient StringBuffer moduleNameStringBuffer;
    private LinkedList queuedPropertyEvents = new LinkedList();
    private boolean pausePropertyProcessing = false;
    private PropertyChangeListener consistencyPCL = null;
    private WeakHashMap cascadedProperties;
    private WeakHashMap deferredUnparseTargets;
    private ReferenceQueue deferredUnparseTargetsGCQueue;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.fsa.unparse.UnparseManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
        singleton = null;
    }

    private UnparseManager() {
    }

    public static synchronized UnparseManager get() {
        if (singleton == null) {
            singleton = new UnparseManager();
        }
        return singleton;
    }

    public final synchronized UnparseInterface getUnparseModule(LogicUnparseInterface iface) {
        return this.getUnparseModuleImpl(iface);
    }

    public final synchronized UnparseInterface getUnparseModule(String className, ClassLoader loader) {
        return this.getUnparseModuleImpl(className, loader);
    }

    protected UnparseInterface getUnparseModuleImpl(LogicUnparseInterface iface) {
        return this.getUnparseModuleImpl(iface.getUnparseModuleName(), iface.getClass().getClassLoader());
    }

    protected UnparseInterface getUnparseModuleImpl(String className, ClassLoader loader) {
        UnparseInterface unparseModule = (UnparseInterface)this.unparseModules.get(className);
        if (unparseModule == null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading " + className));
                }
                unparseModule = (UnparseInterface)Class.forName(className, true, loader).newInstance();
                this.unparseModules.put(className, unparseModule);
            }
            catch (ClassNotFoundException e1) {
                log.error((Object)("Could not find the UnparseModule " + className));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("searched for: " + className));
                }
                e1.printStackTrace();
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
            catch (InstantiationException e3) {
                e3.printStackTrace();
            }
        }
        return unparseModule;
    }

    public String getUnparseModuleName(LogicUnparseInterface iface) {
        String className = iface.getClass().getName();
        int packageClassSeparator = className.lastIndexOf(46);
        if (this.moduleNameStringBuffer == null) {
            this.moduleNameStringBuffer = new StringBuffer();
        } else {
            this.moduleNameStringBuffer.delete(0, this.moduleNameStringBuffer.length());
        }
        this.moduleNameStringBuffer.append(className);
        this.moduleNameStringBuffer.insert(packageClassSeparator + 1, "unparse.UM");
        return this.moduleNameStringBuffer.toString();
    }

    public FSAObject unparse(LogicUnparseInterface incr) {
        FSAInterface iface = incr.getFSAInterface();
        if (iface != null) {
            FSAObject obj = this.unparse(incr, iface.getMainFsaFromFsaObjects(null));
            return obj;
        }
        return null;
    }

    public final synchronized FSAObject unparse(LogicUnparseInterface incr, FSAObject fsaObject) {
        return this.unparseImpl(incr, fsaObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FSAObject unparseImpl(LogicUnparseInterface incr, FSAObject fsaObject) {
        FSAObject result = null;
        if (incr != null && incr.getFSAInterface() != null && incr.getFSAInterface().isUnparse()) {
            FSAInterface iface = incr.getFSAInterface();
            UnparseInterface unparseModule = this.getUnparseModuleImpl(incr);
            if (unparseModule != null) {
                if (iface.hasInFsaObjects(fsaObject)) {
                    result = fsaObject;
                } else {
                    boolean consistent;
                    result = iface.getFromFsaObjects(FSAObject.getQualifiedName(fsaObject, unparseModule.getMainFsaName()));
                    if (result == null && (consistent = this.observeConsistency(incr, fsaObject))) {
                        if (fsaObject != null && fsaObject.getJComponent() != null) {
                            JComponent comp = fsaObject.getJComponent();
                            Object object = comp.getTreeLock();
                            synchronized (object) {
                                result = unparseModule.create(fsaObject, incr);
                                if (result != null) {
                                    JComponent jComponent = result.getJComponent();
                                    boolean vis = jComponent.isVisible();
                                    jComponent.setVisible(false);
                                    this.initialize(unparseModule, incr, result);
                                    jComponent.setVisible(vis);
                                }
                            }
                        } else {
                            result = unparseModule.create(fsaObject, incr);
                            if (result != null) {
                                JComponent jComponent = result.getJComponent();
                                boolean vis = jComponent.isVisible();
                                jComponent.setVisible(false);
                                this.initialize(unparseModule, incr, result);
                                jComponent.setVisible(vis);
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    void initialize(UnparseInterface unparseModule, LogicUnparseInterface incr, FSAObject fsaObject) {
        LinkedHashSet properties = new LinkedHashSet();
        unparseModule.getChildProperties(properties);
        FSAInterface iface = incr.getFSAInterface();
        Iterator iter = properties.iterator();
        while (iter.hasNext()) {
            String prop = (String)iter.next();
            if (prop.indexOf(".") > -1) {
                CascadedPropertyChangeSupport cpcs = new CascadedPropertyChangeSupport(prop, (Object)incr);
                cpcs.addPropertyChangeListener(prop, iface);
                String base = prop.substring(0, prop.indexOf("."));
                String name = prop.substring(prop.indexOf(".1"));
                Path basePath = new Path(incr, base);
                while (basePath.hasNext()) {
                    Object source = basePath.next();
                    Path elements = new Path(source, name);
                    while (elements.hasNext()) {
                        PropertyChangeEvent evt = new PropertyChangeEvent(source, prop, null, elements.next());
                        String id = this.getFsaID(fsaObject, unparseModule, prop);
                        this.processAddEvent(incr, evt, id, unparseModule);
                    }
                }
                continue;
            }
            incr.getPropertyChangeSupport().addPropertyChangeListener(prop, iface);
            Path elements = new Path(incr, prop);
            while (elements.hasNext()) {
                Object obj = elements.next();
                if (obj == null) continue;
                PropertyChangeEvent evt = new PropertyChangeEvent(incr, prop, null, obj);
                String id = this.getFsaID(fsaObject, unparseModule, prop);
                this.processAddEvent(incr, evt, id, unparseModule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(FSAInterface iface, PropertyChangeEvent event) {
        LinkedList linkedList = this.queuedPropertyEvents;
        synchronized (linkedList) {
            if (this.pausePropertyProcessing) {
                Object[] array = new Object[]{iface, event};
                this.queuedPropertyEvents.add(array);
                return;
            }
        }
        LogicUnparseInterface incr = iface.getLogic();
        if (iface.sizeOfFsaObjects() > 0) {
            Iterator iter = iface.entriesOfFsaObjects();
            UnparseInterface unparseModule = this.getUnparseModuleImpl(incr);
            String mainFsaName = unparseModule.getMainFsaName();
            String mainFsaPart = "." + mainFsaName;
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                String key = (String)entry.getKey();
                if (!key.endsWith(mainFsaPart)) continue;
                this.processEvent(incr, event, this.getFsaID((FSAObject)entry.getValue(), unparseModule, event.getPropertyName()), unparseModule);
            }
        }
    }

    private String getFsaID(FSAObject fsaObject, UnparseInterface unparseModule, String property) {
        String fsaId;
        String mainFsaName = unparseModule.getMainFsaName();
        if (mainFsaName.equals(unparseModule.getContainerForProperty(property))) {
            String key = fsaObject.getQualifiedName();
            fsaId = key.substring(0, key.indexOf(46));
        } else {
            fsaId = fsaObject.getID();
        }
        return fsaId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pausePropertyProcessing() {
        LinkedList linkedList = this.queuedPropertyEvents;
        synchronized (linkedList) {
            if (!this.pausePropertyProcessing) {
                this.pausePropertyProcessing = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumePropertyProcessing() {
        LinkedList linkedList = this.queuedPropertyEvents;
        synchronized (linkedList) {
            if (this.pausePropertyProcessing) {
                this.pausePropertyProcessing = false;
                Iterator iter = this.queuedPropertyEvents.iterator();
                while (iter.hasNext()) {
                    Object[] array = (Object[])iter.next();
                    FSAInterface iface = (FSAInterface)array[0];
                    PropertyChangeEvent evt = (PropertyChangeEvent)array[1];
                    this.propertyChange(iface, evt);
                    iter.remove();
                }
            }
        }
    }

    protected final void processEvent(LogicUnparseInterface iface, PropertyChangeEvent event, String fsaId, UnparseInterface unparseModule) {
        if (event instanceof CollectionChangeEvent) {
            CollectionChangeEvent collectionChangeEvent = (CollectionChangeEvent)event;
            if (CollectionChangeEvent.isAddEvent(collectionChangeEvent.getType())) {
                this.processAddEvent(iface, event, fsaId, unparseModule);
            } else if (CollectionChangeEvent.isRemoveEvent(collectionChangeEvent.getType())) {
                this.processRemoveEvent(iface, event, fsaId, unparseModule);
            } else {
                this.processChangeEvent(iface, event, fsaId, unparseModule);
            }
        } else {
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if (oldValue != null && newValue == null) {
                this.processRemoveEvent(iface, event, fsaId, unparseModule);
            } else if (newValue != null && oldValue == null) {
                this.processAddEvent(iface, event, fsaId, unparseModule);
            } else if (oldValue != null && newValue != null) {
                this.processChangeEvent(iface, event, fsaId, unparseModule);
            }
        }
    }

    protected final synchronized void processAddEvent(LogicUnparseInterface iface, PropertyChangeEvent event, String fsaId, UnparseInterface unparseModule) {
        this.processAddEventImpl(iface, event, fsaId, unparseModule);
    }

    protected void processAddEventImpl(LogicUnparseInterface iface, PropertyChangeEvent event, String fsaId, UnparseInterface unparseModule) {
        LogicUnparseInterface addedObject = (LogicUnparseInterface)event.getNewValue();
        FSAInterface fsaIface = iface.getFSAInterface();
        String tmpValue = unparseModule.getContainerForProperty(event.getPropertyName());
        FSAObject containerObject = fsaIface.getFromFsaObjects(String.valueOf(fsaId) + "." + tmpValue);
        if (addedObject.getFSAInterface() != null && addedObject.getFSAInterface().isUnparse()) {
            this.unparseImpl(addedObject, containerObject);
        }
    }

    protected final synchronized void processRemoveEvent(LogicUnparseInterface iface, PropertyChangeEvent event, String fsaId, UnparseInterface unparseModule) {
        this.processRemoveEventImpl(iface, event, fsaId, unparseModule);
    }

    protected void processRemoveEventImpl(LogicUnparseInterface iface, PropertyChangeEvent event, String fsaId, UnparseInterface unparseModule) {
        LogicUnparseInterface removedObject = (LogicUnparseInterface)event.getOldValue();
        if (removedObject == null) {
            return;
        }
        FSAInterface fsaIface = iface.getFSAInterface();
        UnparseInterface removedUnparseModule = this.getUnparseModuleImpl(removedObject);
        FSAObject containerObject = fsaIface.getFromFsaObjects(String.valueOf(fsaId) + "." + unparseModule.getContainerForProperty(event.getPropertyName()));
        if (containerObject != null) {
            String id = containerObject.getID();
            containerObject = removedObject.getFSAInterface().getFromFsaObjects(String.valueOf(id) + "." + removedUnparseModule.getMainFsaName());
            if (containerObject != null) {
                removedUnparseModule.remove(containerObject, iface);
            }
        }
    }

    protected final synchronized void processChangeEvent(LogicUnparseInterface iface, PropertyChangeEvent event, String fsaId, UnparseInterface unparseModule) {
        this.processChangeEventImpl(iface, event, fsaId, unparseModule);
    }

    protected void processChangeEventImpl(LogicUnparseInterface iface, PropertyChangeEvent event, String fsaId, UnparseInterface unparseModule) {
        this.processRemoveEventImpl(iface, event, fsaId, unparseModule);
        this.processAddEventImpl(iface, event, fsaId, unparseModule);
    }

    public final synchronized boolean isConsistent(LogicUnparseInterface incr) {
        return this.isConsistentImpl(incr);
    }

    protected boolean isConsistentImpl(LogicUnparseInterface incr) {
        FSAInterface fsaIface;
        boolean result = false;
        if (incr != null && (fsaIface = incr.getFSAInterface()) != null && fsaIface.isUnparse()) {
            UnparseInterface unparseModule = this.getUnparseModuleImpl(incr);
            HashSet partners = new HashSet();
            unparseModule.getPartnerProperties(partners);
            result = true;
            Iterator iter = partners.iterator();
            while (iter.hasNext()) {
                String prop = (String)iter.next();
                boolean tmpResult = false;
                Path elements = new Path(incr, prop);
                while (elements.hasNext() && !tmpResult) {
                    Object next = elements.next();
                    if (!(next instanceof LogicUnparseInterface)) continue;
                    tmpResult = true;
                }
                if (tmpResult) continue;
                result = false;
            }
        }
        return result;
    }

    protected boolean observeConsistency(LogicUnparseInterface incr, FSAObject unparseTarget) {
        FSAInterface iface;
        boolean result = this.isConsistentImpl(incr);
        if (incr != null && (iface = incr.getFSAInterface()) != null) {
            if (!result && iface.isUnparse()) {
                UnparseInterface unparseModule = this.getUnparseModuleImpl(incr);
                HashSet partners = new HashSet();
                unparseModule.getPartnerProperties(partners);
                Iterator iter = partners.iterator();
                while (iter.hasNext()) {
                    String prop = (String)iter.next();
                    if (prop.indexOf(".") > -1 && !this.hasKeyInCascadedProperties(incr, prop)) {
                        CascadedPropertyChangeSupport cpcs = new CascadedPropertyChangeSupport(prop, (Object)incr);
                        this.addToCascadedProperties(incr, prop, cpcs);
                        cpcs.addPropertyChangeListener(prop, this.getConsistencyPCL());
                        continue;
                    }
                    PropertyChangeSupport support = incr.getPropertyChangeSupport();
                    support.removePropertyChangeListener(prop, this.getConsistencyPCL());
                    support.addPropertyChangeListener(prop, this.getConsistencyPCL());
                }
                if (unparseTarget != null) {
                    this.addToDeferredUnparseTargets(incr, unparseTarget);
                }
            }
            iface.setConsistent(result);
        }
        return result;
    }

    protected void unobserveConsistency(LogicUnparseInterface incr) {
        UnparseInterface unparseModule = this.getUnparseModuleImpl(incr);
        PropertyChangeSupport support = incr.getPropertyChangeSupport();
        HashSet partners = new HashSet();
        unparseModule.getPartnerProperties(partners);
        Iterator iter = partners.iterator();
        while (iter.hasNext()) {
            String prop = (String)iter.next();
            support.removePropertyChangeListener(prop, this.getConsistencyPCL());
        }
        this.removeKeyFromCascadedProperties(incr);
        this.removeKeyFromDeferredUnparseTargets(incr);
    }

    protected PropertyChangeListener getConsistencyPCL() {
        if (this.consistencyPCL == null) {
            this.consistencyPCL = new ConsistencyPCL();
        }
        return this.consistencyPCL;
    }

    protected boolean addToCascadedProperties(LogicUnparseInterface value, String property, CascadedPropertyChangeSupport cpcs) {
        boolean changed = false;
        if (value != null && property != null && cpcs != null) {
            WeakReference<CascadedPropertyChangeSupport> ref;
            WeakReference<CascadedPropertyChangeSupport> old;
            HashMap<String, WeakReference<CascadedPropertyChangeSupport>> propMap;
            if (this.cascadedProperties == null) {
                this.cascadedProperties = new WeakHashMap();
            }
            if ((propMap = (HashMap<String, WeakReference<CascadedPropertyChangeSupport>>)this.cascadedProperties.get(value)) == null) {
                propMap = new HashMap<String, WeakReference<CascadedPropertyChangeSupport>>();
                this.cascadedProperties.put(value, propMap);
            }
            changed = cpcs != (old = propMap.put(property, ref = new WeakReference<CascadedPropertyChangeSupport>(cpcs))).get();
        }
        return changed;
    }

    public boolean hasKeyInCascadedProperties(LogicUnparseInterface value) {
        return value != null && this.cascadedProperties != null && this.cascadedProperties.get(value) != null;
    }

    public boolean hasKeyInCascadedProperties(LogicUnparseInterface value, String property) {
        Map propMap;
        boolean result = false;
        if (value != null && property != null && this.cascadedProperties != null && (propMap = (Map)this.cascadedProperties.get(value)) != null) {
            WeakReference ref = (WeakReference)propMap.get(property);
            result = ref != null && ref.get() != null;
        }
        return result;
    }

    public boolean hasInCascadedProperties(LogicUnparseInterface value, String property, CascadedPropertyChangeSupport support) {
        return support != null && this.getFromCascadedProperties(value, property) == support;
    }

    public Iterator iteratorOfCascadedProperties(LogicUnparseInterface value) {
        Map propMap;
        if (value != null && this.cascadedProperties != null && (propMap = (Map)this.cascadedProperties.get(value)) != null) {
            return new WeakKey.ReferenceIterator(propMap.values().iterator());
        }
        return FEmptyIterator.get();
    }

    public Iterator keysOfCascadedProperties(LogicUnparseInterface value) {
        Map propMap;
        if (value != null && this.cascadedProperties != null && (propMap = (Map)this.cascadedProperties.get(value)) != null) {
            return new WeakKey.ReferenceIterator(propMap.keySet().iterator());
        }
        return FEmptyIterator.get();
    }

    public Iterator entriesOfCascadedProperties(LogicUnparseInterface value) {
        Map propMap;
        if (value != null && this.cascadedProperties != null && (propMap = (Map)this.cascadedProperties.get(value)) != null) {
            return new WeakKey.ReferenceIterator(propMap.entrySet().iterator());
        }
        return FEmptyIterator.get();
    }

    public CascadedPropertyChangeSupport getFromCascadedProperties(LogicUnparseInterface value, String prop) {
        WeakReference ref;
        Map propMap;
        CascadedPropertyChangeSupport result = null;
        if (value != null && prop != null && this.cascadedProperties != null && (propMap = (Map)this.cascadedProperties.get(value)) != null && (ref = (WeakReference)propMap.get(prop)) != null) {
            result = (CascadedPropertyChangeSupport)ref.get();
        }
        return result;
    }

    protected boolean removeKeyFromCascadedProperties(LogicUnparseInterface value, String prop) {
        WeakReference ref;
        Map propMap;
        boolean changed = false;
        if (value != null && prop != null && this.cascadedProperties != null && (propMap = (Map)this.cascadedProperties.get(value)) != null && (ref = (WeakReference)propMap.remove(prop)) != null) {
            CascadedPropertyChangeSupport support = (CascadedPropertyChangeSupport)ref.get();
            boolean bl = changed = support != null;
            if (changed) {
                support.removeYou();
                ref.clear();
            }
            if (propMap.size() == 0) {
                this.cascadedProperties.remove(value);
            }
        }
        return changed;
    }

    protected boolean removeKeyFromCascadedProperties(LogicUnparseInterface value) {
        Map propMap;
        boolean changed = false;
        if (value != null && this.cascadedProperties != null && (propMap = (Map)this.cascadedProperties.remove(value)) != null && propMap.size() > 0) {
            Iterator iter = propMap.values().iterator();
            while (iter.hasNext()) {
                boolean tmpChanged;
                WeakReference ref = (WeakReference)iter.next();
                CascadedPropertyChangeSupport support = (CascadedPropertyChangeSupport)ref.get();
                boolean bl = tmpChanged = support != null;
                if (!tmpChanged) continue;
                changed = true;
                support.removeYou();
                ref.clear();
            }
            propMap.clear();
        }
        return changed;
    }

    private void clearDeferredUnparseTargetsGCQueue() {
        if (this.deferredUnparseTargetsGCQueue != null) {
            WeakKey value = (WeakKey)this.deferredUnparseTargetsGCQueue.poll();
            while (value != null) {
                Set set = value.getSet();
                if (set != null) {
                    set.remove(value);
                    if (set.size() == 0) {
                        this.deferredUnparseTargets.values().remove(set);
                    }
                }
                value = (WeakKey)this.deferredUnparseTargetsGCQueue.poll();
            }
        }
    }

    protected boolean addToDeferredUnparseTargets(LogicUnparseInterface incr, FSAObject target) {
        boolean changed = false;
        this.clearDeferredUnparseTargetsGCQueue();
        if (incr != null && target != null) {
            HashSet<WeakKey> set;
            if (this.deferredUnparseTargets == null) {
                this.deferredUnparseTargets = new WeakHashMap();
                this.deferredUnparseTargetsGCQueue = new ReferenceQueue();
            }
            if ((set = (HashSet<WeakKey>)this.deferredUnparseTargets.get(incr)) == null) {
                set = new HashSet<WeakKey>();
                this.deferredUnparseTargets.put(incr, set);
            }
            changed = set.add(WeakKey.create(target, set, this.deferredUnparseTargetsGCQueue));
        }
        return changed;
    }

    public boolean hasKeyInDeferredUnparseTargets(LogicUnparseInterface value) {
        return this.deferredUnparseTargets != null && value != null && this.deferredUnparseTargets.get(value) != null;
    }

    public boolean hasInDeferredUnparseTargets(LogicUnparseInterface incr, FSAObject target) {
        Set set;
        boolean result = false;
        if (this.deferredUnparseTargets != null && incr != null && target != null && (set = (Set)this.deferredUnparseTargets.get(incr)) != null) {
            result = set.contains(target);
        }
        return result;
    }

    public Iterator iteratorOfDeferredUnparseTargets(LogicUnparseInterface value) {
        Set set;
        if (this.deferredUnparseTargets != null && value != null && (set = (Set)this.deferredUnparseTargets.get(value)) != null) {
            return new WeakKey.ReferenceIterator(set.iterator());
        }
        return FEmptyIterator.get();
    }

    public Iterator keysOfDeferredUnparseTargets() {
        if (this.deferredUnparseTargets != null) {
            return new WeakKey.ReferenceIterator(this.deferredUnparseTargets.keySet().iterator());
        }
        return FEmptyIterator.get();
    }

    protected boolean removeKeyFromDeferredUnparseTargets(LogicUnparseInterface value) {
        Set old;
        boolean changed = false;
        this.clearDeferredUnparseTargetsGCQueue();
        if (this.deferredUnparseTargets != null && value != null && (old = (Set)this.deferredUnparseTargets.remove(value)) != null && old.size() > 0) {
            old.clear();
            changed = true;
        }
        this.clearDeferredUnparseTargetsGCQueue();
        return changed;
    }

    protected boolean removeFromDeferredUnparseTargets(LogicUnparseInterface incr, FSAObject target) {
        Set set;
        boolean changed = false;
        this.clearDeferredUnparseTargetsGCQueue();
        if (this.deferredUnparseTargets != null && incr != null && target != null && (set = (Set)this.deferredUnparseTargets.get(incr)) != null && (changed = set.remove(target)) && set.size() == 0) {
            this.deferredUnparseTargets.remove(incr);
        }
        this.clearDeferredUnparseTargetsGCQueue();
        return changed;
    }

    protected boolean removeFromDeferredUnparseTargets(FSAObject target) {
        boolean changed = false;
        this.clearDeferredUnparseTargetsGCQueue();
        if (this.deferredUnparseTargets != null && target != null) {
            Iterator iter = this.deferredUnparseTargets.keySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Set set = (Set)entry.getValue();
                boolean tmpChanged = set.remove(target);
                if (!tmpChanged) continue;
                changed = true;
                if (set.size() != 0) continue;
                iter.remove();
            }
        }
        this.clearDeferredUnparseTargetsGCQueue();
        return changed;
    }

    protected void removeAllFromDeferredUnparseTargets() {
        if (this.deferredUnparseTargets != null && this.deferredUnparseTargets.size() > 0) {
            this.deferredUnparseTargets.clear();
        }
        this.clearDeferredUnparseTargetsGCQueue();
    }

    private class ConsistencyPCL
    implements PropertyChangeListener {
        ConsistencyPCL() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean updateConsistency(LogicUnparseInterface iface) {
            boolean result = UnparseManager.this.isConsistent(iface);
            if (!result) return result;
            try {
                Iterator iter = UnparseManager.this.iteratorOfDeferredUnparseTargets(iface);
                while (iter.hasNext()) {
                    FSAObject target = (FSAObject)iter.next();
                    UnparseManager.this.unparseImpl(iface, target);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                UnparseManager.this.unobserveConsistency(iface);
                throw throwable;
            }
            {
                Object var5_7 = null;
                UnparseManager.this.unobserveConsistency(iface);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent pe) {
            Object newValue = pe.getNewValue();
            if (newValue instanceof LogicUnparseInterface) {
                Object source = pe.getSource();
                LogicUnparseInterface iface = (LogicUnparseInterface)source;
                UnparseManager unparseManager = UnparseManager.this;
                synchronized (unparseManager) {
                    this.updateConsistency(iface);
                }
            }
        }
    }
}

