/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.unparse;

import de.uni_paderborn.fujaba.fsa.FSAContainer;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.unparse.UnparseInterface;
import de.uni_paderborn.fujaba.fsa.unparse.UnparseManager;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.FTreeMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.JComponent;

public class FSAInterface
implements PropertyChangeListener {
    private boolean unparse = true;
    private LogicUnparseInterface logic = null;
    private transient FTreeMap fsaObjects = null;
    private boolean consistent = true;
    private FHashSet dependent;
    private FHashSet dependsOn;

    public FSAInterface(LogicUnparseInterface logic) {
        this.logic = logic;
        if (logic == null) {
            throw new IllegalArgumentException("Argument must not be null!");
        }
    }

    public LogicUnparseInterface getLogic() {
        return this.logic;
    }

    public void removeYou() {
        this.removeAllFromFsaObjects();
        this.logic = null;
    }

    public void setUnparse(boolean unparse) {
        this.unparse = unparse;
    }

    public boolean isUnparse() {
        return this.unparse;
    }

    public void propertyChange(PropertyChangeEvent e) {
        UnparseManager.get().propertyChange(this, e);
    }

    public void addToFsaObjects(FSAObject elem) {
        String qualifiedName;
        if (elem != null && (qualifiedName = elem.getQualifiedName()) != null && (this.fsaObjects == null || this.fsaObjects.isEmpty() || !this.fsaObjects.containsValue(elem))) {
            if (this.fsaObjects == null) {
                this.fsaObjects = new FTreeMap();
            }
            if (this.fsaObjects.containsKey(qualifiedName)) {
                this.removeKeyFromFsaObjects(qualifiedName);
            }
            this.fsaObjects.put(qualifiedName, elem);
            elem.setFSAInterface(this);
        }
    }

    public String getKeyFromFsaObjects(FSAObject elem) {
        FSAObject tmpObj;
        String qualifiedName = null;
        if (elem != null && this.sizeOfFsaObjects() > 0 && ((tmpObj = this.getFromFsaObjects(qualifiedName = elem.getQualifiedName())) == null || tmpObj != elem)) {
            qualifiedName = null;
        }
        return qualifiedName;
    }

    public FSAObject getFromFsaObjects(String qualifiedName) {
        FSAObject tmpFSAObject = null;
        if (this.fsaObjects != null) {
            tmpFSAObject = (FSAObject)this.fsaObjects.get(qualifiedName);
        }
        return tmpFSAObject;
    }

    public int sizeOfFsaObjects() {
        return this.fsaObjects != null ? this.fsaObjects.size() : 0;
    }

    public boolean hasInFsaObjects(FSAObject elem) {
        return this.fsaObjects != null && elem != null && !this.fsaObjects.isEmpty() && this.fsaObjects.containsValue(elem);
    }

    public boolean hasKeyInFsaObjects(String qualifiedName) {
        return this.fsaObjects != null && qualifiedName != null && this.fsaObjects.containsKey(qualifiedName);
    }

    public Iterator iteratorOfFsaObjects() {
        return this.fsaObjects == null ? FEmptyIterator.get() : this.fsaObjects.values().iterator();
    }

    public Iterator keysOfFsaObjects() {
        return this.fsaObjects == null ? FEmptyIterator.get() : this.fsaObjects.keySet().iterator();
    }

    public Iterator entriesOfFsaObjects() {
        return this.fsaObjects == null ? FEmptyIterator.get() : this.fsaObjects.entrySet().iterator();
    }

    public void removeFromFsaObjects(FSAObject elem) {
        if (elem != null && this.fsaObjects != null && !this.fsaObjects.isEmpty() && this.fsaObjects.containsValue(elem)) {
            this.fsaObjects.removeValue(elem);
            elem.removeYou();
        }
    }

    public void removeKeyFromFsaObjects(String qualifiedName) {
        if (qualifiedName != null && this.fsaObjects != null && !this.fsaObjects.isEmpty() && this.fsaObjects.containsKey(qualifiedName)) {
            FSAObject removedFSAObject = (FSAObject)this.fsaObjects.remove(qualifiedName);
            removedFSAObject.removeYou();
        }
    }

    public void removeAllFromFsaObjects() {
        if (this.fsaObjects != null && !this.fsaObjects.isEmpty()) {
            Iterator iter = this.iteratorOfFsaObjects();
            while (iter.hasNext()) {
                FSAObject tmpFSAObject = (FSAObject)iter.next();
                String key = tmpFSAObject.getQualifiedName();
                this.removeKeyFromFsaObjects(key);
            }
        }
    }

    public void updateKeyInFsaObjects(String oldKey, FSAObject object) {
        FSAObject oldObject;
        if (oldKey != null && object != null && object.getFSAInterface() == this && this.fsaObjects != null && (oldObject = (FSAObject)this.fsaObjects.get(oldKey)) == object) {
            this.fsaObjects.remove(oldKey);
            this.fsaObjects.put(object.getQualifiedName(), object);
        }
    }

    public boolean hasEntryInFsaObjects(String qualifiedName, FSAObject elem) {
        return qualifiedName != null && elem != null && this.getFromFsaObjects(qualifiedName) == elem;
    }

    public boolean isFsaObjectsEmpty() {
        return this.sizeOfFsaObjects() == 0;
    }

    public Iterator iteratorOfFsaObjects(String property) {
        return this.isFsaObjectsEmpty() ? FEmptyIterator.get() : new FsaPropertyIterator(this.iteratorOfFsaObjects(), property);
    }

    public Iterator iteratorOfFsaObjects(FSAObject parent) {
        return this.isFsaObjectsEmpty() ? FEmptyIterator.get() : new FsaParentIterator(this.iteratorOfFsaObjects(), parent);
    }

    public void removePropertyFromFsaObjects(String propertyName) {
        Iterator propIter = this.iteratorOfFsaObjects(propertyName);
        while (propIter.hasNext()) {
            String qualifiedName = ((FSAObject)propIter.next()).getQualifiedName();
            this.removeKeyFromFsaObjects(qualifiedName);
        }
    }

    public UnparseInterface getUnparseModule() {
        return UnparseManager.get().getUnparseModule(this.getLogic());
    }

    public String getMainFsaName() {
        return this.getUnparseModule().getMainFsaName();
    }

    public FSAObject getMainFsaFromFsaObjects(FSAObject parent) {
        UnparseInterface unparseModule = UnparseManager.get().getUnparseModule(this.getLogic());
        if (unparseModule != null) {
            return this.getFromFsaObjects(parent, unparseModule.getMainFsaName());
        }
        return null;
    }

    public FSAObject getFromFsaObjects(FSAObject parent, String property) {
        return this.getFromFsaObjects(FSAObject.getQualifiedName(parent, property));
    }

    public FSAObject getFirstFromFsaObjects() {
        Iterator iter;
        FSAObject temp = null;
        if (this.fsaObjects != null && (iter = this.iteratorOfFsaObjects()).hasNext()) {
            temp = (FSAObject)iter.next();
        }
        return temp;
    }

    public FSAObject getFirstFromFsaObjects(String property) {
        Iterator iter;
        FSAObject temp = null;
        if (this.fsaObjects != null && (iter = this.iteratorOfFsaObjects(property)).hasNext()) {
            temp = (FSAObject)iter.next();
        }
        return temp;
    }

    public static JComponent getJComponent(FSAObject object) {
        JComponent comp = null;
        if (object != null) {
            comp = object.getJComponent();
        }
        return comp;
    }

    public boolean isConsistent() {
        if (this.consistent) {
            UnparseManager.get().isConsistent(this.getLogic());
        }
        return this.consistent;
    }

    protected void setConsistent(boolean newConsistent) {
        if (this.consistent != newConsistent) {
            this.consistent = newConsistent;
        }
    }

    public boolean hasInDependent(FSAInterface value) {
        return this.dependent != null && value != null && this.dependent.contains(value);
    }

    public Iterator iteratorOfDependent() {
        return this.dependent == null ? FEmptyIterator.get() : new ReadOnlyIterator(this.dependent.iterator());
    }

    public int sizeOfDependent() {
        return this.dependent == null ? 0 : this.dependent.size();
    }

    protected boolean addToDependent(FSAInterface value) {
        boolean changed = false;
        if (value != null) {
            if (this.dependent == null) {
                this.dependent = new FHashSet();
            }
            if (changed = this.dependent.add(value)) {
                value.addToDependsOn(this);
            }
        }
        return changed;
    }

    protected boolean removeFromDependent(FSAInterface value) {
        boolean changed = false;
        if (this.dependent != null && value != null && (changed = this.dependent.remove(value))) {
            value.removeFromDependsOn(this);
        }
        return changed;
    }

    protected void removeAllFromDependent() {
        Iterator iter = this.iteratorOfDependent();
        while (iter.hasNext()) {
            FSAInterface tmpValue = (FSAInterface)iter.next();
            this.removeFromDependent(tmpValue);
        }
    }

    public boolean hasInDependsOn(FSAInterface value) {
        return this.dependsOn != null && value != null && this.dependsOn.contains(value);
    }

    public Iterator iteratorOfDependsOn() {
        return this.dependsOn == null ? FEmptyIterator.get() : new ReadOnlyIterator(this.dependsOn.iterator());
    }

    public int sizeOfDependsOn() {
        return this.dependsOn == null ? 0 : this.dependsOn.size();
    }

    protected boolean addToDependsOn(FSAInterface value) {
        boolean changed = false;
        if (value != null) {
            if (this.dependsOn == null) {
                this.dependsOn = new FHashSet();
            }
            if (changed = this.dependsOn.add(value)) {
                value.addToDependent(this);
            }
        }
        return changed;
    }

    protected boolean removeFromDependsOn(FSAInterface value) {
        boolean changed = false;
        if (this.dependsOn != null && value != null && (changed = this.dependsOn.remove(value))) {
            value.removeFromDependent(this);
        }
        return changed;
    }

    protected void removeAllFromDependsOn() {
        Iterator iter = this.iteratorOfDependsOn();
        while (iter.hasNext()) {
            FSAInterface tmpValue = (FSAInterface)iter.next();
            this.removeFromDependsOn(tmpValue);
        }
    }

    private static class FsaPropertyIterator
    implements Iterator {
        private String property = null;
        private Iterator iterator = null;
        private Object element = null;
        private byte moreElements = (byte)-1;

        FsaPropertyIterator(Iterator iterator, String property) {
            this.iterator = iterator;
            this.property = property;
        }

        public boolean hasNext() {
            if (this.moreElements == -1) {
                this.fetch();
            }
            return this.moreElements == 1;
        }

        public Object next() {
            if (this.moreElements == -1) {
                this.fetch();
            }
            if (this.moreElements == 1) {
                this.moreElements = (byte)-1;
                return this.element;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.moreElements != 1) {
                throw new IllegalStateException();
            }
            this.iterator.remove();
        }

        private void fetch() {
            while (this.iterator.hasNext()) {
                Object object = this.iterator.next();
                if (!(object instanceof FSAObject)) continue;
                FSAObject fsa = (FSAObject)object;
                String fsaProp = fsa.getPropertyName();
                if ((this.property != null || fsaProp != null) && (this.property == null || !this.property.equals(fsaProp))) continue;
                this.element = fsa;
                this.moreElements = 1;
                return;
            }
            this.moreElements = 0;
            this.element = null;
        }
    }

    private static class FsaParentIterator
    implements Iterator {
        private FSAObject parent = null;
        private Iterator iterator = null;
        private Object element = null;
        private byte moreElements = (byte)-1;

        FsaParentIterator(Iterator iterator, FSAObject parent) {
            this.iterator = iterator;
            this.parent = parent;
        }

        public boolean hasNext() {
            if (this.moreElements == -1) {
                this.fetch();
            }
            return this.moreElements == 1;
        }

        public Object next() {
            if (this.moreElements == -1) {
                this.fetch();
            }
            if (this.moreElements == 1) {
                this.moreElements = (byte)-1;
                return this.element;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.moreElements != 1) {
                throw new IllegalStateException();
            }
            this.iterator.remove();
        }

        private void fetch() {
            while (this.iterator.hasNext()) {
                FSAObject fsa;
                FSAContainer parent;
                Object object = this.iterator.next();
                if (!(object instanceof FSAObject) || this.parent != (parent = (fsa = (FSAObject)object).getParent())) continue;
                this.element = fsa;
                this.moreElements = 1;
                return;
            }
            this.moreElements = 0;
            this.element = null;
        }
    }

    private static class ReadOnlyIterator
    implements Iterator {
        private final Iterator iterator;

        public ReadOnlyIterator(Iterator iter) {
            this.iterator = iter;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("Only Read-Operations allowed!");
        }
    }
}

