/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import de.uni_paderborn.fujaba.basic.FontContainer;
import de.uni_paderborn.fujaba.fsa.swing.border.AbstractColorBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;

public class TextBorder
extends AbstractColorBorder {
    private String upperLeftText;
    private Color upperLeftColor;
    private String lowerLeftText;
    private Color lowerLeftColor;
    private String upperRightText;
    private Color upperRightColor;
    private String lowerRightText;
    private Color lowerRightColor;
    private Font font = FontContainer.getDefaultFont();

    public TextBorder(Color aColor) {
        super(aColor);
        this.setUpperLeftColor(aColor);
        this.setLowerLeftColor(aColor);
        this.setUpperRightColor(aColor);
        this.setLowerRightColor(aColor);
    }

    public TextBorder(Color aColor, String upperLeftText) {
        this(aColor);
        this.setUpperLeftText(upperLeftText);
    }

    public String getLowerLeftText() {
        return this.lowerLeftText;
    }

    public Color getLowerLeftColor() {
        return this.lowerLeftColor;
    }

    public String getLowerRightText() {
        return this.lowerRightText;
    }

    public Color getLowerRightColor() {
        return this.lowerRightColor;
    }

    public String getUpperLeftText() {
        return this.upperLeftText;
    }

    public Color getUpperLeftColor() {
        return this.upperLeftColor;
    }

    public String getUpperRightText() {
        return this.upperRightText;
    }

    public Color getUpperRightColor() {
        return this.upperRightColor;
    }

    public void setLowerLeftText(String lowerLeftText) {
        this.lowerLeftText = lowerLeftText;
    }

    public void setLowerLeftColor(Color lowerLeftColor) {
        this.lowerLeftColor = lowerLeftColor;
    }

    public void setLowerRightText(String lowerRightText) {
        this.lowerRightText = lowerRightText;
    }

    public void setLowerRightColor(Color lowerRightColor) {
        this.lowerRightColor = lowerRightColor;
    }

    public void setUpperLeftText(String upperLeftText) {
        this.upperLeftText = upperLeftText;
    }

    public void setUpperLeftColor(Color upperLeftColor) {
        this.upperLeftColor = upperLeftColor;
    }

    public void setUpperRightText(String upperRightText) {
        this.upperRightText = upperRightText;
    }

    public void setUpperRightColor(Color upperRightColor) {
        this.upperRightColor = upperRightColor;
    }

    public Insets getBorderInsets(Component c) {
        int top = 0;
        int bottom = 0;
        if (this.upperLeftText != null || this.upperRightText != null) {
            top = 13;
        }
        if (this.lowerLeftText != null || this.lowerRightText != null) {
            bottom = 8;
        }
        return new Insets(top, 0, bottom, 0);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets = this.getBorderInsets(c);
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int ty;
        int tx;
        Rectangle2D textsize;
        Color oldColor = g.getColor();
        Font oldFont = g.getFont();
        g.setFont(this.getFont());
        g.setColor(this.getUpperLeftColor());
        this.upperLeftText = this.getUpperLeftText();
        if (this.upperLeftText != null) {
            textsize = g.getFontMetrics().getStringBounds(this.upperLeftText, g);
            tx = x;
            ty = y + (int)Math.ceil(textsize.getHeight());
            g.drawString(this.upperLeftText, tx, ty);
        }
        g.setColor(this.getUpperRightColor());
        this.upperRightText = this.getUpperRightText();
        if (this.upperRightText != null) {
            textsize = g.getFontMetrics().getStringBounds(this.upperRightText, g);
            tx = x + width - (int)Math.ceil(textsize.getWidth());
            ty = y + (int)Math.ceil(textsize.getHeight());
            g.drawString(this.upperRightText, tx, ty);
        }
        g.setColor(this.getLowerLeftColor());
        this.lowerLeftText = this.getLowerLeftText();
        if (this.lowerLeftText != null) {
            textsize = g.getFontMetrics().getStringBounds(this.lowerLeftText, g);
            tx = x;
            ty = y + height;
            g.drawString(this.lowerLeftText, tx, ty);
        }
        g.setColor(this.getLowerRightColor());
        this.lowerRightText = this.getLowerRightText();
        if (this.lowerRightText != null) {
            textsize = g.getFontMetrics().getStringBounds(this.lowerRightText, g);
            tx = x + width - (int)Math.ceil(textsize.getWidth());
            ty = y + height;
            g.drawString(this.lowerRightText, tx, ty);
        }
        g.setColor(oldColor);
        g.setFont(oldFont);
    }
}

