/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.swing.border.AbstractColorBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

public class SignalBorder
extends AbstractColorBorder {
    public static final int OUT = 1;
    public static final int IN = 2;
    public static final int SAVING = 3;
    private int signalShape;

    public SignalBorder(int shape) {
        this.setSignalShape(shape);
    }

    public int getSignalShape() {
        return this.signalShape;
    }

    public void setSignalShape(int shape) {
        this.signalShape = shape;
    }

    public Insets getBorderInsets(Component c) {
        if (this.getSignalShape() != 3) {
            return new Insets(2, 2, 2, 22);
        }
        return new Insets(2, 42, 2, 42);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets = this.getSignalShape() != 3 ? new Insets(2, 2, 2, 22) : new Insets(2, 42, 2, 42);
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(FSAObject.COLOR_FOREGROUND);
        switch (this.getSignalShape()) {
            case 1: {
                g.drawLine(x, y, x + width - 1 - 20, y);
                g.drawLine(x, y + height - 1, x + width - 1 - 20, y + height - 1);
            }
            case 2: {
                g.drawLine(x, y, x + width - 1, y);
                g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            }
            case 3: {
                g.drawLine(x + 40, y, x + width - 1, y);
                g.drawLine(x, y + height - 1, x + width - 1 - 40, y + height - 1);
            }
        }
        if (this.getSignalShape() != 3) {
            g.drawLine(x, y, x, y + height - 1);
        } else {
            g.drawLine(x, y + height - 1, x + 40, y);
        }
        switch (this.getSignalShape()) {
            case 1: {
                g.drawLine(x + width - 1 - 20, y, x + width - 1, y + height / 2);
                g.drawLine(x + width - 1, y + height / 2, x + width - 1 - 20, y + height - 1);
            }
            case 2: {
                g.drawLine(x + width - 1, y, x + width - 1 - 20, y + height / 2);
                g.drawLine(x + width - 1 - 20, y + height / 2, x + width - 1, y + height - 1);
            }
            case 3: {
                g.drawLine(x + width - 1, y, x + width - 1 - 40, y + height);
            }
        }
        g.setColor(oldColor);
    }
}

