/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import de.uni_paderborn.fujaba.fsa.swing.LineStyle;
import de.uni_paderborn.fujaba.fsa.swing.border.AbstractColorBorder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;

public class SetBorder
extends AbstractColorBorder {
    private Stroke stroke = LineStyle.DASHED;
    private int thickness = 1;

    public SetBorder(Color aColor) {
        this.setBorderColor(aColor);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(11, 0, 0, 11);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets = new Insets(11, 0, 0, 11);
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setThickness(int newThickness) {
        BasicStroke stroke;
        this.thickness = newThickness;
        if (this.thickness < 0) {
            this.thickness = 0;
        }
        if (this.getStroke() != null) {
            BasicStroke defaultStroke = (BasicStroke)this.getStroke();
            stroke = new BasicStroke(this.thickness, defaultStroke.getEndCap(), defaultStroke.getLineJoin(), defaultStroke.getMiterLimit(), defaultStroke.getDashArray(), defaultStroke.getDashPhase());
        } else {
            stroke = new BasicStroke(this.thickness);
        }
        this.setStroke(stroke);
    }

    public int getThickness() {
        return this.thickness;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.getBorderColor());
        Graphics2D g2d = (Graphics2D)g;
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(this.getStroke());
        g.drawLine(x, y + 10, x, y + height - 1);
        g.drawLine(x, y + height - 1, x + width - 10 - 1, y + height - 1);
        g.drawLine(x, y + 10, x + width - 10 - 1, y + 10);
        g.drawLine(x + width - 10 - 1, y + 10, x + width - 10 - 1, y + height - 1);
        g.drawLine(x + 10, y, x + width - 1, y);
        g.drawLine(x + 10, y, x + 10, y + 10);
        g.drawLine(x + width - 1, y, x + width - 1, y + height - 10 - 1);
        g.drawLine(x + width - 10 - 1, y + height - 10 - 1, x + width - 1, y + height - 10 - 1);
        g.setColor(oldColor);
        g2d.setStroke(oldStroke);
    }
}

