/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.swing.border.AbstractColorBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

public class RhombBorder
extends AbstractColorBorder {
    public RhombBorder(Color aColor) {
        this.setBorderColor(aColor);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(33, 33, 33, 33);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets = this.getBorderInsets(c);
        return insets;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.getBorderColor());
        int[] newX = new int[5];
        int[] newY = new int[5];
        newX[0] = x;
        newX[1] = x + width / 2;
        newX[2] = x + width - 1;
        newX[3] = x + width / 2 - 1;
        newX[4] = x;
        newY[0] = y + height / 2;
        newY[1] = y;
        newY[2] = y + width / 2 - 1;
        newY[3] = y + height - 1;
        newY[4] = y + height / 2;
        g.setColor(FSAObject.COLOR_BACKGROUND);
        g.fillPolygon(newX, newY, 5);
        g.setColor(this.getBorderColor());
        g.drawPolyline(newX, newY, 5);
        g.setColor(oldColor);
    }
}

