/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing.border;

import de.uni_paderborn.fujaba.fsa.swing.LineStyle;
import de.uni_paderborn.fujaba.fsa.swing.border.AbstractColorBorder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;

public class OvalBorder
extends AbstractColorBorder {
    private boolean opaqueFlag;
    private Stroke stroke = null;
    private boolean dashedFlag;
    private int thickness = 1;
    private boolean doubleOval = false;

    public OvalBorder() {
    }

    public OvalBorder(boolean opaque, Stroke stroke) {
        this.setBorderOpaque(opaque);
        this.setStroke(stroke);
    }

    public OvalBorder(boolean opaque) {
        this.setBorderOpaque(opaque);
    }

    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, null);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        int insetLeft;
        int insetTop;
        Dimension size = c.getSize();
        int w = (int)size.getWidth() / 2 - 1;
        int h = (int)size.getHeight() / 2 - 1;
        int xradius = new Double((double)w * 1.4142135624).intValue();
        int yradius = new Double((double)h * 1.4142135624).intValue();
        int insetBottom = insetTop = yradius - h + (this.getThickness() - 1);
        int insetRight = insetLeft = xradius - w + (this.getThickness() - 1);
        if (this.doubleOval) {
            insetTop += 10 + (this.getThickness() - 1);
            insetRight += 10 + (this.getThickness() - 1);
        }
        if (insets == null) {
            insets = new Insets(insetTop, insetLeft, insetBottom, insetRight);
        } else {
            insets.top = insetTop;
            insets.left = insetLeft;
            insets.bottom = insetBottom;
            insets.right = insetRight;
        }
        return insets;
    }

    public void setBorderOpaque(boolean opaque) {
        this.opaqueFlag = opaque;
    }

    public boolean isBorderOpaque() {
        return this.opaqueFlag;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setBorderDashed(boolean dashed) {
        this.dashedFlag = dashed;
        if (dashed) {
            BasicStroke defaultStroke = LineStyle.DASHED;
            BasicStroke stroke = new BasicStroke(this.thickness, defaultStroke.getEndCap(), defaultStroke.getLineJoin(), defaultStroke.getMiterLimit(), defaultStroke.getDashArray(), defaultStroke.getDashPhase());
            this.setStroke(stroke);
        } else {
            this.setStroke(new BasicStroke(this.thickness));
        }
    }

    public boolean isBorderDashed() {
        return this.dashedFlag;
    }

    public void setThickness(int newThickness) {
        BasicStroke stroke;
        this.thickness = newThickness;
        if (this.thickness < 0) {
            this.thickness = 0;
        }
        if (this.getStroke() != null) {
            BasicStroke defaultStroke = (BasicStroke)this.getStroke();
            stroke = new BasicStroke(this.thickness, defaultStroke.getEndCap(), defaultStroke.getLineJoin(), defaultStroke.getMiterLimit(), defaultStroke.getDashArray(), defaultStroke.getDashPhase());
        } else {
            stroke = new BasicStroke(this.thickness);
        }
        this.setStroke(stroke);
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setDoubleOval(boolean value) {
        this.doubleOval = value;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        if (this.isBorderOpaque()) {
            g.setColor(c.getBackground());
            g.fillArc(x, y, width - 1, height - 1, 0, 360);
        }
        Stroke oldStroke = null;
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            oldStroke = g2d.getStroke();
            if (this.getStroke() != null) {
                g2d.setStroke(this.getStroke());
            }
        }
        g.setColor(this.getBorderColor());
        int thicknessOffset = this.thickness / 2;
        if (this.doubleOval) {
            g.drawArc(x + thicknessOffset + 10, y + thicknessOffset, width - 1 - thicknessOffset - 10, height - 1 - thicknessOffset - 10, 0, 360);
            g.setColor(c.getBackground());
            g.fillArc(x + thicknessOffset, y + thicknessOffset + 10, width - 1 - thicknessOffset - 10, height - 1 - thicknessOffset - 10, 0, 360);
            g.setColor(this.getBorderColor());
            g.drawArc(x + thicknessOffset, y + thicknessOffset + 10, width - 1 - thicknessOffset - 10, height - 1 - thicknessOffset - 10, 0, 360);
        } else {
            g.drawArc(x + thicknessOffset, y + thicknessOffset, width - 1 - thicknessOffset, height - 1 - thicknessOffset, 0, 360);
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(oldStroke);
        }
        g.setColor(oldColor);
    }
}

