/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.metamodel.FType;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.uni_paderborn.fujaba.uml.UMLTypeList;
import de.upb.tools.pcs.CollectionChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class UMLTypeListComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
PropertyChangeListener {
    private static UMLTypeListComboBoxModel singleton = null;
    private UMLProject theProject = UMLProject.get();
    private Vector types = null;
    private Object selectedItem = null;

    public static UMLTypeListComboBoxModel get() {
        if (singleton == null || UMLTypeListComboBoxModel.singleton.theProject == null) {
            singleton = new UMLTypeListComboBoxModel();
        }
        return singleton;
    }

    private UMLTypeListComboBoxModel() {
        this.theProject.addPropertyChangeListener("typeList", this);
        this.theProject.addPropertyChangeListener("removeYou", this);
        UMLTypeList umlTypeList = this.theProject.getTypeList();
        umlTypeList.addPropertyChangeListener("types", this);
        this.addAll(umlTypeList);
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(Object value) {
        if (this.selectedItem != value) {
            if (value instanceof String) {
                value = UMLProject.get().getTypeList().getFromTypes((String)value);
            }
            this.selectedItem = (FType)value;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public Object getElementAt(int index) {
        if (index == -1) {
            return this.getSelectedItem();
        }
        return this.types != null ? this.types.elementAt(index) : null;
    }

    public int getSize() {
        return this.types != null ? this.types.size() : 0;
    }

    public String toString() {
        return "UMLTypeListComboBoxModel";
    }

    private synchronized void sortIn(UMLType type) {
        if (this.types == null) {
            this.types = new Vector();
        }
        String name = type.getName();
        int size = this.types.size();
        int upper = size - 1;
        int lower = 0;
        int order = 0;
        UMLType tmpType = null;
        while (lower < upper) {
            int center = (upper + lower) / 2;
            tmpType = (UMLType)this.types.get(center);
            order = name.compareTo(tmpType.getName());
            if (order < 0) {
                upper = center - 1;
                continue;
            }
            if (order == 0) {
                upper = lower = center;
                continue;
            }
            lower = center + 1;
        }
        if (upper == -1) {
            this.types.add(0, type);
            this.fireIntervalAdded(this, 0, 0);
        } else if (order == 0) {
            this.types.add(lower, type);
            this.fireIntervalAdded(this, lower, lower);
        } else {
            tmpType = (UMLType)this.types.get(lower);
            order = name.compareTo(tmpType.getName());
            if (order <= 0) {
                this.types.add(lower, type);
                this.fireIntervalAdded(this, lower, lower);
            } else {
                this.types.add(lower + 1, type);
                this.fireIntervalAdded(this, lower + 1, lower + 1);
            }
        }
    }

    private void addAll(UMLTypeList umlTypeList) {
        Iterator iter = umlTypeList.iteratorOfTypes();
        while (iter.hasNext()) {
            UMLType tmpType = (UMLType)iter.next();
            tmpType.addPropertyChangeListener("name", this);
            this.sortIn(tmpType);
        }
    }

    private synchronized void remove(FType type) {
        int index;
        if (this.types != null && (index = this.types.indexOf(type)) > -1) {
            this.types.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    private synchronized void removeAll() {
        if (this.types != null) {
            this.types.clear();
            this.fireIntervalRemoved(this, 0, 0);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("removeYou".equals(event.getPropertyName()) && event.getSource() instanceof UMLProject) {
            this.theProject = null;
        } else if ("typeList".equals(event.getPropertyName()) && event.getSource() instanceof UMLProject) {
            UMLTypeList newTypeList;
            UMLTypeList oldTypeList = (UMLTypeList)event.getOldValue();
            if (oldTypeList != null) {
                oldTypeList.removePropertyChangeListener(this);
                this.removeAll();
            }
            if ((newTypeList = (UMLTypeList)event.getNewValue()) != null) {
                newTypeList.addPropertyChangeListener("types", this);
                this.addAll(newTypeList);
            }
        } else if ("types".equals(event.getPropertyName()) && event instanceof CollectionChangeEvent) {
            CollectionChangeEvent cce = (CollectionChangeEvent)event;
            switch (cce.getType()) {
                case 1: 
                case 5: 
                case 6: {
                    UMLType umlType = (UMLType)event.getNewValue();
                    umlType.addPropertyChangeListener("name", this);
                    this.sortIn(umlType);
                    break;
                }
                case 2: 
                case 4: {
                    UMLType umlType = (UMLType)event.getOldValue();
                    umlType.removePropertyChangeListener("name", this);
                    this.remove(umlType);
                }
            }
        } else if ("name".equals(event.getPropertyName()) && event.getSource() instanceof UMLType) {
            UMLType umlType = (UMLType)event.getSource();
            if (this.types == null || !this.types.contains(umlType)) {
                return;
            }
            this.remove(umlType);
            this.sortIn(umlType);
            if (umlType == this.getSelectedItem()) {
                this.fireContentsChanged(this, -1, -1);
            }
        }
    }
}

