/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.listener.AscendDescendMouseHandler;
import de.uni_paderborn.fujaba.fsa.swing.GrabUI;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class TextGrabUI
extends GrabUI {
    private static final String EDITOR = "de.uni_paderborn.fujaba.fsa.swing.TextGrabUI:Editor";
    JBend bend;
    JTextComponent editor;
    private String text;
    private FocusListener editorFocusListener;
    private PropertyChangeListener propertyChangeListener;
    private MouseListener mouseListener;

    public JBend getBend() {
        return this.bend;
    }

    public boolean setBend(JBend bend) {
        if (bend != this.bend) {
            if (this.bend != null) {
                this.bend.setUI(null);
            }
            this.bend = bend;
            if (bend != null && bend.getUI() != this) {
                bend.setUI(this);
            }
            return true;
        }
        return false;
    }

    public JTextComponent getEditor() {
        return this.editor;
    }

    public boolean setEditor(JTextComponent editor) {
        if (editor != this.editor) {
            if (this.editor != null) {
                this.uninstallComponents();
            }
            this.editor = editor;
            if (editor != null) {
                this.configureEditor();
            }
            if (this.bend != null) {
                this.bend.putClientProperty(EDITOR, editor);
                if (editor != null) {
                    this.installComponents();
                }
                this.bend.revalidate();
                this.bend.repaint();
            }
            return true;
        }
        return false;
    }

    public String getText() {
        return this.text;
    }

    public boolean setText(String text) {
        if (this.text == null && text != null || this.text != null && !this.text.equals(text)) {
            String oldText = this.text;
            this.text = text;
            this.setEditorText(text);
            this.firePropertyChange(this.bend, "text", oldText, text);
            return true;
        }
        return false;
    }

    protected String getEditorText() {
        String text;
        String string = text = this.editor == null ? null : this.editor.getText();
        if (text == null) {
            text = "";
        }
        return text;
    }

    protected void setEditorText(String text) {
        if (this.editor != null) {
            String editorText;
            if (text == null) {
                text = "";
            }
            if (!(editorText = this.getEditorText()).equals(text)) {
                this.editor.setText(text);
                if (this.bend != null) {
                    this.bend.revalidate();
                    this.bend.repaint();
                } else {
                    this.editor.revalidate();
                }
            }
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new TextGrabUI();
    }

    public void installUI(JComponent c) {
        this.setBend((JBend)c);
        this.bend.setLayout(this.createLayoutManager());
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.bend.setRequestFocusEnabled(true);
    }

    public void uninstallUI(JComponent c) {
        this.bend.setLayout(null);
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.mouseListener = null;
        this.editorFocusListener = null;
        this.propertyChangeListener = null;
        this.bend = null;
    }

    protected void installDefaults() {
        this.bend.setOpaque(true);
        this.bend.setForeground(FSAObject.COLOR_FOREGROUND);
        this.bend.setBackground(FSAObject.COLOR_BACKGROUND);
        this.bend.setBorder(new LineBorder(FSAObject.COLOR_FOREGROUND));
        if (this.editor == null) {
            this.setEditor(this.createEditor());
            this.editor.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        this.bend.putClientProperty(EDITOR, this.editor);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.bend.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            AscendDescendMouseHandler.addMouseListener(this.bend, this.mouseListener);
        }
    }

    protected void uninstallDefaults() {
        this.bend.putClientProperty(EDITOR, null);
        this.setEditor(null);
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.bend.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.mouseListener != null) {
            AscendDescendMouseHandler.removeMouseListener(this.bend, this.mouseListener);
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected LayoutManager createLayoutManager() {
        return new BendLayoutManager();
    }

    protected JTextComponent createEditor() {
        if (this.bend.getClientProperty(EDITOR) != null && this.bend.getClientProperty(EDITOR) instanceof JTextComponent) {
            return (JTextComponent)this.bend.getClientProperty(EDITOR);
        }
        return new JTextField();
    }

    void updateToolTipTextForChildren() {
        Component[] children = this.bend.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof JComponent) {
                ((JComponent)children[i]).setToolTipText(this.bend.getToolTipText());
            }
            ++i;
        }
    }

    protected void installComponents() {
        if (this.isEditorVisible(this.bend)) {
            this.addEditor();
        } else {
            this.removeEditor();
        }
    }

    protected void uninstallComponents() {
        if (this.editor != null) {
            this.unconfigureEditor();
        }
        this.bend.removeAll();
    }

    public void addEditor() {
        this.removeEditor();
        if (this.editor == null) {
            this.setEditor(this.createEditor());
        }
        this.configureEditor();
        this.bend.add(this.editor);
    }

    public void removeEditor() {
        if (this.editor != null) {
            this.unconfigureEditor();
            this.bend.remove(this.editor);
        }
    }

    protected void configureEditor() {
        this.editor.setFont(this.bend.getFont());
        this.editor.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.editor.setOpaque(this.bend.isOpaque());
        this.editor.setForeground(this.bend.getForeground());
        this.editor.setBackground(this.bend.getBackground());
        this.editor.setText(this.getText());
        this.installKeyboardActions();
        if (this.editorFocusListener == null) {
            this.editorFocusListener = new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    TextGrabUI.this.editor.setText(TextGrabUI.this.getText());
                    TextGrabUI.this.setEditorVisible(TextGrabUI.this.bend, false);
                }
            };
        }
        this.editor.addFocusListener(this.editorFocusListener);
    }

    protected void unconfigureEditor() {
        this.editor.removeFocusListener(this.editorFocusListener);
        this.uninstallKeyboardActions();
    }

    public boolean isEditorVisible(JBend b) {
        return this.editor != null && this.editor.getParent() == b;
    }

    public boolean setEditorVisible(JBend b, boolean v) {
        if (this.isEditorVisible(b) != v) {
            if (v) {
                this.addEditor();
                this.editor.revalidate();
                this.editor.repaint();
                this.editor.requestFocus();
            } else {
                this.removeEditor();
                b.requestFocus();
            }
            this.firePropertyChange(b, "editorVisible", !v, v);
            b.revalidate();
            this.repaintCurrentValue();
            return true;
        }
        return false;
    }

    public boolean isFocusTraversable(JBend c) {
        return !c.isEnabled() || !this.isEditorVisible(c);
    }

    public void paint(Graphics g, JComponent c) {
        if (!this.isEditorVisible((JBend)c)) {
            Rectangle r = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(g, new Rectangle(c.getSize()));
            this.paintCurrentValue(g, r);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        Insets insets = this.getInsets();
        Dimension size = this.getMinimumSize(c);
        size.width = Math.max(size.width, this.editor.getPreferredSize().width + insets.left + insets.right + 4);
        size.height = Math.max(size.height, this.editor.getPreferredSize().height + insets.top + insets.bottom + 4);
        return size;
    }

    public Dimension getMinimumSize(JComponent c) {
        Insets insets = this.getInsets();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        Dimension dim = this.editor.getMinimumSize();
        Rectangle2D charBounds = fm.getMaxCharBounds(null);
        dim.width = Math.max(fm.stringWidth("WWW..."), dim.width);
        dim.height = (int)Math.max(charBounds.getHeight(), (double)dim.height);
        dim.width += insets.left + insets.right + 4;
        dim.height += insets.top + insets.bottom + 4;
        return dim;
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension size = this.getPreferredSize(c);
        size.width = Short.MAX_VALUE;
        return size;
    }

    protected Rectangle rectangleForCurrentValue() {
        int width = this.bend.getWidth();
        int height = this.bend.getHeight();
        Insets insets = this.getInsets();
        return new Rectangle(insets.left + 2, insets.top + 2, width - (insets.left + insets.right) - 4, height - (insets.top + insets.bottom) - 4);
    }

    protected Insets getInsets() {
        return this.bend.getInsets();
    }

    /*
     * Exception decompiling
     */
    public void paintCurrentValue(Graphics g, Rectangle bounds) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 74->78)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds) {
        Color t = g.getColor();
        g.setColor(this.bend.getBackground());
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        g.setColor(t);
    }

    void repaintCurrentValue() {
        Rectangle r = this.rectangleForCurrentValue();
        this.bend.repaint(r.x, r.y, r.width, r.height);
    }

    protected void installKeyboardActions() {
        AbstractAction keyAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if ("cancel".equals(e.getActionCommand())) {
                    TextGrabUI.this.editor.setText(TextGrabUI.this.getText());
                } else {
                    TextGrabUI.this.setText(TextGrabUI.this.editor.getText());
                }
                TextGrabUI.this.setEditorVisible(TextGrabUI.this.bend, false);
                TextGrabUI.this.repaintCurrentValue();
            }
        };
        this.bend.registerKeyboardAction(keyAction, "cancel", KeyStroke.getKeyStroke(27, 0), 1);
        this.bend.registerKeyboardAction(keyAction, "set", KeyStroke.getKeyStroke(10, 0), 1);
        if (this.editor instanceof JTextField) {
            ((JTextField)this.editor).setActionCommand("set");
            ((JTextField)this.editor).addActionListener(keyAction);
        }
    }

    protected void uninstallKeyboardActions() {
        this.bend.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        this.bend.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1 && !TextGrabUI.this.isEditorVisible(TextGrabUI.this.bend)) {
                TextGrabUI.this.setEditorVisible(TextGrabUI.this.bend, true);
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String newText;
            String editorText;
            String propertyName = e.getPropertyName();
            if (propertyName.equals("enabled")) {
                if (TextGrabUI.this.bend.isEnabled()) {
                    if (TextGrabUI.this.editor != null) {
                        TextGrabUI.this.editor.setEnabled(true);
                    }
                } else if (TextGrabUI.this.editor != null) {
                    TextGrabUI.this.editor.setEnabled(false);
                }
                TextGrabUI.this.bend.repaint();
            } else if (propertyName.equals("font")) {
                if (TextGrabUI.this.editor != null) {
                    TextGrabUI.this.editor.setFont(TextGrabUI.this.bend.getFont());
                }
                TextGrabUI.this.bend.revalidate();
                TextGrabUI.this.bend.repaint();
            } else if (propertyName.equals("foreground")) {
                if (TextGrabUI.this.editor != null) {
                    TextGrabUI.this.editor.setForeground(TextGrabUI.this.bend.getForeground());
                }
                TextGrabUI.this.bend.repaint();
            } else if (propertyName.equals("background")) {
                if (TextGrabUI.this.editor != null) {
                    TextGrabUI.this.editor.setBackground(TextGrabUI.this.bend.getBackground());
                }
                TextGrabUI.this.bend.repaint();
            } else if (propertyName.equals("opaque")) {
                if (TextGrabUI.this.editor != null) {
                    TextGrabUI.this.editor.setOpaque(TextGrabUI.this.bend.isOpaque());
                }
                TextGrabUI.this.bend.repaint();
            } else if (propertyName.equals("ToolTipText")) {
                TextGrabUI.this.updateToolTipTextForChildren();
            } else if (propertyName.equals("data") && !(editorText = TextGrabUI.this.getEditorText()).equals(newText = TextGrabUI.this.getText())) {
                TextGrabUI.this.setEditorText(newText);
                TextGrabUI.this.firePropertyChange(TextGrabUI.this.bend, "text", e.getOldValue(), newText);
            }
        }
    }

    public class BendLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        public void layoutContainer(Container parent) {
            if (TextGrabUI.this.editor != null) {
                Rectangle cvb = TextGrabUI.this.rectangleForCurrentValue();
                TextGrabUI.this.editor.setBounds(cvb);
            }
        }
    }
}

