/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class RoleLayout
implements LayoutManager2 {
    private static final int PAD = 3;
    private JComponent cardComponent;
    private JComponent roleComponent;
    private JComponent adornmentComponent;
    private JGrab grab;

    public RoleLayout(JGrab grab, JComponent adornmentComponent, JComponent roleComponent, JComponent cardComponent) {
        this.grab = grab;
        this.adornmentComponent = adornmentComponent;
        this.roleComponent = roleComponent;
        this.cardComponent = cardComponent;
    }

    public boolean setCardComponent(JComponent value) {
        if (this.cardComponent != value) {
            this.cardComponent = value;
            return true;
        }
        return false;
    }

    public JComponent getCardComponent() {
        return this.cardComponent;
    }

    public boolean setRoleComponent(JComponent value) {
        if (this.roleComponent != value) {
            this.roleComponent = value;
            return true;
        }
        return false;
    }

    public JComponent getRoleComponent() {
        return this.roleComponent;
    }

    public boolean setAdornmentComponent(JComponent value) {
        if (this.adornmentComponent != value) {
            this.adornmentComponent = value;
            return true;
        }
        return false;
    }

    public JComponent getAdornmentComponent() {
        return this.adornmentComponent;
    }

    public boolean setGrab(JGrab value) {
        if (this.grab != value) {
            this.grab = value;
            return true;
        }
        return false;
    }

    public JGrab getGrab() {
        return this.grab;
    }

    public Dimension preferredLayoutSize(Container parent) {
        Dimension adornDim = null;
        Dimension roleDim = null;
        Dimension cardDim = null;
        if (this.adornmentComponent != null && this.adornmentComponent.getParent() == parent) {
            adornDim = this.adornmentComponent.getPreferredSize();
        }
        if (this.roleComponent != null && this.roleComponent.isVisible() && this.roleComponent.getParent() == parent) {
            roleDim = this.roleComponent.getPreferredSize();
        }
        if (this.cardComponent != null && this.cardComponent.isVisible() && this.cardComponent.getParent() == parent) {
            cardDim = this.cardComponent.getPreferredSize();
        }
        return this.calculateSize(parent, adornDim, roleDim, cardDim);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension maximumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    protected Dimension calculateSize(Container parent, Dimension adornDim, Dimension roleDim, Dimension cardDim) {
        int cardHeight;
        int cardWidth;
        int roleHeight;
        int roleWidth;
        int adornHeight;
        int adornWidth;
        Dimension result = new Dimension();
        Insets insets = parent.getInsets();
        Direction orient = this.grab.getOrientation();
        if (adornDim == null) {
            adornWidth = 0;
            adornHeight = 0;
        } else {
            adornWidth = adornDim.width;
            adornHeight = adornDim.height;
        }
        if (roleDim == null) {
            roleWidth = 0;
            roleHeight = 0;
        } else {
            roleWidth = roleDim.width;
            roleHeight = roleDim.height;
        }
        if (cardDim == null) {
            cardWidth = 0;
            cardHeight = 0;
        } else {
            cardWidth = cardDim.width;
            cardHeight = cardDim.height;
        }
        if (orient == Direction.TOP) {
            if (roleWidth != 0) {
                roleWidth += 3;
            }
            if (cardWidth != 0) {
                cardWidth += 3;
            }
            if (adornWidth != 0) {
                adornWidth = (int)Math.ceil(adornWidth / 2);
            }
            result.width = Math.max(roleWidth, adornWidth) + Math.max(cardWidth, adornWidth) + insets.left + insets.right;
            result.height = adornHeight + insets.top + insets.bottom;
            if (cardHeight != 0 || roleHeight != 0) {
                result.height += Math.max(roleHeight, cardHeight) + 3;
            }
        } else {
            if (roleHeight != 0) {
                roleHeight += 3;
            }
            if (cardHeight != 0) {
                cardHeight += 3;
            }
            if (adornHeight != 0) {
                adornHeight = (int)Math.ceil(adornHeight / 2);
            }
            result.height = Math.max(roleHeight, adornHeight) + Math.max(cardHeight, adornHeight) + insets.top + insets.bottom;
            result.width = adornWidth + insets.left + insets.right;
            if (cardWidth != 0 || roleWidth != 0) {
                result.width += Math.max(roleWidth, cardWidth) + 3;
            }
        }
        return result;
    }

    public void layoutContainer(Container parent) {
        Rectangle bounds = parent.getBounds();
        Insets insets = parent.getInsets();
        Direction orient = this.grab.getOrientation();
        Dimension adornDim = null;
        Dimension roleDim = null;
        Dimension cardDim = null;
        if (this.adornmentComponent != null && this.adornmentComponent.getParent() == parent) {
            adornDim = this.adornmentComponent.getPreferredSize();
            this.adornmentComponent.setSize(adornDim);
        }
        if (this.roleComponent != null && this.roleComponent.isVisible() && this.roleComponent.getParent() == parent) {
            roleDim = this.roleComponent.getPreferredSize();
            this.roleComponent.setSize(roleDim);
        }
        if (this.cardComponent != null && this.cardComponent.isVisible() && this.cardComponent.getParent() == parent) {
            cardDim = this.cardComponent.getPreferredSize();
            this.cardComponent.setSize(cardDim);
        }
        Dimension preferredDim = this.calculateSize(parent, adornDim, roleDim, cardDim);
        int xOff = 0;
        int yOff = 0;
        int center = 0;
        int alignOffset = 0;
        if (orient == Direction.TOP || orient == Direction.BOTTOM) {
            center = xOff = (bounds.width - preferredDim.width - insets.left - insets.right) / 2 + insets.left;
            if (roleDim != null) {
                center = xOff + roleDim.width + 3;
            }
            if (adornDim != null) {
                center = Math.max(center, xOff + adornDim.width / 2);
            }
            alignOffset = orient == Direction.TOP ? (adornDim != null ? bounds.height - adornDim.height - insets.bottom : bounds.height - insets.bottom) : (adornDim != null ? insets.top + adornDim.height : insets.top);
        } else {
            center = yOff = (bounds.height - preferredDim.height - insets.top - insets.bottom) / 2 + insets.top;
            if (roleDim != null) {
                center = yOff + roleDim.height + 3;
            }
            if (adornDim != null) {
                center = Math.max(center, yOff + adornDim.height / 2);
            }
            alignOffset = orient == Direction.LEFT ? (adornDim != null ? bounds.width - adornDim.width - insets.right : bounds.width - insets.right) : (adornDim != null ? insets.right + adornDim.width : insets.right);
        }
        if (adornDim != null) {
            if (orient == Direction.TOP) {
                this.adornmentComponent.setLocation(center - adornDim.width / 2, alignOffset);
            } else if (orient == Direction.BOTTOM) {
                this.adornmentComponent.setLocation(center - adornDim.width / 2, insets.top);
            } else if (orient == Direction.LEFT) {
                this.adornmentComponent.setLocation(alignOffset, center - adornDim.height / 2);
            } else if (orient == Direction.RIGHT) {
                this.adornmentComponent.setLocation(insets.left, center - adornDim.height / 2);
            }
        }
        if (roleDim != null) {
            if (orient == Direction.TOP) {
                this.roleComponent.setLocation(center - roleDim.width - 3, alignOffset - 3 - roleDim.height);
            } else if (orient == Direction.BOTTOM) {
                this.roleComponent.setLocation(center - roleDim.width - 3, alignOffset + 3);
            } else if (orient == Direction.LEFT) {
                this.roleComponent.setLocation(alignOffset - 3 - roleDim.width, center - roleDim.height - 3);
            } else if (orient == Direction.RIGHT) {
                this.roleComponent.setLocation(alignOffset + 3, center - roleDim.height - 3);
            }
        }
        if (cardDim != null) {
            if (orient == Direction.TOP) {
                this.cardComponent.setLocation(center + 3, alignOffset - 3 - cardDim.height);
            } else if (orient == Direction.BOTTOM) {
                this.cardComponent.setLocation(center + 3, alignOffset + 3);
            } else if (orient == Direction.LEFT) {
                this.cardComponent.setLocation(alignOffset - 3 - cardDim.width, center + 3);
            } else if (orient == Direction.RIGHT) {
                this.cardComponent.setLocation(alignOffset + 3, center + 3);
            }
        }
        Component[] children = parent.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i].isVisible() && children[i] != this.adornmentComponent && children[i] != this.cardComponent && children[i] != this.roleComponent) {
                children[i].setSize(children[i].getPreferredSize());
            }
            ++i;
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void addLayoutComponent(Component comp, Object constraints) {
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    public void invalidateLayout(Container target) {
    }
}

