/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.GrabLayouter;
import de.uni_paderborn.fujaba.fsa.swing.GrabManager;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class RhombGrabLayouter
extends GrabLayouter {
    private static RhombGrabLayouter layouter = null;

    private RhombGrabLayouter() {
    }

    public static GrabLayouter get() {
        if (layouter == null) {
            layouter = new RhombGrabLayouter();
        }
        return layouter;
    }

    public void layout(GrabManager manager) {
        Iterator grabIter = manager.iteratorOfGrabs();
        while (grabIter.hasNext()) {
            JGrab grab = (JGrab)grabIter.next();
            this.layoutGrab(manager, grab);
        }
    }

    protected void layoutGrab(GrabManager manager, JGrab grab) {
        Rectangle bounds = manager.getTarget().getBounds();
        double[] info = this.getPreferredLayoutInformation(grab);
        Direction orientation = Direction.fromInt((int)info[0]);
        Point grabPoint = new Point();
        Rectangle grabBounds = grab.getBounds();
        if (orientation == Direction.TOP) {
            grabPoint.x = bounds.x + (int)((double)(bounds.width - grabBounds.width) / 2.0);
            grabPoint.y = bounds.y - grabBounds.height + 1;
        } else if (orientation == Direction.BOTTOM) {
            grabPoint.x = bounds.x + (int)((double)(bounds.width - grabBounds.width) / 2.0);
            grabPoint.y = bounds.y + bounds.height - 1;
        } else if (orientation == Direction.LEFT) {
            grabPoint.x = bounds.x - grabBounds.width + 1;
            grabPoint.y = bounds.y + (int)((double)(bounds.height - grabBounds.height) / 2.0);
        } else {
            grabPoint.x = bounds.x + bounds.width - 1;
            grabPoint.y = bounds.y + (int)((double)(bounds.height - grabBounds.height) / 2.0);
        }
        Container targetParent = manager.getTarget().getParent();
        Container grabParent = grab.getParent();
        if (targetParent != null && grabParent != null) {
            grabPoint = SwingUtilities.convertPoint(targetParent, grabPoint, grabParent);
        }
        grab.setLocation(grabPoint);
    }
}

