/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.DefaultGrabUI;
import de.uni_paderborn.fujaba.fsa.swing.Direction;
import de.uni_paderborn.fujaba.fsa.swing.GrabConstraints;
import de.uni_paderborn.fujaba.fsa.swing.JArrowHead;
import de.uni_paderborn.fujaba.fsa.swing.JBend;
import de.uni_paderborn.fujaba.fsa.swing.JGrab;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;

public class PanelGrabUI
extends DefaultGrabUI {
    private JBend bend;
    private JComponent grabComponent = null;

    public static ComponentUI createUI(JComponent c) {
        return new PanelGrabUI();
    }

    public JBend getBend() {
        return this.bend;
    }

    public boolean setBend(JBend bend) {
        if (bend != this.bend) {
            if (this.bend != null) {
                this.bend.setUI(null);
            }
            this.bend = bend;
            if (bend != null && bend.getUI() != this) {
                bend.setUI(this);
            }
            return true;
        }
        return false;
    }

    public void setGrabComponent(JComponent c) {
        if (this.grabComponent != c) {
            Container parent;
            if (this.grabComponent != null && this.bend != null) {
                this.bend.remove(this.grabComponent);
            }
            this.grabComponent = c;
            if (c != null && (parent = c.getParent()) != this.bend) {
                if (parent != null) {
                    parent.remove(c);
                }
                if (this.bend != null) {
                    this.bend.add((Component)c, new GrabConstraints((JGrab)this.bend));
                }
            }
            if (this.bend != null) {
                this.bend.resetPoint();
                this.bend.revalidate();
            }
        }
    }

    public JComponent getGrabComponent() {
        return this.grabComponent;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.setBend((JBend)c);
        this.installDefaults();
    }

    public void uninstallUI(JComponent c) {
        if (c == this.bend) {
            super.uninstallUI(c);
            c.removeAll();
            this.bend = null;
        }
    }

    protected void installDefaults() {
        this.bend.setOpaque(false);
        this.bend.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (this.grabComponent != null) {
            JComponent tmp = this.grabComponent;
            this.grabComponent = null;
            this.setGrabComponent(tmp);
        }
    }

    protected Point calculatePoint(JComponent c) {
        Point result = null;
        if (c instanceof JGrab && c.isVisible()) {
            Rectangle bounds = null;
            Direction orientation = ((JGrab)c).getOrientation();
            if (this.grabComponent == null || !this.grabComponent.isVisible()) {
                orientation = orientation.reverse();
            }
            if (this.grabComponent != null) {
                Component comp;
                if (this.grabComponent.getComponentCount() > 0 && (comp = ((JPanel)this.grabComponent).getComponent(0)) instanceof JArrowHead) {
                    ((JArrowHead)comp).setDirection(orientation.reverse());
                }
                result = c.getLocation();
                bounds = this.grabComponent.getBounds();
            } else {
                result = new Point(0, 0);
                bounds = c.getBounds();
            }
            if (orientation == Direction.LEFT) {
                result.x += bounds.x;
                result.y += bounds.y + bounds.height / 2;
            } else if (orientation == Direction.RIGHT) {
                result.x += bounds.x + bounds.width - 1;
                result.y += bounds.y + bounds.height / 2;
            } else if (orientation == Direction.BOTTOM) {
                result.x += bounds.x + bounds.width / 2;
                result.y += bounds.y + bounds.height - 1;
            } else {
                result.x += bounds.x + bounds.width / 2;
                result.y += bounds.y;
            }
        } else {
            result = super.calculatePoint(c);
        }
        return result;
    }

    protected int getTouchOffset(JGrab g) {
        if (this.grabComponent != null) {
            if (g.getOrientation() == Direction.LEFT || g.getOrientation() == Direction.RIGHT) {
                return this.grabComponent.getY();
            }
            return this.grabComponent.getX();
        }
        return super.getTouchOffset(g);
    }

    protected int getTouchLength(JGrab g) {
        if (this.grabComponent != null) {
            if (g.getOrientation() == Direction.LEFT || g.getOrientation() == Direction.RIGHT) {
                return this.grabComponent.getHeight();
            }
            return this.grabComponent.getWidth();
        }
        return super.getTouchLength(g);
    }

    protected int getAlignmentOffset(JGrab g) {
        if (this.grabComponent != null) {
            Rectangle bounds = this.grabComponent.getBounds();
            if (g.getOrientation() == Direction.LEFT || g.getOrientation() == Direction.RIGHT) {
                return bounds.y + bounds.height / 2;
            }
            return bounds.x + bounds.width / 2;
        }
        return super.getAlignmentOffset(g);
    }

    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    public boolean contains(JComponent c, int x, int y) {
        Rectangle bounds = c.getBounds();
        if (x < 0 || bounds.width <= x || y < 0 || bounds.height <= y) {
            return false;
        }
        if (c.isOpaque()) {
            return true;
        }
        Component[] children = c.getComponents();
        int i = 0;
        while (i < children.length) {
            int yOff;
            int xOff;
            if (children[i].isVisible() && children[i].contains(x - (xOff = children[i].getX()), y - (yOff = children[i].getY()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void paint(Graphics g, JComponent c) {
    }
}

