/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.border.OvalBorder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class OvalLayout
implements LayoutManager {
    int verticalGap;
    int borderGap;
    int verticalBorderGap;

    public OvalLayout() {
        this(3, 3, 8);
    }

    public OvalLayout(int verticalGap, int borderGap, int verticalBorderGap) {
        this.verticalGap = verticalGap;
        this.borderGap = borderGap;
        this.verticalBorderGap = verticalBorderGap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            TempLayout tempLayout = new TempLayout(container);
            ComponentInfo[] componentInfos = tempLayout.getComponentInfos();
            int i = 0;
            while (i < componentInfos.length) {
                if (componentInfos[i] != null) {
                    componentInfos[i].component.setBounds(componentInfos[i].bounds);
                }
                ++i;
            }
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            TempLayout tempLayout = new TempLayout(container);
            return tempLayout.getOvalDim();
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public static Insets getInsetsWithoutOval(Container container) {
        Insets insets = container.getInsets();
        if (container instanceof JComponent) {
            Border border = ((JComponent)container).getBorder();
            while (border instanceof CompoundBorder) {
                border = ((CompoundBorder)border).getInsideBorder();
            }
            if (border instanceof OvalBorder) {
                Insets borderInsets = border.getBorderInsets(container);
                insets = new Insets(insets.top - borderInsets.top, insets.left - borderInsets.left, insets.bottom - borderInsets.bottom, insets.right - borderInsets.right);
            }
        }
        return insets;
    }

    private static boolean getInsetsTilBorder(JComponent c, Border thisBorder, Border stopBorder, Insets insets) {
        if (thisBorder != stopBorder) {
            if (thisBorder == null) {
                return true;
            }
            if (thisBorder instanceof CompoundBorder) {
                boolean goon = OvalLayout.getInsetsTilBorder(c, ((CompoundBorder)thisBorder).getOutsideBorder(), stopBorder, insets);
                if (goon) {
                    goon = OvalLayout.getInsetsTilBorder(c, ((CompoundBorder)thisBorder).getInsideBorder(), stopBorder, insets);
                }
                return goon;
            }
            Insets borderInsets = thisBorder.getBorderInsets(c);
            insets.top += borderInsets.top;
            insets.left += borderInsets.left;
            insets.right += borderInsets.right;
            insets.bottom += borderInsets.bottom;
            return true;
        }
        return false;
    }

    public static Insets getInsetsTilBorder(JComponent c, Border stopBorder) {
        Insets insets = new Insets(0, 0, 0, 0);
        OvalLayout.getInsetsTilBorder(c, c.getBorder(), stopBorder, insets);
        return insets;
    }

    private static class ComponentInfo {
        Component component;
        Rectangle bounds;
        int aggregatedWidth;

        ComponentInfo(Component component, int x, int y, int w, int h) {
            this(component, new Rectangle(x, y, w, h));
        }

        ComponentInfo(Component component, Rectangle bounds) {
            this.component = component;
            this.bounds = bounds;
        }
    }

    private class TempLayout {
        private Dimension ovalDim = new Dimension();
        private ComponentInfo[] componentInfos;
        private int yDiff;
        private int yDiffNumber;

        TempLayout(Container container) {
            this(container, false, 0);
        }

        TempLayout(Container container, boolean secondTry, int shift) {
            TempLayout secondLayout;
            int componentCount = container.getComponentCount();
            int visibleComponents = 0;
            int i = 0;
            while (i < componentCount) {
                Component comp = container.getComponent(i);
                if (comp.isVisible()) {
                    ++visibleComponents;
                }
                ++i;
            }
            this.componentInfos = new ComponentInfo[visibleComponents];
            int maxWidth = 0;
            int height = OvalLayout.this.borderGap + OvalLayout.this.verticalBorderGap;
            if (shift > 0) {
                height += shift;
            }
            int k = 0;
            int i2 = 0;
            while (i2 < componentCount) {
                Component comp = container.getComponent(i2);
                if (comp.isVisible()) {
                    Dimension preferredSize = comp.getPreferredSize();
                    this.componentInfos[k] = new ComponentInfo(comp, 0, height, preferredSize.width, preferredSize.height);
                    maxWidth = Math.max(maxWidth, preferredSize.width);
                    height += preferredSize.height;
                    if (k != visibleComponents - 1) {
                        height += OvalLayout.this.verticalGap;
                    }
                    ++k;
                }
                ++i2;
            }
            if (shift < 0) {
                height += -shift;
            }
            this.ovalDim.width = maxWidth + 4;
            this.ovalDim.height = height + OvalLayout.this.borderGap + OvalLayout.this.verticalBorderGap;
            i2 = 0;
            while (i2 < this.componentInfos.length) {
                int newWidth = this.isComponentInsideOval(this.componentInfos[i2], this.ovalDim);
                if (newWidth != -1) {
                    this.ovalDim.width = newWidth;
                }
                ++i2;
            }
            this.ovalDim.width += OvalLayout.this.borderGap * 2;
            Insets insets = OvalLayout.getInsetsWithoutOval(container);
            this.ovalDim.width += insets.left + insets.right;
            this.ovalDim.height += insets.top + insets.bottom;
            int i3 = 0;
            while (i3 < this.componentInfos.length) {
                this.componentInfos[i3].bounds.x = (this.ovalDim.width - this.componentInfos[i3].bounds.width) / 2 + insets.left;
                this.componentInfos[i3].bounds.y += insets.top;
                ++i3;
            }
            int diff = this.getYDiff();
            if (!secondTry && Math.abs(diff) > 4 && Math.abs((secondLayout = new TempLayout(container, true, diff)).getYDiff()) < Math.abs(diff)) {
                this.ovalDim = secondLayout.getOvalDim();
                this.componentInfos = secondLayout.getComponentInfos();
            }
        }

        Dimension getOvalDim() {
            return this.ovalDim;
        }

        ComponentInfo[] getComponentInfos() {
            return this.componentInfos;
        }

        public int getYDiff() {
            return (int)Math.round((double)this.yDiff / (double)this.yDiffNumber);
        }

        private int isComponentInsideOval(ComponentInfo componentInfo, Dimension ovalSize) {
            int result;
            int borderPosAtY1 = (int)Math.ceil(Math.sqrt(Math.pow((double)ovalSize.width / 2.0, 2.0) * (1.0 - Math.pow((double)ovalSize.height / 2.0 - (double)componentInfo.bounds.y, 2.0) / Math.pow(ovalSize.height / 2, 2.0))));
            int borderPosAtY2 = (int)Math.ceil(Math.sqrt(Math.pow((double)ovalSize.width / 2.0, 2.0) * (1.0 - Math.pow((double)ovalSize.height / 2.0 - (double)componentInfo.bounds.y - (double)componentInfo.bounds.height + 1.0, 2.0) / Math.pow(ovalSize.height / 2, 2.0))));
            if (Math.ceil((double)componentInfo.bounds.width / 2.0) > (double)Math.min(borderPosAtY1, borderPosAtY2)) {
                int newWidth1 = (int)(Math.abs((double)ovalSize.height / 2.0 * Math.ceil((double)componentInfo.bounds.width / 2.0)) / Math.sqrt(Math.pow((double)ovalSize.height / 2.0, 2.0) - Math.pow((double)ovalSize.height / 2.0 - (double)componentInfo.bounds.y, 2.0)));
                int newWidth2 = (int)(Math.abs((double)ovalSize.height / 2.0 * Math.ceil((double)componentInfo.bounds.width / 2.0)) / Math.sqrt(Math.pow((double)ovalSize.height / 2.0, 2.0) - Math.pow((double)ovalSize.height / 2.0 - (double)componentInfo.bounds.y - (double)componentInfo.bounds.height, 2.0)));
                result = Math.max(newWidth1, newWidth2) * 2;
            } else {
                result = -1;
            }
            int betterYPos = (int)Math.round(Math.sqrt(Math.pow((double)ovalSize.height / 2.0, 2.0) * (1.0 - Math.pow((double)componentInfo.bounds.width / 2.0, 2.0) / Math.pow((double)ovalSize.width / 2.0, 2.0))));
            if (componentInfo.bounds.y >= ovalSize.height / 2 || componentInfo.bounds.y + componentInfo.bounds.height - 1 <= ovalSize.height / 2 || this.componentInfos.length % 2 == 0) {
                betterYPos = componentInfo.bounds.y + componentInfo.bounds.height / 2 > ovalSize.height / 2 ? (betterYPos += ovalSize.height / 2 - componentInfo.bounds.height / 2) : ovalSize.height / 2 - betterYPos - componentInfo.bounds.height / 2;
                this.yDiff += betterYPos - componentInfo.bounds.y;
                ++this.yDiffNumber;
            }
            return result;
        }
    }
}

