/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.DecoratorLayout;
import de.uni_paderborn.fujaba.fsa.swing.JLine;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class LineDecoratorConstraints
implements DecoratorLayout.Constraints {
    public static final byte CENTER = 0;
    public static final byte LEFT = 1;
    public static final byte RIGHT = 2;
    public static final byte HORIZ_ALIGN = 3;
    public static final byte TOP = 4;
    public static final byte BOTTOM = 8;
    public static final byte VERT_ALIGN = 12;
    public static final byte BORDER_ALIGN = 15;
    public static final byte TOP_LEFT = 5;
    public static final byte TOP_RIGHT = 6;
    public static final byte BOTTOM_LEFT = 9;
    public static final byte BOTTOM_RIGHT = 10;
    private byte decoratorAlignment = 0;
    private byte targetAlignment = (byte)4;
    private double gap = 0.0;
    private double position = 0.5;
    private Component target = null;

    public LineDecoratorConstraints(JLine target, double pos, double gap, byte decAlign, byte targetAlign) {
        this.setDecoratorAlignment(decAlign);
        this.setTargetAlignment(targetAlign);
        this.setPosition(pos);
        this.setGap(gap);
        this.setTarget(target);
    }

    public LineDecoratorConstraints(JLine target, double pos, double gap) {
        this(target, pos, gap, 0, 4);
    }

    public Component getTarget() {
        return this.target;
    }

    public Component setTarget(Component target) {
        if (this.target != target) {
            if (!(target instanceof JLine)) {
                throw new IllegalArgumentException("Target must be a JLine");
            }
            this.target = target;
        }
        return this.target;
    }

    public Point getLocation(Component comp) {
        JLine line = (JLine)this.getTarget();
        if (line == null) {
            return comp.getLocation();
        }
        Point transform = line.getParent() != null && comp.getParent() != null ? SwingUtilities.convertPoint(line.getParent(), 0, 0, comp.getParent()) : new Point(0, 0);
        Point2D linePos = line.getPointAt(this.getPosition());
        double posX = linePos.getX() + (double)transform.x;
        double posY = linePos.getY() + (double)transform.y;
        double angle = line.getAngle(this.getPosition());
        Point2D n = line.getNormal(this.getPosition());
        double nx = n.getX();
        double ny = n.getY();
        Dimension compDim = comp.getSize();
        if (this.gap != 0.0) {
            int sign = 0;
            if ((this.targetAlignment & 4) != 0) {
                sign = 1;
            } else if ((this.targetAlignment & 8) != 0) {
                sign = -1;
            }
            if (sign != 0) {
                if (angle > 4.71238898038469 || angle <= 1.5707963267948966) {
                    posX -= (double)sign * nx * this.gap;
                    posY -= (double)sign * ny * this.gap;
                } else {
                    posX += (double)sign * nx * this.gap;
                    posY += (double)sign * ny * this.gap;
                }
            }
        }
        byte align = this.decoratorAlignment;
        if ((this.decoratorAlignment & 3) == 3) {
            align = nx == 0.0 ? (byte)(align & 0xFFFFFFFC) : (angle < 1.5324842212633139 || angle > Math.PI && angle < 4.5553093477052 ? (byte)(align & 0xFFFFFFFD) : (angle >= 1.5324842212633139 && angle <= 1.6110731556870734 || angle >= 4.5553093477052 && angle <= 4.869468613064179 ? ((this.targetAlignment & 8) == 8 ? (byte)(align & 0xFFFFFFFE) : (byte)(align & 0xFFFFFFFD)) : (byte)(align & 0xFFFFFFFE)));
        }
        if ((this.decoratorAlignment & 0xC) == 12) {
            align = Math.abs(ny) <= 0.02 ? (byte)(align & 0xFFFFFFF3) : (byte)(align & 0xFFFFFFFB);
        }
        double compX = (align & 3) == 0 ? (double)compDim.width / 2.0 : ((align & 1) != 0 ? 0.0 : (double)compDim.width);
        double compY = (align & 0xC) == 0 ? (double)compDim.height / 2.0 : ((align & 4) != 0 ? 0.0 : (double)compDim.height);
        return new Point((int)Math.rint(posX - compX), (int)Math.rint(posY - compY));
    }

    public double getPosition() {
        return this.position;
    }

    public double setPosition(double position) {
        if (this.position != position) {
            if (position < 0.0 || position > 1.0) {
                throw new IllegalArgumentException("Position must be between 0 and 1");
            }
            this.position = position;
        }
        return this.position;
    }

    public byte getDecoratorAlignment() {
        return this.decoratorAlignment;
    }

    public byte setDecoratorAlignment(byte decoratorAlignment) {
        if (this.decoratorAlignment != decoratorAlignment) {
            if ((decoratorAlignment & 0xF) != decoratorAlignment) {
                throw new IllegalArgumentException("Decorator alignment invalid");
            }
            this.decoratorAlignment = decoratorAlignment;
        }
        return this.decoratorAlignment;
    }

    public byte getTargetAlignment() {
        return this.targetAlignment;
    }

    public byte setTargetAlignment(byte targetAlignment) {
        if (this.targetAlignment != targetAlignment) {
            if (targetAlignment != 0 && targetAlignment != 4 && targetAlignment != 8) {
                throw new IllegalArgumentException("Target alignment must be one of CENTER, TOP or BOTTOM");
            }
            this.targetAlignment = targetAlignment;
        }
        return this.targetAlignment;
    }

    public double getGap() {
        return this.gap;
    }

    public double setGap(double gap) {
        if (this.gap != gap) {
            this.gap = gap;
        }
        return this.gap;
    }

    public void removeYou() {
        this.setTarget(null);
    }
}

