/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class LayerManager {
    public static final String ELEMENT_LAYER_NAME = "elementLayer";
    public static final String BEND_LAYER_NAME = "bendLayer";
    public static final String LINE_LAYER_NAME = "lineLayer";
    public static final Integer DEFAULT_ELEMENT_LAYER = JLayeredPane.DEFAULT_LAYER;
    public static final Integer DEFAULT_BEND_LAYER = new Integer(DEFAULT_ELEMENT_LAYER - 10);
    public static final Integer DEFAULT_LINE_LAYER = new Integer(DEFAULT_BEND_LAYER - 10);
    public static final Integer DEFAULT_ELEMENT_DRAG_LAYER = JLayeredPane.DRAG_LAYER;
    public static final Integer DEFAULT_BEND_DRAG_LAYER = new Integer(DEFAULT_ELEMENT_DRAG_LAYER - 10);
    public static final Integer DEFAULT_LINE_DRAG_LAYER = new Integer(DEFAULT_BEND_DRAG_LAYER - 10);
    private static final String LAYER_NAME_PROPERTY;
    public static final String DRAG_LAYER_PREFIX = "DRAG_";
    private static LayerManager singleton;
    private String defaultLayerType;
    private Integer defaultLayer;
    private Integer defaultDragLayer;
    private FHashMap layerTypes;
    private FHashMap layerPositions;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.uni_paderborn.fujaba.fsa.swing.LayerManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LAYER_NAME_PROPERTY = String.valueOf(clazz.getName()) + ".LAYER_NAME_PROPERTY";
        singleton = null;
    }

    public static LayerManager get() {
        if (singleton == null) {
            new LayerManager();
        }
        return singleton;
    }

    protected LayerManager() {
        if (singleton != null) {
            throw new IllegalStateException("An instance of this singleton class already exists: " + singleton.getClass().getName());
        }
        singleton = this;
    }

    public void setDefaults() {
        this.addToLayerPositions(ELEMENT_LAYER_NAME, DEFAULT_ELEMENT_LAYER);
        this.addToLayerPositions("DRAG_elementLayer", DEFAULT_ELEMENT_DRAG_LAYER);
        this.setDefaultLayer(DEFAULT_ELEMENT_LAYER);
        this.setDefaultLayerType(ELEMENT_LAYER_NAME);
        this.addToLayerPositions(BEND_LAYER_NAME, DEFAULT_BEND_LAYER);
        this.addToLayerPositions("DRAG_bendLayer", DEFAULT_BEND_DRAG_LAYER);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("de.uni_paderborn.fujaba.fsa.swing.JBend");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToLayerTypes(clazz, BEND_LAYER_NAME);
        this.addToLayerPositions(LINE_LAYER_NAME, DEFAULT_LINE_LAYER);
        this.addToLayerPositions("DRAG_lineLayer", DEFAULT_LINE_DRAG_LAYER);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("de.uni_paderborn.fujaba.fsa.swing.JLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addToLayerTypes(clazz2, LINE_LAYER_NAME);
    }

    public int getLayer(JComponent comp) {
        String layerType = this.getLayerType(comp);
        Integer layer = this.getLayer(layerType, false);
        return layer;
    }

    public int getDragLayer(JComponent comp) {
        String layerType = DRAG_LAYER_PREFIX + this.getLayerType(comp);
        Integer layer = this.getLayer(layerType, true);
        return layer;
    }

    public String getLayerType(JComponent comp) {
        String layerType = (String)comp.getClientProperty(LAYER_NAME_PROPERTY);
        if (layerType == null && (layerType = this.getFromLayerTypes(comp.getClass())) == null) {
            layerType = this.getDefaultLayerType();
        }
        return layerType;
    }

    public static void setLayerType(JComponent comp, String name) {
        comp.putClientProperty(LAYER_NAME_PROPERTY, name);
    }

    private Integer getLayer(String layerType, boolean drag) {
        Integer layer = null;
        if (layerType != null) {
            layer = this.getFromLayerPositions(layerType);
        }
        if (layer == null) {
            layer = drag ? this.getDefaultDragLayer() : this.getDefaultLayer();
        }
        return layer;
    }

    public boolean setDefaultLayerType(String value) {
        if (value == null || !value.equals(this.defaultLayerType)) {
            this.defaultLayerType = value;
            return true;
        }
        return false;
    }

    public String getDefaultLayerType() {
        return this.defaultLayerType;
    }

    public boolean setDefaultLayer(Integer value) {
        if (value == null || !value.equals(this.defaultLayer)) {
            this.defaultLayer = value;
            return true;
        }
        return false;
    }

    public Integer getDefaultLayer() {
        return this.defaultLayer == null ? JLayeredPane.DEFAULT_LAYER : this.defaultLayer;
    }

    public boolean setDefaultDragLayer(Integer value) {
        if (value == null || !value.equals(this.defaultDragLayer)) {
            this.defaultDragLayer = value;
            return true;
        }
        return false;
    }

    public Integer getDefaultDragLayer() {
        return this.defaultDragLayer == null ? JLayeredPane.DRAG_LAYER : this.defaultDragLayer;
    }

    public boolean hasInLayerTypes(String value) {
        return this.layerTypes != null && value != null && this.layerTypes.containsValue(value);
    }

    public boolean hasInLayerTypes(Class key, String value) {
        return this.layerTypes != null && value != null && key != null && this.layerTypes.get(key) == value;
    }

    public boolean hasKeyInLayerTypes(Class key) {
        return this.layerTypes != null && key != null && this.layerTypes.containsKey(key);
    }

    public Iterator iteratorOfLayerTypes() {
        return this.layerTypes == null ? FEmptyIterator.get() : this.layerTypes.values().iterator();
    }

    public Iterator keysOfLayerTypes() {
        return this.layerTypes == null ? FEmptyIterator.get() : this.layerTypes.keySet().iterator();
    }

    public Iterator entriesOfLayerTypes() {
        return this.layerTypes == null ? FEmptyIterator.get() : this.layerTypes.entrySet().iterator();
    }

    public int sizeOfLayerTypes() {
        return this.layerTypes == null ? 0 : this.layerTypes.size();
    }

    public String getFromLayerTypes(Class key) {
        return this.layerTypes == null || key == null ? null : (String)this.layerTypes.get(key);
    }

    public boolean addToLayerTypes(Class key, String value) {
        boolean changed = false;
        if (value != null && key != null) {
            String oldValue;
            if (this.layerTypes == null) {
                this.layerTypes = new FHashMap();
            }
            if (!value.equals(oldValue = (String)this.layerTypes.put(key, value))) {
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeFromLayerTypes(String value) {
        boolean changed = false;
        if (this.layerTypes != null && value != null) {
            Iterator iter = this.entriesOfLayerTypes();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (entry.getValue() != value) continue;
                boolean bl = changed = changed || this.removeFromLayerTypes((Class)entry.getKey(), value);
            }
        }
        return changed;
    }

    public boolean removeFromLayerTypes(Class key, String value) {
        String oldValue;
        boolean changed = false;
        if (this.layerTypes != null && value != null && key != null && value.equals(oldValue = (String)this.layerTypes.get(key))) {
            this.layerTypes.remove(key);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromLayerTypes(Class key) {
        String tmpValue;
        boolean changed = false;
        if (this.layerTypes != null && key != null && (tmpValue = (String)this.layerTypes.get(key)) != null) {
            this.layerTypes.remove(key);
            changed = true;
        }
        return changed;
    }

    public void removeAllFromLayerTypes() {
        Iterator iter = this.entriesOfLayerTypes();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            this.removeFromLayerTypes((Class)entry.getKey(), (String)entry.getValue());
        }
    }

    public boolean hasInLayerPositions(Integer value) {
        return this.layerPositions != null && value != null && this.layerPositions.containsValue(value);
    }

    public boolean hasInLayerPositions(String key, Integer value) {
        return this.layerPositions != null && value != null && key != null && this.layerPositions.get(key) == value;
    }

    public boolean hasKeyInLayerPositions(String key) {
        return this.layerPositions != null && key != null && this.layerPositions.containsKey(key);
    }

    public Iterator iteratorOfLayerPositions() {
        return this.layerPositions == null ? FEmptyIterator.get() : this.layerPositions.values().iterator();
    }

    public Iterator keysOfLayerPositions() {
        return this.layerPositions == null ? FEmptyIterator.get() : this.layerPositions.keySet().iterator();
    }

    public Iterator entriesOfLayerPositions() {
        return this.layerPositions == null ? FEmptyIterator.get() : this.layerPositions.entrySet().iterator();
    }

    public int sizeOfLayerPositions() {
        return this.layerPositions == null ? 0 : this.layerPositions.size();
    }

    public Integer getFromLayerPositions(String key) {
        return this.layerPositions == null || key == null ? null : (Integer)this.layerPositions.get(key);
    }

    public boolean addToLayerPositions(String key, Integer value) {
        boolean changed = false;
        if (value != null && key != null) {
            Integer oldValue;
            if (this.layerPositions == null) {
                this.layerPositions = new FHashMap();
            }
            if (!value.equals(oldValue = (Integer)this.layerPositions.put(key, value))) {
                changed = true;
            }
        }
        return changed;
    }

    public boolean removeFromLayerPositions(Integer value) {
        boolean changed = false;
        if (this.layerPositions != null && value != null) {
            Iterator iter = this.entriesOfLayerPositions();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (entry.getValue() != value) continue;
                boolean bl = changed = changed || this.removeFromLayerPositions((String)entry.getKey(), value);
            }
        }
        return changed;
    }

    public boolean removeFromLayerPositions(String key, Integer value) {
        Integer oldValue;
        boolean changed = false;
        if (this.layerPositions != null && value != null && key != null && value.equals(oldValue = (Integer)this.layerPositions.get(key))) {
            this.layerPositions.remove(key);
            changed = true;
        }
        return changed;
    }

    public boolean removeKeyFromLayerPositions(String key) {
        Integer tmpValue;
        boolean changed = false;
        if (this.layerPositions != null && key != null && (tmpValue = (Integer)this.layerPositions.get(key)) != null) {
            this.layerPositions.remove(key);
            changed = true;
        }
        return changed;
    }

    public void removeAllFromLayerPositions() {
        Iterator iter = this.entriesOfLayerPositions();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            this.removeFromLayerPositions((String)entry.getKey(), (Integer)entry.getValue());
        }
    }
}

