/*
 * Decompiled with CFR 0.152.
 */
package de.uni_paderborn.fujaba.fsa.swing;

import de.uni_paderborn.fujaba.fsa.swing.JArrowHead;
import de.uni_paderborn.fujaba.fsa.swing.JTriangleHead;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.Iterator;

public class JTriangleHeadWithTail
extends JArrowHead {
    private static final int DEFAULT_WIDTH = 13;
    private static final int DEFAULT_HEIGHT = 26;
    protected boolean doubleArrow = false;

    public JTriangleHeadWithTail() {
        this(26);
    }

    public JTriangleHeadWithTail(int size) {
        this(size * 13 / 26, size, true);
    }

    public JTriangleHeadWithTail(int size, boolean filled) {
        this(size * 13 / 26, size, filled);
    }

    public JTriangleHeadWithTail(int width, int height, boolean filled) {
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(height, height));
        this.setFilled(filled);
        int[] nArray = new int[7];
        nArray[0] = (height - 1) / 2;
        nArray[2] = (height - 1) / 2;
        nArray[3] = (height - 1) / 2;
        nArray[4] = height - 1;
        nArray[5] = height - 1;
        nArray[6] = (height - 1) / 2;
        this.getShapeList().add(new Polygon(new int[]{(height - width) / 2, (height - 1) / 2, (height + width - 2) / 2, (height - 1) / 2, (height - 1) / 2, (height - 1) / 2 + 1, (height - 1) / 2 + 1}, nArray, 7));
        this.getShapeList().add(new Polygon(new int[]{(height - width) / 2, (height - 1) / 2, (height + width - 2) / 2}, new int[]{(height - 1) * 3 / 4, (height - 1) / 4, (height - 1) * 3 / 4}, 3));
    }

    public void paintArrow(Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(this.getForeground());
        Iterator iter = this.getShapeList().iterator();
        do {
            Polygon shape = (Polygon)iter.next();
            Graphics2D g2d = (Graphics2D)g;
            if (this.getFilled()) {
                g2d.fill(this.at.createTransformedShape(shape));
                continue;
            }
            g.setColor(this.getBackground());
            g2d.fill(this.at.createTransformedShape(shape));
            g.setColor(this.getForeground());
            g2d.draw(this.at.createTransformedShape(shape));
        } while (iter.hasNext() && this.doubleArrow);
        g.setColor(oldColor);
    }

    public Object clone() {
        return new JTriangleHead(this.getWidth(), this.getHeight(), this.getFilled());
    }
}

